/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.core.components.presented;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.text.method.LinkMovementMethod;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.google.android.material.R;
import com.google.android.material.snackbar.Snackbar;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.ResourcesExtensionsKt;
import tech.skot.core.SKLog;
import tech.skot.core.components.SKActivity;
import tech.skot.core.components.SKComponentView;
import tech.skot.core.components.presented.SKSnackBarVC;
import tech.skot.core.components.presented.SKSnackBarViewProxy;
import tech.skot.core.view.Color;
import tech.skot.core.view.Icon;
import tech.skot.core.view.Resource;
import tech.skot.core.view.SKSpan;
import tech.skot.core.view.SpannedStringKt;
import tech.skot.viewlegacy.R;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0002X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0017\u001a\u00020\u0018*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Ltech/skot/core/components/presented/SKSnackBarView;", "Ltech/skot/core/components/SKComponentView;", "Landroid/view/View;", "proxy", "Ltech/skot/core/components/presented/SKSnackBarViewProxy;", "activity", "Ltech/skot/core/components/SKActivity;", "fragment", "Landroidx/fragment/app/Fragment;", "rootView", "(Ltech/skot/core/components/presented/SKSnackBarViewProxy;Ltech/skot/core/components/SKActivity;Landroidx/fragment/app/Fragment;Landroid/view/View;)V", "anchor", "getAnchor", "()Landroid/view/View;", "setAnchor", "(Landroid/view/View;)V", "container", "getContainer", "setContainer", "current", "Ltech/skot/core/components/presented/SKSnackBarView$State;", "getProxy", "()Ltech/skot/core/components/presented/SKSnackBarViewProxy;", "toPx", "", "", "getToPx", "(Ljava/lang/Number;)F", "onState", "", "state", "Ltech/skot/core/components/presented/SKSnackBarVC$Shown;", "State", "viewlegacy_release"})
public final class SKSnackBarView
extends SKComponentView<View> {
    @NotNull
    private final SKSnackBarViewProxy proxy;
    @NotNull
    private final View rootView;
    @Nullable
    private State current;
    @Nullable
    private View anchor;
    @Nullable
    private View container;

    public SKSnackBarView(@NotNull SKSnackBarViewProxy proxy, @NotNull SKActivity activity, @Nullable Fragment fragment, @NotNull View rootView) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)((Object)activity), (String)"activity");
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        super(proxy, activity, fragment, rootView);
        this.proxy = proxy;
        this.rootView = rootView;
        this.getLifecycleOwner().getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(){

            public void onPause(@NotNull LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                super.onPause(owner);
                State state = current;
                if (state != null && (state = state.getSnack()) != null) {
                    state.dismiss();
                }
                current = null;
                this.getProxy().setState(null);
            }
        });
    }

    @NotNull
    public SKSnackBarViewProxy getProxy() {
        return this.proxy;
    }

    @Nullable
    public final View getAnchor() {
        return this.anchor;
    }

    public final void setAnchor(@Nullable View view) {
        this.anchor = view;
    }

    @Nullable
    public final View getContainer() {
        return this.container;
    }

    public final void setContainer(@Nullable View view) {
        this.container = view;
    }

    public final void onState(@Nullable SKSnackBarVC.Shown state) {
        State state2 = this.current;
        if (!Intrinsics.areEqual((Object)state, (Object)(state2 != null ? state2.getState() : null))) {
            if (state != null) {
                Snackbar snackbar;
                View view = this.container;
                if (view == null) {
                    view = this.getBaseView();
                }
                Snackbar $this$onState_u24lambda_u2415 = snackbar = Snackbar.make((View)view, (CharSequence)SpannedStringKt.toCharSequence(state.getMessage(), this.getContext()), (int)-2);
                boolean bl = false;
                if (state.getSlideAnimation()) {
                    $this$onState_u24lambda_u2415.setAnimationMode(0);
                }
                if (state.getLeftIcon() != null || state.getRightIcon() != null || state.getInfiniteLines() || state.getCenterText()) {
                    try {
                        boolean bl2;
                        TextView $this$onState_u24lambda_u2415_u24lambda_u241;
                        block36: {
                            View view2 = $this$onState_u24lambda_u2415.getView().findViewById(R.id.snackbar_text);
                            $this$onState_u24lambda_u2415_u24lambda_u241 = (TextView)view2;
                            boolean bl3 = false;
                            Iterable $this$any$iv = state.getMessage();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    SKSpan it = (SKSpan)element$iv;
                                    boolean bl4 = false;
                                    if (!(it.getFormat().getOnTap() != null)) continue;
                                    bl2 = true;
                                    break block36;
                                }
                                bl2 = false;
                            }
                        }
                        if (bl2) {
                            $this$onState_u24lambda_u2415_u24lambda_u241.setMovementMethod(LinkMovementMethod.getInstance());
                            $this$onState_u24lambda_u2415_u24lambda_u241.setHighlightColor(0);
                        }
                        if (state.getInfiniteLines()) {
                            $this$onState_u24lambda_u2415_u24lambda_u241.setSingleLine(false);
                        }
                        if (state.getLeftIcon() != null || state.getRightIcon() != null) {
                            Icon icon = state.getLeftIcon();
                            Icon icon2 = state.getRightIcon();
                            $this$onState_u24lambda_u2415_u24lambda_u241.setCompoundDrawablesWithIntrinsicBounds(icon != null ? icon.getRes() : 0, 0, icon2 != null ? icon2.getRes() : 0, 0);
                            $this$onState_u24lambda_u2415_u24lambda_u241.setCompoundDrawablePadding($this$onState_u24lambda_u2415_u24lambda_u241.getResources().getDimensionPixelOffset(R.dimen.sk_snackbar_icon_padding));
                        }
                        if (state.getCenterText()) {
                            $this$onState_u24lambda_u2415_u24lambda_u241.setGravity(1);
                        }
                    }
                    catch (Exception ex) {
                        SKLog.INSTANCE.e((Throwable)ex, "Problem on settings images to Snack");
                    }
                }
                Resource resource = state.getBackground();
                if (resource != null) {
                    Resource bg = resource;
                    boolean bl5 = false;
                    View view3 = $this$onState_u24lambda_u2415.getView();
                    Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view");
                    ResourcesExtensionsKt.setBackground(view3, bg);
                }
                Color color = state.getTextColor();
                if (color != null) {
                    Color it = color;
                    boolean bl6 = false;
                    Context context = $this$onState_u24lambda_u2415.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                    $this$onState_u24lambda_u2415.setTextColor(ResourcesExtensionsKt.toColor(it, context));
                }
                SKSnackBarVC.Action action = state.getAction();
                if (action != null) {
                    SKSnackBarVC.Action it = action;
                    boolean bl7 = false;
                    String label = it.component1();
                    Function0 action2 = it.component2();
                    $this$onState_u24lambda_u2415.setAction((CharSequence)label, arg_0 -> SKSnackBarView.onState$lambda$15$lambda$5$lambda$4(action2, this, arg_0));
                }
                SKSnackBarVC.Position position = state.getPosition();
                if (!Intrinsics.areEqual((Object)position, (Object)SKSnackBarVC.Position.Bottom.INSTANCE)) {
                    FrameLayout.LayoutParams it;
                    View view4;
                    if (position instanceof SKSnackBarVC.Position.BottomWithCustomMargin) {
                        View $this$onState_u24lambda_u2415_u24lambda_u247 = view4 = $this$onState_u24lambda_u2415.getView();
                        boolean bl8 = false;
                        ViewGroup.LayoutParams layoutParams = $this$onState_u24lambda_u2415_u24lambda_u247.getLayoutParams();
                        FrameLayout.LayoutParams layoutParams2 = layoutParams instanceof FrameLayout.LayoutParams ? (FrameLayout.LayoutParams)layoutParams : null;
                        if (layoutParams2 != null) {
                            it = layoutParams2;
                            boolean bl9 = false;
                            if (Build.VERSION.SDK_INT >= 23) {
                                it.bottomMargin = (int)this.getToPx(((SKSnackBarVC.Position.BottomWithCustomMargin)position).getMargin());
                            }
                            $this$onState_u24lambda_u2415_u24lambda_u247.setLayoutParams((ViewGroup.LayoutParams)it);
                        }
                    } else if (Intrinsics.areEqual((Object)position, (Object)SKSnackBarVC.Position.TopWithInsetMargin.INSTANCE)) {
                        View $this$onState_u24lambda_u2415_u24lambda_u249 = view4 = $this$onState_u24lambda_u2415.getView();
                        boolean bl10 = false;
                        ViewGroup.LayoutParams layoutParams = $this$onState_u24lambda_u2415_u24lambda_u249.getLayoutParams();
                        FrameLayout.LayoutParams layoutParams3 = layoutParams instanceof FrameLayout.LayoutParams ? (FrameLayout.LayoutParams)layoutParams : null;
                        if (layoutParams3 != null) {
                            it = layoutParams3;
                            boolean bl11 = false;
                            it.gravity = 48;
                            if (Build.VERSION.SDK_INT >= 23) {
                                WindowInsets windowInsets = this.getBaseView().getRootWindowInsets();
                                it.topMargin = windowInsets != null ? windowInsets.getSystemWindowInsetTop() : 0;
                            }
                            $this$onState_u24lambda_u2415_u24lambda_u249.setLayoutParams((ViewGroup.LayoutParams)it);
                        }
                    } else if (Intrinsics.areEqual((Object)position, (Object)SKSnackBarVC.Position.TopWithInsetPadding.INSTANCE)) {
                        View $this$onState_u24lambda_u2415_u24lambda_u2411 = view4 = $this$onState_u24lambda_u2415.getView();
                        boolean bl12 = false;
                        ViewGroup.LayoutParams layoutParams = $this$onState_u24lambda_u2415_u24lambda_u2411.getLayoutParams();
                        FrameLayout.LayoutParams layoutParams4 = layoutParams instanceof FrameLayout.LayoutParams ? (FrameLayout.LayoutParams)layoutParams : null;
                        if (layoutParams4 != null) {
                            it = layoutParams4;
                            boolean bl13 = false;
                            it.gravity = 48;
                            if (Build.VERSION.SDK_INT >= 23) {
                                WindowInsets windowInsets = this.getBaseView().getRootWindowInsets();
                                $this$onState_u24lambda_u2415.getView().setPadding($this$onState_u24lambda_u2415.getView().getPaddingLeft(), $this$onState_u24lambda_u2415.getView().getPaddingTop() + (windowInsets != null ? windowInsets.getSystemWindowInsetTop() : 0), $this$onState_u24lambda_u2415.getView().getPaddingRight(), $this$onState_u24lambda_u2415.getView().getPaddingBottom());
                            }
                            $this$onState_u24lambda_u2415_u24lambda_u2411.setLayoutParams((ViewGroup.LayoutParams)it);
                        }
                    } else if (position instanceof SKSnackBarVC.Position.TopWithCustomMargin) {
                        View $this$onState_u24lambda_u2415_u24lambda_u2413 = view4 = $this$onState_u24lambda_u2415.getView();
                        boolean bl14 = false;
                        ViewGroup.LayoutParams layoutParams = $this$onState_u24lambda_u2415_u24lambda_u2413.getLayoutParams();
                        FrameLayout.LayoutParams layoutParams5 = layoutParams instanceof FrameLayout.LayoutParams ? (FrameLayout.LayoutParams)layoutParams : null;
                        if (layoutParams5 != null) {
                            it = layoutParams5;
                            boolean bl15 = false;
                            it.gravity = 48;
                            if (Build.VERSION.SDK_INT >= 23) {
                                it.topMargin = (int)this.getToPx(((SKSnackBarVC.Position.TopWithCustomMargin)position).getMargin());
                            }
                            $this$onState_u24lambda_u2415_u24lambda_u2413.setLayoutParams((ViewGroup.LayoutParams)it);
                        }
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)$this$onState_u24lambda_u2415, (String)"this");
                this.current = new State(state, $this$onState_u24lambda_u2415);
                View view5 = this.anchor;
                if (view5 != null) {
                    View it = view5;
                    boolean bl16 = false;
                    Snackbar cfr_ignored_0 = (Snackbar)$this$onState_u24lambda_u2415.setAnchorView(it);
                }
                $this$onState_u24lambda_u2415.show();
            } else {
                State state3 = this.current;
                if (state3 != null && (state3 = state3.getSnack()) != null) {
                    state3.dismiss();
                }
                this.current = null;
            }
        }
    }

    public final float getToPx(@NotNull Number $this$toPx) {
        Intrinsics.checkNotNullParameter((Object)$this$toPx, (String)"<this>");
        return TypedValue.applyDimension((int)1, (float)$this$toPx.floatValue(), (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    private static final void onState$lambda$15$lambda$5$lambda$4(Function0 $action, SKSnackBarView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $action.invoke();
        this$0.getProxy().setState(null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Ltech/skot/core/components/presented/SKSnackBarView$State;", "", "state", "Ltech/skot/core/components/presented/SKSnackBarVC$Shown;", "snack", "Lcom/google/android/material/snackbar/Snackbar;", "(Ltech/skot/core/components/presented/SKSnackBarVC$Shown;Lcom/google/android/material/snackbar/Snackbar;)V", "getSnack", "()Lcom/google/android/material/snackbar/Snackbar;", "getState", "()Ltech/skot/core/components/presented/SKSnackBarVC$Shown;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "viewlegacy_release"})
    public static final class State {
        @NotNull
        private final SKSnackBarVC.Shown state;
        @NotNull
        private final Snackbar snack;

        public State(@NotNull SKSnackBarVC.Shown state, @NotNull Snackbar snack) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)snack, (String)"snack");
            this.state = state;
            this.snack = snack;
        }

        @NotNull
        public final SKSnackBarVC.Shown getState() {
            return this.state;
        }

        @NotNull
        public final Snackbar getSnack() {
            return this.snack;
        }

        @NotNull
        public final SKSnackBarVC.Shown component1() {
            return this.state;
        }

        @NotNull
        public final Snackbar component2() {
            return this.snack;
        }

        @NotNull
        public final State copy(@NotNull SKSnackBarVC.Shown state, @NotNull Snackbar snack) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)snack, (String)"snack");
            return new State(state, snack);
        }

        public static /* synthetic */ State copy$default(State state, SKSnackBarVC.Shown shown, Snackbar snackbar, int n, Object object) {
            if ((n & 1) != 0) {
                shown = state.state;
            }
            if ((n & 2) != 0) {
                snackbar = state.snack;
            }
            return state.copy(shown, snackbar);
        }

        @NotNull
        public String toString() {
            return "State(state=" + this.state + ", snack=" + this.snack + ')';
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = result * 31 + this.snack.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (!Intrinsics.areEqual((Object)this.state, (Object)state.state)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.snack, (Object)state.snack);
        }
    }
}

