/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.core.components;

import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.viewbinding.ViewBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.ResourcesExtensionsKt;
import tech.skot.core.SKLog;
import tech.skot.core.components.SKActivity;
import tech.skot.core.components.SKComponentVC;
import tech.skot.core.components.SKComponentView;
import tech.skot.core.components.SKComponentViewProxy;
import tech.skot.core.components.ScreensManager;
import tech.skot.core.view.Color;
import tech.skot.view.SKPermissionAndroid;
import tech.skot.view.SKPermissionsRequestResultAndroid;
import tech.skot.view.live.SKLifecycle;
import tech.skot.view.live.SKLifecycleOwner;
import tech.skot.view.live.SKLiveData;
import tech.skot.view.live.SKMessage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 L*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0001LB-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\nJ\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020$H\u0002J\u0006\u00102\u001a\u000200J\u000e\u00103\u001a\u0002002\u0006\u00104\u001a\u000205J\b\u00106\u001a\u000200H\u0017J\u000e\u00107\u001a\u0002002\u0006\u00101\u001a\u00020$J-\u00108\u001a\u0002002#\u00109\u001a\u001f\u0012\u0013\u0012\u00110;\u00a2\u0006\f\b<\u0012\b\b=\u0012\u0004\b\b(>\u0012\u0004\u0012\u000200\u0018\u00010:H\u0004J\f\u0010?\u001a\u00020@*\u00020AH\u0002J*\u0010B\u001a\u000200\"\u0004\b\u0001\u0010C*\b\u0012\u0004\u0012\u0002HC0D2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u0002HC\u0012\u0004\u0012\u0002000:J*\u0010B\u001a\u000200\"\u0004\b\u0001\u0010C*\b\u0012\u0004\u0012\u0002HC0F2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u0002HC\u0012\u0004\u0012\u0002000:J\u0012\u0010H\u001a\u000200*\u00020I2\u0006\u0010J\u001a\u00020KR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R%\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000#8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b,\u0010&\u00a8\u0006M"}, d2={"Ltech/skot/core/components/SKComponentView;", "B", "", "proxy", "Ltech/skot/core/components/SKComponentViewProxy;", "activity", "Ltech/skot/core/components/SKActivity;", "fragment", "Landroidx/fragment/app/Fragment;", "binding", "(Ltech/skot/core/components/SKComponentViewProxy;Ltech/skot/core/components/SKActivity;Landroidx/fragment/app/Fragment;Ljava/lang/Object;)V", "getActivity", "()Ltech/skot/core/components/SKActivity;", "baseLifecycle", "Landroidx/lifecycle/Lifecycle;", "getBinding", "()Ljava/lang/Object;", "Ljava/lang/Object;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "getFragment", "()Landroidx/fragment/app/Fragment;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "getFragmentManager", "()Landroidx/fragment/app/FragmentManager;", "lifecycleOwner", "Ltech/skot/view/live/SKLifecycleOwner;", "getLifecycleOwner", "()Ltech/skot/view/live/SKLifecycleOwner;", "setLifecycleOwner", "(Ltech/skot/view/live/SKLifecycleOwner;)V", "pendingPermissionsRequests", "", "Ltech/skot/core/components/SKComponentViewProxy$PermissionsRequest;", "getPendingPermissionsRequests", "()Ljava/util/List;", "setPendingPermissionsRequests", "(Ljava/util/List;)V", "getProxy", "()Ltech/skot/core/components/SKComponentViewProxy;", "subViews", "getSubViews", "subViews$delegate", "Lkotlin/Lazy;", "addPendingPermissionsRequest", "", "permissionsRequest", "closeKeyboard", "displayMessage", "message", "Ltech/skot/core/components/SKComponentVC$Message;", "onRecycle", "requestPermissions", "setOnWindowInset", "onWindowInset", "Lkotlin/Function1;", "Landroid/view/WindowInsets;", "Lkotlin/ParameterName;", "name", "windowInsets", "isGranted", "", "Ltech/skot/view/SKPermissionAndroid;", "observe", "D", "Ltech/skot/view/live/SKLiveData;", "onChanged", "Ltech/skot/view/live/SKMessage;", "onReceive", "setTextColor", "Landroid/widget/TextView;", "color", "Ltech/skot/core/view/Color;", "Companion", "viewlegacy_release"})
public abstract class SKComponentView<B> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SKComponentViewProxy<B> proxy;
    @NotNull
    private final SKActivity activity;
    @Nullable
    private final Fragment fragment;
    @NotNull
    private final B binding;
    @NotNull
    private final Context context;
    @NotNull
    private final Lifecycle baseLifecycle;
    @NotNull
    private SKLifecycleOwner lifecycleOwner;
    @NotNull
    private final Lazy subViews$delegate;
    @Nullable
    private List<SKComponentViewProxy.PermissionsRequest> pendingPermissionsRequests;
    @Nullable
    private static Function2<? super SKComponentView<?>, ? super SKComponentVC.Message, Unit> displayMessage;

    public SKComponentView(@NotNull SKComponentViewProxy<B> proxy, @NotNull SKActivity activity, @Nullable Fragment fragment, @NotNull B binding) {
        Lifecycle lifecycle;
        Object object;
        Intrinsics.checkNotNullParameter(proxy, (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)((Object)activity), (String)"activity");
        Intrinsics.checkNotNullParameter(binding, (String)"binding");
        this.proxy = proxy;
        this.activity = activity;
        this.fragment = fragment;
        this.binding = binding;
        Fragment fragment2 = this.fragment;
        Object object2 = fragment2 == null ? null : fragment2.getContext();
        if (object2 == null) {
            object2 = (Context)this.activity;
        }
        Context context = object2;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"fragment?.context ?: activity");
        this.context = context;
        Fragment fragment3 = this.fragment;
        if (fragment3 == null) {
            object = null;
        } else {
            LifecycleOwner lifecycleOwner = fragment3.getViewLifecycleOwner();
            object = lifecycle = lifecycleOwner == null ? null : lifecycleOwner.getLifecycle();
        }
        if (object == null) {
            lifecycle = this.activity.getLifecycle();
        }
        context = lifecycle;
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"fragment?.viewLifecycleO\u2026cle ?: activity.lifecycle");
        this.baseLifecycle = context;
        this.lifecycleOwner = new SKLifecycleOwner(new SKLifecycle(this.baseLifecycle));
        this.subViews$delegate = LazyKt.lazy((Function0)subViews.2.INSTANCE);
    }

    @NotNull
    public SKComponentViewProxy<B> getProxy() {
        return this.proxy;
    }

    @NotNull
    public final SKActivity getActivity() {
        return this.activity;
    }

    @Nullable
    protected final Fragment getFragment() {
        return this.fragment;
    }

    @NotNull
    public final B getBinding() {
        return this.binding;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    protected final FragmentManager getFragmentManager() {
        Fragment fragment = this.fragment;
        Object object = fragment == null ? null : fragment.getChildFragmentManager();
        if (object == null) {
            FragmentManager fragmentManager = this.activity.getSupportFragmentManager();
            Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"activity.supportFragmentManager");
            object = fragmentManager;
        }
        return object;
    }

    @NotNull
    public final SKLifecycleOwner getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    public final void setLifecycleOwner(@NotNull SKLifecycleOwner sKLifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)sKLifecycleOwner, (String)"<set-?>");
        this.lifecycleOwner = sKLifecycleOwner;
    }

    @NotNull
    public final List<SKComponentView<?>> getSubViews() {
        Lazy lazy = this.subViews$delegate;
        return (List)lazy.getValue();
    }

    public final <D> void observe(@NotNull SKLiveData<D> $this$observe, @NotNull Function1<? super D, Unit> onChanged) {
        Intrinsics.checkNotNullParameter($this$observe, (String)"<this>");
        Intrinsics.checkNotNullParameter(onChanged, (String)"onChanged");
        $this$observe.setObserver(this.lifecycleOwner, onChanged);
    }

    @CallSuper
    public void onRecycle() {
        this.lifecycleOwner.getLifecycle().setRecycled(true);
        this.lifecycleOwner = new SKLifecycleOwner(new SKLifecycle(this.baseLifecycle));
        Iterable $this$forEach$iv = this.getSubViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SKComponentView it = (SKComponentView)element$iv;
            boolean bl = false;
            it.onRecycle();
        }
        this.getSubViews().clear();
    }

    public final <D> void observe(@NotNull SKMessage<D> $this$observe, @NotNull Function1<? super D, Unit> onReceive) {
        Intrinsics.checkNotNullParameter($this$observe, (String)"<this>");
        Intrinsics.checkNotNullParameter(onReceive, (String)"onReceive");
        $this$observe.setObserver(this.lifecycleOwner, onReceive);
    }

    public final void setTextColor(@NotNull TextView $this$setTextColor, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)$this$setTextColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Context context = $this$setTextColor.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        $this$setTextColor.setTextColor(ResourcesExtensionsKt.toColor(color, context));
    }

    public final void displayMessage(@NotNull SKComponentVC.Message message) {
        Unit unit;
        Unit unit2;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Function2<? super SKComponentView<?>, ? super SKComponentVC.Message, Unit> function2 = displayMessage;
        if (function2 == null) {
            unit2 = null;
        } else {
            function2.invoke((Object)this, (Object)message);
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            throw new IllegalAccessException("You have to define SKComponentView.displayError");
        }
    }

    public final void closeKeyboard() {
        Object object = this.activity.getSystemService("input_method");
        InputMethodManager inputMethodManager = object instanceof InputMethodManager ? (InputMethodManager)object : null;
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(this.activity.getWindow().getDecorView().getWindowToken(), 0);
        }
    }

    protected final void setOnWindowInset(@Nullable Function1<? super WindowInsets, Unit> onWindowInset) {
        if (Build.VERSION.SDK_INT >= 23) {
            WindowInsets loadedInsets;
            Object object;
            Window window = this.activity.getWindow();
            if (window == null) {
                object = null;
            } else {
                View view = window.getDecorView();
                object = loadedInsets = view == null ? null : view.getRootWindowInsets();
            }
            if (loadedInsets != null) {
                Function1<? super WindowInsets, Unit> function1 = onWindowInset;
                if (function1 != null) {
                    function1.invoke((Object)loadedInsets);
                }
            } else {
                View view;
                B b = this.binding;
                ViewBinding viewBinding = b instanceof ViewBinding ? (ViewBinding)b : null;
                Object object2 = viewBinding == null ? null : viewBinding.getRoot();
                if (object2 == null) {
                    B b2 = this.binding;
                    object2 = b2 instanceof View ? (View)b2 : null;
                }
                if ((view = object2) != null) {
                    view.setOnApplyWindowInsetsListener((arg_0, arg_1) -> SKComponentView.setOnWindowInset$lambda-1(onWindowInset, arg_0, arg_1));
                }
            }
        }
    }

    private final boolean isGranted(SKPermissionAndroid $this$isGranted) {
        return ContextCompat.checkSelfPermission((Context)this.context, (String)$this$isGranted.getName()) == 0;
    }

    @Nullable
    public final List<SKComponentViewProxy.PermissionsRequest> getPendingPermissionsRequests() {
        return this.pendingPermissionsRequests;
    }

    public final void setPendingPermissionsRequests(@Nullable List<SKComponentViewProxy.PermissionsRequest> list) {
        this.pendingPermissionsRequests = list;
    }

    /*
     * WARNING - void declaration
     */
    public final void requestPermissions(@NotNull SKComponentViewProxy.PermissionsRequest permissionsRequest) {
        Iterable thisCollection$iv;
        Iterable $this$toTypedArray$iv;
        Collection destination$iv$iv;
        boolean bl;
        Iterable $this$all$iv;
        block11: {
            Intrinsics.checkNotNullParameter((Object)permissionsRequest, (String)"permissionsRequest");
            $this$all$iv = permissionsRequest.getPermissions();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    SKPermissionAndroid it = (SKPermissionAndroid)element$iv;
                    boolean bl2 = false;
                    if (this.isGranted(it)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            permissionsRequest.getOnResult().invoke(permissionsRequest.getPermissions());
        } else if (Build.VERSION.SDK_INT >= 23) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.addPendingPermissionsRequest(permissionsRequest);
            $this$all$iv = permissionsRequest.getPermissions();
            SKActivity sKActivity = this.activity;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SKPermissionAndroid sKPermissionAndroid = (SKPermissionAndroid)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getName());
            }
            $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            sKActivity.requestPermissions(stringArray, permissionsRequest.getRequestCode());
        } else {
            SKPermissionAndroid it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            $this$toTypedArray$iv = permissionsRequest.getPermissions();
            Throwable throwable = new Exception("You need to declare some permissions in your manifest");
            Function1<List<SKPermissionAndroid>, Unit> function1 = SKLog.INSTANCE;
            boolean $i$f$filter = false;
            thisCollection$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SKPermissionAndroid)element$iv$iv;
                boolean bl4 = false;
                if (!(!this.isGranted(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            function1.e(throwable, CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null));
            $this$filter$iv = permissionsRequest.getPermissions();
            function1 = permissionsRequest.getOnResult();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SKPermissionAndroid)element$iv$iv;
                boolean bl5 = false;
                if (!this.isGranted(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            function1.invoke((Object)((List)destination$iv$iv));
        }
    }

    private final void addPendingPermissionsRequest(SKComponentViewProxy.PermissionsRequest permissionsRequest) {
        List<SKComponentViewProxy.PermissionsRequest> currentPendingPermissionsRequests = this.pendingPermissionsRequests;
        if (currentPendingPermissionsRequests == null) {
            Object[] objectArray = new SKComponentViewProxy.PermissionsRequest[]{permissionsRequest};
            this.pendingPermissionsRequests = CollectionsKt.mutableListOf((Object[])objectArray);
            this.observe(ScreensManager.INSTANCE.getPermissionsResults(), (Function1)new Function1<SKPermissionsRequestResultAndroid, Unit>(this){
                final /* synthetic */ SKComponentView<B> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull SKPermissionsRequestResultAndroid result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    List<SKComponentViewProxy.PermissionsRequest> list = this.this$0.getPendingPermissionsRequests();
                    if (list != null) {
                        Object v1;
                        List<SKComponentViewProxy.PermissionsRequest> requests;
                        block3: {
                            requests = list;
                            boolean bl = false;
                            for (T t : (Iterable)requests) {
                                SKComponentViewProxy.PermissionsRequest it = (SKComponentViewProxy.PermissionsRequest)t;
                                boolean bl2 = false;
                                if (!(it.getRequestCode() == result.getRequestCode())) continue;
                                v1 = t;
                                break block3;
                            }
                            v1 = null;
                        }
                        SKComponentViewProxy.PermissionsRequest permissionsRequest = v1;
                        if (permissionsRequest != null) {
                            SKComponentViewProxy.PermissionsRequest request = permissionsRequest;
                            boolean bl = false;
                            request.getOnResult().invoke(result.getGrantedPermissions());
                            requests.remove(request);
                        }
                    }
                }
            });
        } else {
            currentPendingPermissionsRequests.add(permissionsRequest);
        }
    }

    private static final WindowInsets setOnWindowInset$lambda-1(Function1 $onWindowInset, View view, WindowInsets windowInsets) {
        Function1 function1 = $onWindowInset;
        if (function1 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)windowInsets, (String)"windowInsets");
            function1.invoke((Object)windowInsets);
        }
        return windowInsets;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RF\u0010\u0003\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n\u0018\u00010\u0004\u00a2\u0006\u0002\b\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ltech/skot/core/components/SKComponentView$Companion;", "", "()V", "displayMessage", "Lkotlin/Function2;", "Ltech/skot/core/components/SKComponentView;", "Ltech/skot/core/components/SKComponentVC$Message;", "Lkotlin/ParameterName;", "name", "message", "", "Lkotlin/ExtensionFunctionType;", "getDisplayMessage", "()Lkotlin/jvm/functions/Function2;", "setDisplayMessage", "(Lkotlin/jvm/functions/Function2;)V", "viewlegacy_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Function2<SKComponentView<?>, SKComponentVC.Message, Unit> getDisplayMessage() {
            return displayMessage;
        }

        public final void setDisplayMessage(@Nullable Function2<? super SKComponentView<?>, ? super SKComponentVC.Message, Unit> function2) {
            displayMessage = function2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

