/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.libraries.video;

import android.content.Context;
import androidx.fragment.app.Fragment;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.ui.StyledPlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.util.EventLogger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.components.SKActivity;
import tech.skot.core.components.SKComponentViewProxy;
import tech.skot.core.di.Injector;
import tech.skot.core.di.InjectorKt;
import tech.skot.libraries.video.Cache;
import tech.skot.libraries.video.SKVideoVC;
import tech.skot.libraries.video.SKVideoView;
import tech.skot.view.live.SKMessage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003BL\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012#\u0010\b\u001a\u001f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r\u0018\u00010\t\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0010J\"\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u0002H\u0016J \u00107\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u0007H\u0002J\b\u0010;\u001a\u00020<H\u0002J\b\u0010=\u001a\u00020\rH\u0016J\b\u0010>\u001a\u00020\rH\u0016J\b\u0010?\u001a\u00020\rH\u0016J\u0010\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\u0012H\u0016J\u0006\u0010B\u001a\u00020\rJ\u0006\u0010C\u001a\u00020\rR\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R1\u0010\b\u001a\u001f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010'\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010 \"\u0004\b)\u0010\"R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010 R(\u0010+\u001a\u0004\u0018\u00010\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/\u00a8\u0006D"}, d2={"Ltech/skot/libraries/video/SKVideoViewProxy;", "Ltech/skot/core/components/SKComponentViewProxy;", "Lcom/google/android/exoplayer2/ui/StyledPlayerView;", "Ltech/skot/libraries/video/SKVideoVC;", "videoInitial", "Ltech/skot/libraries/video/SKVideoVC$VideoItem;", "useCache", "", "onFullScreen", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "fullScreen", "", "playingInitial", "soundInitial", "(Ltech/skot/libraries/video/SKVideoVC$VideoItem;ZLkotlin/jvm/functions/Function1;ZZ)V", "currentPosition", "", "getCurrentPosition", "()Ljava/lang/Long;", "getOnFullScreen", "()Lkotlin/jvm/functions/Function1;", "player", "Lcom/google/android/exoplayer2/ExoPlayer;", "getPlayer", "()Lcom/google/android/exoplayer2/ExoPlayer;", "setPlayer", "(Lcom/google/android/exoplayer2/ExoPlayer;)V", "value", "playing", "getPlaying", "()Z", "setPlaying", "(Z)V", "resumed", "savedPosition", "setCurrentPositionMessage", "Ltech/skot/view/live/SKMessage;", "sound", "getSound", "setSound", "getUseCache", "video", "getVideo", "()Ltech/skot/libraries/video/SKVideoVC$VideoItem;", "setVideo", "(Ltech/skot/libraries/video/SKVideoVC$VideoItem;)V", "bindTo", "Ltech/skot/libraries/video/SKVideoView;", "activity", "Ltech/skot/core/components/SKActivity;", "fragment", "Landroidx/fragment/app/Fragment;", "binding", "buildPlayer", "playNow", "positionMs", "withSound", "getCacheDataSourceFactory", "Lcom/google/android/exoplayer2/upstream/DataSource$Factory;", "onPause", "onRemove", "onResume", "setCurrentPosition", "position", "updatePlayerUrl", "updatePlaying", "viewlegacy_release"})
public final class SKVideoViewProxy
extends SKComponentViewProxy<StyledPlayerView>
implements SKVideoVC {
    private final boolean useCache;
    @Nullable
    private final Function1<Boolean, Unit> onFullScreen;
    @Nullable
    private ExoPlayer player;
    private boolean sound;
    private boolean playing;
    @Nullable
    private SKVideoVC.VideoItem video;
    @NotNull
    private final SKMessage<Long> setCurrentPositionMessage;
    private long savedPosition;
    private boolean resumed;

    public SKVideoViewProxy(@Nullable SKVideoVC.VideoItem videoInitial, boolean useCache, @Nullable Function1<? super Boolean, Unit> onFullScreen, boolean playingInitial, boolean soundInitial) {
        this.useCache = useCache;
        this.onFullScreen = onFullScreen;
        this.sound = soundInitial;
        this.playing = playingInitial;
        this.video = videoInitial;
        this.setCurrentPositionMessage = new SKMessage(false, 1, null);
        this.savedPosition = 1L;
        this.resumed = true;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    @Nullable
    public Function1<Boolean, Unit> getOnFullScreen() {
        return this.onFullScreen;
    }

    @Nullable
    public final ExoPlayer getPlayer() {
        return this.player;
    }

    public final void setPlayer(@Nullable ExoPlayer exoPlayer) {
        this.player = exoPlayer;
    }

    private final DataSource.Factory getCacheDataSourceFactory() {
        CacheDataSource.Factory factory = new CacheDataSource.Factory();
        boolean $i$f$get = false;
        Injector injector = InjectorKt.getInjector();
        Intrinsics.checkNotNull((Object)injector);
        CacheDataSource.Factory factory2 = factory.setCache((com.google.android.exoplayer2.upstream.cache.Cache)Cache.INSTANCE.getCache((Context)injector.get(Reflection.getOrCreateKotlinClass(Context.class)))).setUpstreamDataSourceFactory((DataSource.Factory)new DefaultHttpDataSource.Factory());
        Intrinsics.checkNotNullExpressionValue((Object)factory2, (String)"Factory()\n            .s\u2026HttpDataSource.Factory())");
        return (DataSource.Factory)factory2;
    }

    private final ExoPlayer buildPlayer(boolean playNow, long positionMs, boolean withSound) {
        ExoPlayer exoPlayer;
        boolean $i$f$get = false;
        Injector injector = InjectorKt.getInjector();
        Intrinsics.checkNotNull((Object)injector);
        ExoPlayer.Builder builder = new ExoPlayer.Builder((Context)injector.get(Reflection.getOrCreateKotlinClass(Context.class)));
        if (this.getUseCache()) {
            builder.setMediaSourceFactory((MediaSource.Factory)new DefaultMediaSourceFactory(this.getCacheDataSourceFactory()));
        }
        ExoPlayer exoPlayer2 = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)exoPlayer2, (String)"builder.build()");
        ExoPlayer $this$buildPlayer_u24lambda_u242 = exoPlayer = exoPlayer2;
        boolean bl = false;
        $this$buildPlayer_u24lambda_u242.addAnalyticsListener((AnalyticsListener)new EventLogger());
        $this$buildPlayer_u24lambda_u242.seekTo($this$buildPlayer_u24lambda_u242.getCurrentMediaItemIndex(), positionMs);
        $this$buildPlayer_u24lambda_u242.setPlayWhenReady(playNow);
        $this$buildPlayer_u24lambda_u242.setRepeatMode(2);
        $this$buildPlayer_u24lambda_u242.setVolume(withSound ? 1.0f : 0.0f);
        SKVideoVC.VideoItem videoItem = this.getVideo();
        if (videoItem != null) {
            SKVideoVC.VideoItem video = videoItem;
            boolean bl2 = false;
            MediaItem.Builder builder2 = new MediaItem.Builder().setUri(video.getUrl());
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"Builder().setUri(video.url)");
            MediaItem.Builder mediaBuilder = builder2;
            String string = video.getMimeType();
            if (string != null) {
                String it = string;
                boolean bl3 = false;
                mediaBuilder.setMimeType(it);
            }
            $this$buildPlayer_u24lambda_u242.addMediaItem(mediaBuilder.build());
        }
        $this$buildPlayer_u24lambda_u242.prepare();
        return exoPlayer;
    }

    public boolean getSound() {
        return this.sound;
    }

    public void setSound(boolean value) {
        this.sound = value;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.setVolume(value ? 1.0f : 0.0f);
        }
    }

    public boolean getPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean value) {
        this.playing = value;
        this.updatePlaying();
    }

    @Nullable
    public SKVideoVC.VideoItem getVideo() {
        return this.video;
    }

    public void setVideo(@Nullable SKVideoVC.VideoItem value) {
        this.video = value;
        this.updatePlayerUrl();
    }

    public void setCurrentPosition(long position) {
        this.setCurrentPositionMessage.post((Object)position);
    }

    @Nullable
    public Long getCurrentPosition() {
        ExoPlayer exoPlayer = this.player;
        return exoPlayer != null ? Long.valueOf(exoPlayer.getCurrentPosition()) : null;
    }

    public void onPause() {
        this.resumed = false;
        ExoPlayer exoPlayer = this.player;
        this.savedPosition = exoPlayer != null ? exoPlayer.getCurrentPosition() : 1L;
        this.updatePlaying();
    }

    public void onResume() {
        this.resumed = true;
        this.updatePlaying();
    }

    public final void updatePlaying() {
        block1: {
            block0: {
                if (!this.resumed || !this.getPlaying()) break block0;
                ExoPlayer exoPlayer = this.player;
                if (exoPlayer == null) break block1;
                exoPlayer.play();
                break block1;
            }
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block1;
            exoPlayer.pause();
        }
    }

    public final void updatePlayerUrl() {
        block2: {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block2;
            ExoPlayer it = exoPlayer;
            boolean bl = false;
            it.stop();
            it.clearMediaItems();
            SKVideoVC.VideoItem videoItem = this.getVideo();
            if (videoItem != null) {
                SKVideoVC.VideoItem video = videoItem;
                boolean bl2 = false;
                MediaItem.Builder builder = new MediaItem.Builder().setUri(video.getUrl());
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder().setUri(video.url)");
                MediaItem.Builder builder2 = builder;
                String string = video.getMimeType();
                if (string != null) {
                    String it2 = string;
                    boolean bl3 = false;
                    builder2.setMimeType(it2);
                }
                it.addMediaItem(builder2.build());
            }
            it.prepare();
            it.play();
        }
    }

    public void onRemove() {
        block0: {
            super.onRemove();
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer == null) break block0;
            exoPlayer.release();
        }
    }

    @NotNull
    public SKVideoView bindTo(@NotNull SKActivity activity, @Nullable Fragment fragment, @NotNull StyledPlayerView binding) {
        SKVideoView sKVideoView;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer == null) {
            ExoPlayer exoPlayer2;
            ExoPlayer it = exoPlayer2 = this.buildPlayer(this.getPlaying(), this.savedPosition, this.getSound());
            boolean bl = false;
            this.player = it;
            exoPlayer = exoPlayer2;
        }
        ExoPlayer thePlayer = exoPlayer;
        boolean bl = false;
        SKVideoView $this$bindTo_u24lambda_u248_u24lambda_u247 = sKVideoView = new SKVideoView(this, activity, fragment, binding, thePlayer);
        boolean bl2 = false;
        $this$bindTo_u24lambda_u248_u24lambda_u247.setOnFullScreen(this.getOnFullScreen());
        $this$bindTo_u24lambda_u248_u24lambda_u247.observe(this.setCurrentPositionMessage, (Function1)new Function1<Long, Unit>($this$bindTo_u24lambda_u248_u24lambda_u247){
            final /* synthetic */ SKVideoView $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(long it) {
                this.$this_apply.setCurrentPosition(it);
            }
        });
        return sKVideoView;
    }
}

