/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.libraries.video;

import android.content.Context;
import androidx.fragment.app.Fragment;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.ui.PlayerView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.components.SKActivity;
import tech.skot.core.components.SKComponentViewProxy;
import tech.skot.core.di.Injector;
import tech.skot.core.di.InjectorKt;
import tech.skot.libraries.video.SKVideoVC;
import tech.skot.libraries.video.SKVideoView;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0002H\u0016J \u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u0007H\u0002J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0016J\b\u0010,\u001a\u00020*H\u0016J\u0006\u0010-\u001a\u00020*R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Ltech/skot/libraries/video/SKVideoViewProxy;", "Ltech/skot/core/components/SKComponentViewProxy;", "Lcom/google/android/exoplayer2/ui/PlayerView;", "Ltech/skot/libraries/video/SKVideoVC;", "url", "", "playingInitial", "", "soundInitial", "(Ljava/lang/String;ZZ)V", "player", "Lcom/google/android/exoplayer2/ExoPlayer;", "getPlayer", "()Lcom/google/android/exoplayer2/ExoPlayer;", "setPlayer", "(Lcom/google/android/exoplayer2/ExoPlayer;)V", "value", "playing", "getPlaying", "()Z", "setPlaying", "(Z)V", "resumed", "savedPosition", "", "sound", "getSound", "setSound", "getUrl", "()Ljava/lang/String;", "bindTo", "Ltech/skot/libraries/video/SKVideoView;", "activity", "Ltech/skot/core/components/SKActivity;", "fragment", "Landroidx/fragment/app/Fragment;", "binding", "buildPlayer", "playNow", "positionMs", "withSound", "onPause", "", "onRemove", "onResume", "updatePlaying", "viewlegacy_release"})
public final class SKVideoViewProxy
extends SKComponentViewProxy<PlayerView>
implements SKVideoVC {
    @NotNull
    private final String url;
    @Nullable
    private ExoPlayer player;
    private boolean sound;
    private boolean playing;
    private long savedPosition;
    private boolean resumed;

    public SKVideoViewProxy(@NotNull String url, boolean playingInitial, boolean soundInitial) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
        this.sound = soundInitial;
        this.playing = playingInitial;
        this.savedPosition = 1L;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Nullable
    public final ExoPlayer getPlayer() {
        return this.player;
    }

    public final void setPlayer(@Nullable ExoPlayer exoPlayer) {
        this.player = exoPlayer;
    }

    private final ExoPlayer buildPlayer(boolean playNow, long positionMs, boolean withSound) {
        ExoPlayer exoPlayer;
        boolean $i$f$get = false;
        Injector injector = InjectorKt.getInjector();
        Intrinsics.checkNotNull((Object)injector);
        ExoPlayer $this$buildPlayer_u24lambda_u2d0 = exoPlayer = new ExoPlayer.Builder((Context)injector.get(Reflection.getOrCreateKotlinClass(Context.class))).build();
        boolean bl = false;
        $this$buildPlayer_u24lambda_u2d0.seekTo($this$buildPlayer_u24lambda_u2d0.getCurrentMediaItemIndex(), positionMs);
        $this$buildPlayer_u24lambda_u2d0.setPlayWhenReady(playNow);
        $this$buildPlayer_u24lambda_u2d0.setRepeatMode(2);
        $this$buildPlayer_u24lambda_u2d0.addMediaItem(MediaItem.fromUri((String)this.getUrl()));
        $this$buildPlayer_u24lambda_u2d0.prepare();
        $this$buildPlayer_u24lambda_u2d0.setVolume(withSound ? 1.0f : 0.0f);
        ExoPlayer exoPlayer2 = exoPlayer;
        Intrinsics.checkNotNullExpressionValue((Object)exoPlayer2, (String)"Builder(get()).build().a\u2026und) 1f else 0f\n        }");
        return exoPlayer2;
    }

    public boolean getSound() {
        return this.sound;
    }

    public void setSound(boolean value) {
        this.sound = value;
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.setVolume(value ? 1.0f : 0.0f);
        }
    }

    public boolean getPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean value) {
        this.playing = value;
        if (value) {
            this.updatePlaying();
        } else {
            this.updatePlaying();
        }
    }

    public void onPause() {
        long l;
        this.resumed = false;
        ExoPlayer exoPlayer = this.player;
        this.savedPosition = exoPlayer == null ? 1L : (l = exoPlayer.getCurrentPosition());
        this.updatePlaying();
    }

    public void onResume() {
        this.resumed = true;
        this.updatePlaying();
    }

    public final void updatePlaying() {
        if (this.resumed && this.getPlaying()) {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                exoPlayer.play();
            }
        } else {
            ExoPlayer exoPlayer = this.player;
            if (exoPlayer != null) {
                exoPlayer.pause();
            }
        }
    }

    public void onRemove() {
        super.onRemove();
        ExoPlayer exoPlayer = this.player;
        if (exoPlayer != null) {
            exoPlayer.release();
        }
    }

    @NotNull
    public SKVideoView bindTo(@NotNull SKActivity activity, @Nullable Fragment fragment, @NotNull PlayerView binding) {
        ExoPlayer exoPlayer;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        ExoPlayer exoPlayer2 = this.player;
        if (exoPlayer2 == null) {
            ExoPlayer exoPlayer3;
            ExoPlayer it = exoPlayer3 = this.buildPlayer(this.getPlaying(), this.savedPosition, this.getSound());
            boolean bl = false;
            this.setPlayer(it);
            exoPlayer = exoPlayer3;
        } else {
            exoPlayer = exoPlayer2;
        }
        ExoPlayer thePlayer = exoPlayer;
        boolean bl = false;
        return new SKVideoView(this, activity, fragment, binding, thePlayer);
    }
}

