/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.libraries.scanner;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.Image;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import com.google.android.gms.tasks.Task;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.SKLog;
import tech.skot.core.components.SKActivity;
import tech.skot.core.components.SKComponentView;
import tech.skot.core.components.SKComponentViewProxy;
import tech.skot.libraries.scanner.SKScannerVC;
import tech.skot.libraries.scanner.SKScannerViewProxy;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\nJ\n\u0010\u0013\u001a\u00020\u0014*\u00020\u0015R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Ltech/skot/libraries/scanner/SKScannerView;", "Ltech/skot/core/components/SKComponentView;", "Landroidx/camera/view/PreviewView;", "proxy", "Ltech/skot/libraries/scanner/SKScannerViewProxy;", "activity", "Ltech/skot/core/components/SKActivity;", "fragment", "Landroidx/fragment/app/Fragment;", "binding", "(Ltech/skot/libraries/scanner/SKScannerViewProxy;Ltech/skot/core/components/SKActivity;Landroidx/fragment/app/Fragment;Landroidx/camera/view/PreviewView;)V", "barcodeScanner", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "cameraExecutor", "Ljava/util/concurrent/ExecutorService;", "cameraProvider", "Landroidx/camera/lifecycle/ProcessCameraProvider;", "getProxy", "()Ltech/skot/libraries/scanner/SKScannerViewProxy;", "toAndroidFormat", "", "Ltech/skot/libraries/scanner/SKScannerVC$Format;", "viewlegacy_release"})
@SuppressLint(value={"UnsafeOptInUsageError"})
public final class SKScannerView
extends SKComponentView<PreviewView> {
    @NotNull
    private final SKScannerViewProxy proxy;
    @NotNull
    private ExecutorService cameraExecutor;
    @Nullable
    private ProcessCameraProvider cameraProvider;
    @NotNull
    private BarcodeScanner barcodeScanner;

    /*
     * WARNING - void declaration
     */
    public SKScannerView(@NotNull SKScannerViewProxy proxy, @NotNull SKActivity activity, @Nullable Fragment fragment, @NotNull PreviewView binding) {
        BarcodeScannerOptions.Builder builder;
        Intrinsics.checkNotNullParameter((Object)((Object)proxy), (String)"proxy");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        super((SKComponentViewProxy)proxy, activity, fragment, (Object)binding);
        this.proxy = proxy;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        this.cameraExecutor = executorService;
        BarcodeScannerOptions.Builder builder2 = builder = new BarcodeScannerOptions.Builder();
        SKScannerView sKScannerView = this;
        boolean bl = false;
        switch (this.getProxy().getFormats().size()) {
            case 0: {
                break;
            }
            case 1: {
                void $this$barcodeScanner_u24lambda_u2d1;
                $this$barcodeScanner_u24lambda_u2d1.setBarcodeFormats(this.toAndroidFormat((SKScannerVC.Format)CollectionsKt.first((Iterable)this.getProxy().getFormats())), new int[0]);
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                void $this$barcodeScanner_u24lambda_u2d1;
                List formatsList = CollectionsKt.toList((Iterable)this.getProxy().getFormats());
                Iterable $this$map$iv = CollectionsKt.drop((Iterable)formatsList, (int)1);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SKScannerVC.Format format = (SKScannerVC.Format)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.toAndroidFormat((SKScannerVC.Format)it));
                }
                int[] moreFormats = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
                $this$barcodeScanner_u24lambda_u2d1.setBarcodeFormats(this.toAndroidFormat((SKScannerVC.Format)CollectionsKt.first((List)formatsList)), Arrays.copyOf(moreFormats, moreFormats.length));
            }
        }
        BarcodeScanner barcodeScanner = BarcodeScanning.getClient((BarcodeScannerOptions)builder.build());
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner, (String)"getClient(\n        Barco\u2026          }.build()\n    )");
        sKScannerView.barcodeScanner = barcodeScanner;
        ListenableFuture listenableFuture = ProcessCameraProvider.getInstance((Context)this.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"getInstance(context)");
        ListenableFuture cameraProviderFuture = listenableFuture;
        cameraProviderFuture.addListener(() -> SKScannerView._init_$lambda-8(this, cameraProviderFuture, binding, fragment, activity), ContextCompat.getMainExecutor((Context)this.getContext()));
    }

    @NotNull
    public SKScannerViewProxy getProxy() {
        return this.proxy;
    }

    public final int toAndroidFormat(@NotNull SKScannerVC.Format $this$toAndroidFormat) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$toAndroidFormat, (String)"<this>");
        SKScannerVC.Format format = $this$toAndroidFormat;
        if (Intrinsics.areEqual((Object)format, (Object)SKScannerVC.Format.EAN8.INSTANCE)) {
            n = 64;
        } else if (Intrinsics.areEqual((Object)format, (Object)SKScannerVC.Format.EAN13.INSTANCE)) {
            n = 32;
        } else if (Intrinsics.areEqual((Object)format, (Object)SKScannerVC.Format.Code128.INSTANCE)) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)format, (Object)SKScannerVC.Format.QRCode.INSTANCE)) {
            n = 256;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private static final void lambda-8$lambda-7$lambda-6$lambda-3(SKScannerView this$0, List barcodes) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullExpressionValue((Object)barcodes, (String)"barcodes");
            Object object = (Barcode)CollectionsKt.firstOrNull((List)barcodes);
            if (object == null || (object = object.getRawValue()) == null) break block0;
            Object code = object;
            boolean bl = false;
            this$0.getProxy().getOnScanCode().invoke(code);
        }
    }

    private static final void lambda-8$lambda-7$lambda-6$lambda-4(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Throwable throwable = it;
        String string = it.getMessage();
        if (string == null) {
            string = "error";
        }
        SKLog.INSTANCE.e(throwable, string);
    }

    private static final void lambda-8$lambda-7$lambda-6$lambda-5(ImageProxy $imageProxy, Task it) {
        Intrinsics.checkNotNullParameter((Object)$imageProxy, (String)"$imageProxy");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $imageProxy.close();
    }

    private static final void lambda-8$lambda-7(SKScannerView this$0, ImageProxy imageProxy) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
            if (!this$0.getProxy().getScanning()) break block1;
            Image image = imageProxy.getImage();
            if (image != null) {
                Image image2 = image;
                boolean bl = false;
                InputImage inputImage = InputImage.fromMediaImage((Image)image2, (int)imageProxy.getImageInfo().getRotationDegrees());
                Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromMediaImage(\n        \u2026                        )");
                InputImage inputImage2 = inputImage;
                this$0.barcodeScanner.process(inputImage2).addOnSuccessListener(arg_0 -> SKScannerView.lambda-8$lambda-7$lambda-6$lambda-3(this$0, arg_0)).addOnFailureListener(SKScannerView::lambda-8$lambda-7$lambda-6$lambda-4).addOnCompleteListener(arg_0 -> SKScannerView.lambda-8$lambda-7$lambda-6$lambda-5(imageProxy, arg_0));
            }
        }
    }

    private static final void _init_$lambda-8(SKScannerView this$0, ListenableFuture $cameraProviderFuture, PreviewView $binding, Fragment $fragment, SKActivity $activity) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cameraProviderFuture, (String)"$cameraProviderFuture");
        Intrinsics.checkNotNullParameter((Object)$binding, (String)"$binding");
        Intrinsics.checkNotNullParameter((Object)$activity, (String)"$activity");
        try {
            this$0.cameraProvider = (ProcessCameraProvider)$cameraProviderFuture.get();
            Preview preview = new Preview.Builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)preview, (String)"Builder()\n                    .build()");
            Preview preview2 = preview;
            preview2.setSurfaceProvider($binding.getSurfaceProvider());
            ImageAnalysis imageAnalysis = new ImageAnalysis.Builder().build();
            Intrinsics.checkNotNullExpressionValue((Object)imageAnalysis, (String)"Builder().build()");
            ImageAnalysis analysisUseCase = imageAnalysis;
            analysisUseCase.setAnalyzer((Executor)this$0.cameraExecutor, arg_0 -> SKScannerView.lambda-8$lambda-7(this$0, arg_0));
            ProcessCameraProvider processCameraProvider = this$0.cameraProvider;
            if (processCameraProvider != null) {
                processCameraProvider.unbindAll();
            }
            ProcessCameraProvider processCameraProvider2 = this$0.cameraProvider;
            if (processCameraProvider2 != null) {
                Fragment fragment = $fragment;
                if (fragment == null || (fragment = fragment.getViewLifecycleOwner()) == null) {
                    fragment = (LifecycleOwner)$activity;
                }
                UseCase[] useCaseArray = new UseCase[]{(UseCase)preview2, (UseCase)analysisUseCase};
                processCameraProvider2.bindToLifecycle((LifecycleOwner)fragment, CameraSelector.DEFAULT_BACK_CAMERA, useCaseArray);
            }
        }
        catch (ExecutionException eex) {
            SKLog.INSTANCE.e((Throwable)eex, "problem with camera");
        }
        catch (InterruptedException intex) {
            SKLog.INSTANCE.e((Throwable)intex, "problem with camera");
        }
    }
}

