/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.libraries.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import androidx.collection.LruCache;
import androidx.core.content.ContextCompat;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.model.BitmapDescriptor;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.SKLog;
import tech.skot.libraries.map.SKMapVC;
import tech.skot.libraries.map.SKMapView;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0016\u0010%\u001a\u00020 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0'H&J'\u0010(\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010*\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0014J\u001e\u00100\u001a\u00020 2\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020 \u0018\u00010\u001eH&J\u0012\u00103\u001a\u00020 2\b\u00104\u001a\u0004\u0018\u00010\u001fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R?\u0010\u0011\u001a'\u0012\u0004\u0012\u00020\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR&\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 \u0018\u00010\u001eX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00065"}, d2={"Ltech/skot/libraries/map/MapInteractionHelper;", "", "context", "Landroid/content/Context;", "mapView", "Lcom/google/android/gms/maps/MapView;", "memoryCache", "Landroidx/collection/LruCache;", "", "Ltech/skot/libraries/map/SKMapView$BitmapDescriptorContainer;", "(Landroid/content/Context;Lcom/google/android/gms/maps/MapView;Landroidx/collection/LruCache;)V", "getContext", "()Landroid/content/Context;", "getMapView", "()Lcom/google/android/gms/maps/MapView;", "getMemoryCache", "()Landroidx/collection/LruCache;", "onCreateCustomMarkerIcon", "Lkotlin/Function2;", "Ltech/skot/libraries/map/SKMapVC$CustomMarker;", "", "Lkotlin/ParameterName;", "name", "selected", "Landroid/graphics/Bitmap;", "getOnCreateCustomMarkerIcon", "()Lkotlin/jvm/functions/Function2;", "setOnCreateCustomMarkerIcon", "(Lkotlin/jvm/functions/Function2;)V", "onMarkerClick", "Lkotlin/Function1;", "Ltech/skot/libraries/map/SKMapVC$Marker;", "", "getOnMarkerClick", "()Lkotlin/jvm/functions/Function1;", "setOnMarkerClick", "(Lkotlin/jvm/functions/Function1;)V", "addMarkers", "markers", "", "getBitmap", "resId", "", "color", "(Landroid/content/Context;ILjava/lang/Integer;)Landroid/graphics/Bitmap;", "getIcon", "Lcom/google/android/gms/maps/model/BitmapDescriptor;", "marker", "onOnMapBoundsChange", "onMapBoundsChange", "Ltech/skot/libraries/map/SKMapVC$LatLngBounds;", "onSelectedMarker", "selectedMarker", "viewlegacy_release"})
public abstract class MapInteractionHelper {
    @NotNull
    private final Context context;
    @NotNull
    private final MapView mapView;
    @NotNull
    private final LruCache<String, SKMapView.BitmapDescriptorContainer> memoryCache;
    @Nullable
    private Function2<? super SKMapVC.CustomMarker, ? super Boolean, Bitmap> onCreateCustomMarkerIcon;

    public MapInteractionHelper(@NotNull Context context, @NotNull MapView mapView, @NotNull LruCache<String, SKMapView.BitmapDescriptorContainer> memoryCache) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mapView, (String)"mapView");
        Intrinsics.checkNotNullParameter(memoryCache, (String)"memoryCache");
        this.context = context;
        this.mapView = mapView;
        this.memoryCache = memoryCache;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final MapView getMapView() {
        return this.mapView;
    }

    @NotNull
    public final LruCache<String, SKMapView.BitmapDescriptorContainer> getMemoryCache() {
        return this.memoryCache;
    }

    @Nullable
    public abstract Function1<SKMapVC.Marker, Unit> getOnMarkerClick();

    public abstract void setOnMarkerClick(@Nullable Function1<? super SKMapVC.Marker, Unit> var1);

    @Nullable
    public final Function2<SKMapVC.CustomMarker, Boolean, Bitmap> getOnCreateCustomMarkerIcon() {
        return this.onCreateCustomMarkerIcon;
    }

    public final void setOnCreateCustomMarkerIcon(@Nullable Function2<? super SKMapVC.CustomMarker, ? super Boolean, Bitmap> function2) {
        this.onCreateCustomMarkerIcon = function2;
    }

    public abstract void onSelectedMarker(@Nullable SKMapVC.Marker var1);

    public abstract void addMarkers(@NotNull List<? extends SKMapVC.Marker> var1);

    public abstract void onOnMapBoundsChange(@Nullable Function1<? super SKMapVC.LatLngBounds, Unit> var1);

    @Nullable
    public final Bitmap getBitmap(@NotNull Context context, int resId, @Nullable Integer color) {
        Bitmap bitmap;
        Drawable drawable;
        Drawable it;
        Drawable drawable2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Drawable drawable3 = ContextCompat.getDrawable((Context)context, (int)resId);
        if (drawable3 == null) {
            drawable2 = null;
        } else {
            it = drawable3;
            boolean bl = false;
            drawable2 = color != null ? it.mutate() : it;
        }
        Drawable drawable4 = drawable = drawable2;
        if (drawable4 == null) {
            bitmap = null;
        } else {
            it = drawable4;
            boolean bl = false;
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
            Integer n = color;
            if (n != null) {
                int it2 = ((Number)n).intValue();
                boolean bl2 = false;
                drawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(ContextCompat.getColor((Context)context, (int)color), PorterDuff.Mode.MULTIPLY));
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(\n          \u2026g.ARGB_8888\n            )");
            Bitmap bitmap3 = bitmap2;
            Canvas canvas = new Canvas(bitmap3);
            drawable.draw(canvas);
            bitmap = bitmap3;
        }
        return bitmap;
    }

    @Nullable
    public final BitmapDescriptor getIcon(@NotNull SKMapVC.Marker marker, boolean selected) {
        BitmapDescriptor bitmapDescriptor;
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        String hash = (String)marker.getIconHash().invoke((Object)selected);
        SKMapVC.Marker marker2 = marker;
        if (marker2 instanceof SKMapVC.IconMarker) {
            BitmapDescriptor bitmapDescriptor2;
            BitmapDescriptor bitmapDescriptor3;
            SKMapView.BitmapDescriptorContainer bitmapDescriptorContainer = (SKMapView.BitmapDescriptorContainer)this.memoryCache.get((Object)hash);
            if (bitmapDescriptorContainer == null) {
                bitmapDescriptor3 = null;
            } else {
                BitmapDescriptor bitmapDescriptor4 = bitmapDescriptorContainer.getBitmapDescriptor();
                if (bitmapDescriptor4 == null) {
                    bitmapDescriptor3 = null;
                } else {
                    BitmapDescriptor bitmapDescriptor5;
                    BitmapDescriptor $this$getIcon_u24lambda_u2d3 = bitmapDescriptor5 = bitmapDescriptor4;
                    boolean bl = false;
                    SKLog.INSTANCE.d("icon : get icon bitmap " + marker.getId() + " from cache with hash " + hash);
                    bitmapDescriptor3 = bitmapDescriptor2 = bitmapDescriptor5;
                }
            }
            if (bitmapDescriptor2 == null) {
                Bitmap it;
                boolean bl = false;
                if (selected) {
                    Bitmap bitmap = this.getBitmap(this.getContext(), ((SKMapVC.IconMarker)marker).getSelectedIcon().getRes(), null);
                    if (bitmap == null) {
                        bitmapDescriptor = null;
                    } else {
                        it = bitmap;
                        boolean bl2 = false;
                        SKMapView.BitmapDescriptorContainer it2 = new SKMapView.BitmapDescriptorContainer(it);
                        boolean bl3 = false;
                        SKLog.INSTANCE.d("icon : put icon bitmap " + marker.getId() + " in cache  with hash " + hash);
                        this.getMemoryCache().put((Object)hash, (Object)it2);
                        bitmapDescriptor = it2.getBitmapDescriptor();
                    }
                } else {
                    Bitmap bitmap = this.getBitmap(this.getContext(), ((SKMapVC.IconMarker)marker).getNormalIcon().getRes(), null);
                    if (bitmap == null) {
                        bitmapDescriptor = null;
                    } else {
                        it = bitmap;
                        boolean bl4 = false;
                        SKMapView.BitmapDescriptorContainer it3 = new SKMapView.BitmapDescriptorContainer(it);
                        boolean bl5 = false;
                        SKLog.INSTANCE.d("icon : put icon bitmap " + marker.getId() + " in cache  with hash " + hash);
                        this.getMemoryCache().put((Object)hash, (Object)it3);
                        bitmapDescriptor = it3.getBitmapDescriptor();
                    }
                }
            } else {
                bitmapDescriptor = bitmapDescriptor2;
            }
        } else if (marker2 instanceof SKMapVC.ColorizedIconMarker) {
            BitmapDescriptor bitmapDescriptor6;
            BitmapDescriptor bitmapDescriptor7;
            SKMapView.BitmapDescriptorContainer bitmapDescriptorContainer = (SKMapView.BitmapDescriptorContainer)this.memoryCache.get((Object)hash);
            if (bitmapDescriptorContainer == null) {
                bitmapDescriptor7 = null;
            } else {
                BitmapDescriptor bitmapDescriptor8 = bitmapDescriptorContainer.getBitmapDescriptor();
                if (bitmapDescriptor8 == null) {
                    bitmapDescriptor7 = null;
                } else {
                    BitmapDescriptor bitmapDescriptor9;
                    BitmapDescriptor $this$getIcon_u24lambda_u2d9 = bitmapDescriptor9 = bitmapDescriptor8;
                    boolean bl = false;
                    SKLog.INSTANCE.d("icon : get colorized bitmap " + marker.getId() + " from cache with hash " + hash);
                    bitmapDescriptor7 = bitmapDescriptor6 = bitmapDescriptor9;
                }
            }
            if (bitmapDescriptor6 == null) {
                Bitmap it;
                boolean bl = false;
                if (selected) {
                    Bitmap bitmap = this.getBitmap(this.getContext(), ((SKMapVC.ColorizedIconMarker)marker).getIcon().getRes(), ((SKMapVC.ColorizedIconMarker)marker).getSelectedColor().getRes());
                    if (bitmap == null) {
                        bitmapDescriptor = null;
                    } else {
                        it = bitmap;
                        boolean bl6 = false;
                        SKMapView.BitmapDescriptorContainer it4 = new SKMapView.BitmapDescriptorContainer(it);
                        boolean bl7 = false;
                        SKLog.INSTANCE.d("icon : put colorized bitmap " + marker.getId() + " in cache  with hash " + hash);
                        this.getMemoryCache().put((Object)hash, (Object)it4);
                        bitmapDescriptor = it4.getBitmapDescriptor();
                    }
                } else {
                    Bitmap bitmap = this.getBitmap(this.getContext(), ((SKMapVC.ColorizedIconMarker)marker).getIcon().getRes(), ((SKMapVC.ColorizedIconMarker)marker).getNormalColor().getRes());
                    if (bitmap == null) {
                        bitmapDescriptor = null;
                    } else {
                        it = bitmap;
                        boolean bl8 = false;
                        SKMapView.BitmapDescriptorContainer it5 = new SKMapView.BitmapDescriptorContainer(it);
                        boolean bl9 = false;
                        SKLog.INSTANCE.d("icon : put colorized bitmap " + marker.getId() + " in cache  with hash " + hash);
                        this.getMemoryCache().put((Object)hash, (Object)it5);
                        bitmapDescriptor = it5.getBitmapDescriptor();
                    }
                }
            } else {
                bitmapDescriptor = bitmapDescriptor6;
            }
        } else if (marker2 instanceof SKMapVC.CustomMarker) {
            BitmapDescriptor bitmapDescriptor10;
            BitmapDescriptor bitmapDescriptor11;
            SKMapView.BitmapDescriptorContainer bitmapDescriptorContainer = (SKMapView.BitmapDescriptorContainer)this.memoryCache.get((Object)hash);
            if (bitmapDescriptorContainer == null) {
                bitmapDescriptor11 = null;
            } else {
                BitmapDescriptor bitmapDescriptor12 = bitmapDescriptorContainer.getBitmapDescriptor();
                if (bitmapDescriptor12 == null) {
                    bitmapDescriptor11 = null;
                } else {
                    BitmapDescriptor bitmapDescriptor13;
                    BitmapDescriptor $this$getIcon_u24lambda_u2d15 = bitmapDescriptor13 = bitmapDescriptor12;
                    boolean bl = false;
                    SKLog.INSTANCE.d("icon : get custom bitmap " + marker.getId() + " from cache with hash " + hash);
                    bitmapDescriptor11 = bitmapDescriptor10 = bitmapDescriptor13;
                }
            }
            if (bitmapDescriptor10 == null) {
                BitmapDescriptor bitmapDescriptor14;
                boolean bl = false;
                Function2<SKMapVC.CustomMarker, Boolean, Bitmap> function2 = this.getOnCreateCustomMarkerIcon();
                if (function2 == null) {
                    bitmapDescriptor14 = null;
                } else {
                    Bitmap bitmap = (Bitmap)function2.invoke((Object)marker, (Object)selected);
                    if (bitmap == null) {
                        bitmapDescriptor14 = null;
                    } else {
                        Bitmap it = bitmap;
                        boolean bl10 = false;
                        SKMapView.BitmapDescriptorContainer it6 = new SKMapView.BitmapDescriptorContainer(it);
                        boolean bl11 = false;
                        SKLog.INSTANCE.d("icon : put custom bitmap " + marker.getId() + " in cache  with hash " + hash);
                        this.getMemoryCache().put((Object)hash, (Object)it6);
                        bitmapDescriptor14 = it6.getBitmapDescriptor();
                    }
                }
                BitmapDescriptor bitmapDescriptor15 = bitmapDescriptor14;
                if (bitmapDescriptor15 == null) {
                    throw new NoSuchFieldException("onCreateCustomMarkerIcon must not be null with CustomMarker");
                }
                bitmapDescriptor = bitmapDescriptor15;
            } else {
                bitmapDescriptor = bitmapDescriptor10;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bitmapDescriptor;
    }
}

