/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.libraries.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import androidx.collection.LruCache;
import androidx.core.content.ContextCompat;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.skot.core.ResourcesExtensionsKt;
import tech.skot.core.view.Color;
import tech.skot.core.view.Dimen;
import tech.skot.libraries.map.MapLoggerView;
import tech.skot.libraries.map.SKMapVC;
import tech.skot.libraries.map.SKMapView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0014\u00101\u001a\u00020%2\f\u00102\u001a\b\u0012\u0004\u0012\u00020/0+J\u0016\u00103\u001a\u00020%2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000f0+H&J\u0014\u00105\u001a\u00020%2\f\u00106\u001a\b\u0012\u0004\u0012\u00020,0+J\"\u00107\u001a\u0004\u0018\u00010 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;J\u0018\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0010J\u0010\u0010?\u001a\u00020\u00102\u0006\u0010@\u001a\u00020/H\u0002J\u0010\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020,H\u0002J\u001e\u0010C\u001a\u00020\u00102\u0006\u0010@\u001a\u00020/2\f\u00102\u001a\b\u0012\u0004\u0012\u00020/0+H\u0002J\u001e\u0010D\u001a\u00020\u00102\u0006\u0010B\u001a\u00020,2\f\u00106\u001a\b\u0012\u0004\u0012\u00020,0+H\u0002J\u001e\u0010E\u001a\u00020%2\u0014\u0010F\u001a\u0010\u0012\u0004\u0012\u00020G\u0012\u0004\u0012\u00020%\u0018\u00010$H&J\u0012\u0010H\u001a\u00020%2\b\u0010I\u001a\u0004\u0018\u00010\u000fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fRK\u0010\r\u001a3\u0012\u0004\u0012\u00020\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR?\u0010\u001e\u001a'\u0012\u0004\u0012\u00020\u001f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R&\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020%\u0018\u00010$X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R \u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0\u00140+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000\u00140+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Ltech/skot/libraries/map/MapInteractionHelper;", "", "context", "Landroid/content/Context;", "mapView", "Lcom/google/android/gms/maps/MapView;", "memoryCache", "Landroidx/collection/LruCache;", "", "Ltech/skot/libraries/map/SKMapView$BitmapDescriptorContainer;", "(Landroid/content/Context;Lcom/google/android/gms/maps/MapView;Landroidx/collection/LruCache;)V", "getContext", "()Landroid/content/Context;", "getMarkerAnchor", "Lkotlin/Function2;", "Ltech/skot/libraries/map/SKMapVC$Marker;", "", "Lkotlin/ParameterName;", "name", "selected", "Lkotlin/Pair;", "", "getGetMarkerAnchor", "()Lkotlin/jvm/functions/Function2;", "setGetMarkerAnchor", "(Lkotlin/jvm/functions/Function2;)V", "getMapView", "()Lcom/google/android/gms/maps/MapView;", "getMemoryCache", "()Landroidx/collection/LruCache;", "onCreateCustomMarkerIcon", "Ltech/skot/libraries/map/SKMapVC$CustomMarker;", "Landroid/graphics/Bitmap;", "getOnCreateCustomMarkerIcon", "setOnCreateCustomMarkerIcon", "onMarkerClick", "Lkotlin/Function1;", "", "getOnMarkerClick", "()Lkotlin/jvm/functions/Function1;", "setOnMarkerClick", "(Lkotlin/jvm/functions/Function1;)V", "polygonItems", "", "Ltech/skot/libraries/map/SKMapVC$Polygon;", "Lcom/google/android/gms/maps/model/Polygon;", "polylineItems", "Ltech/skot/libraries/map/SKMapVC$Polyline;", "Lcom/google/android/gms/maps/model/Polyline;", "addLines", "polylines", "addMarkers", "markers", "addPolygons", "polygons", "getBitmap", "resId", "", "color", "Ltech/skot/core/view/Color;", "getIcon", "Lcom/google/android/gms/maps/model/BitmapDescriptor;", "marker", "newLineAlreadyExist", "polyline", "newPolygonAlreadyExist", "polygon", "oldLineStillAvailable", "oldPolygonStillAvailable", "onOnMapBoundsChange", "onMapBoundsChange", "Ltech/skot/libraries/map/SKMapVC$LatLngBounds;", "onSelectedMarker", "selectedMarker", "viewlegacy_release"})
public abstract class MapInteractionHelper {
    @NotNull
    private final Context context;
    @NotNull
    private final MapView mapView;
    @NotNull
    private final LruCache<String, SKMapView.BitmapDescriptorContainer> memoryCache;
    @NotNull
    private List<Pair<SKMapVC.Polyline, Polyline>> polylineItems;
    @NotNull
    private List<Pair<SKMapVC.Polygon, Polygon>> polygonItems;
    @Nullable
    private Function2<? super SKMapVC.CustomMarker, ? super Boolean, Bitmap> onCreateCustomMarkerIcon;
    @Nullable
    private Function2<? super SKMapVC.Marker, ? super Boolean, Pair<Float, Float>> getMarkerAnchor;

    public MapInteractionHelper(@NotNull Context context, @NotNull MapView mapView, @NotNull LruCache<String, SKMapView.BitmapDescriptorContainer> memoryCache) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mapView, (String)"mapView");
        Intrinsics.checkNotNullParameter(memoryCache, (String)"memoryCache");
        this.context = context;
        this.mapView = mapView;
        this.memoryCache = memoryCache;
        this.polylineItems = CollectionsKt.emptyList();
        this.polygonItems = CollectionsKt.emptyList();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final MapView getMapView() {
        return this.mapView;
    }

    @NotNull
    public final LruCache<String, SKMapView.BitmapDescriptorContainer> getMemoryCache() {
        return this.memoryCache;
    }

    @Nullable
    public abstract Function1<SKMapVC.Marker, Unit> getOnMarkerClick();

    public abstract void setOnMarkerClick(@Nullable Function1<? super SKMapVC.Marker, Unit> var1);

    @Nullable
    public final Function2<SKMapVC.CustomMarker, Boolean, Bitmap> getOnCreateCustomMarkerIcon() {
        return this.onCreateCustomMarkerIcon;
    }

    public final void setOnCreateCustomMarkerIcon(@Nullable Function2<? super SKMapVC.CustomMarker, ? super Boolean, Bitmap> function2) {
        this.onCreateCustomMarkerIcon = function2;
    }

    @Nullable
    public final Function2<SKMapVC.Marker, Boolean, Pair<Float, Float>> getGetMarkerAnchor() {
        return this.getMarkerAnchor;
    }

    public final void setGetMarkerAnchor(@Nullable Function2<? super SKMapVC.Marker, ? super Boolean, Pair<Float, Float>> function2) {
        this.getMarkerAnchor = function2;
    }

    public abstract void onSelectedMarker(@Nullable SKMapVC.Marker var1);

    public abstract void addMarkers(@NotNull List<? extends SKMapVC.Marker> var1);

    public abstract void onOnMapBoundsChange(@Nullable Function1<? super SKMapVC.LatLngBounds, Unit> var1);

    private final boolean oldLineStillAvailable(SKMapVC.Polyline polyline, List<SKMapVC.Polyline> polylines) {
        boolean bl;
        block5: {
            if (polyline.getId() != null) {
                Iterable $this$any$iv = polylines;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SKMapVC.Polyline it = (SKMapVC.Polyline)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)polyline.getId(), (Object)it.getId())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean oldPolygonStillAvailable(SKMapVC.Polygon polygon, List<SKMapVC.Polygon> polygons) {
        boolean bl;
        block5: {
            if (polygon.getId() != null) {
                Iterable $this$any$iv = polygons;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SKMapVC.Polygon it = (SKMapVC.Polygon)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)polygon.getId(), (Object)it.getId())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean newPolygonAlreadyExist(SKMapVC.Polygon polygon) {
        boolean bl;
        block5: {
            if (polygon.getId() != null) {
                Iterable $this$any$iv = this.polygonItems;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)polygon.getId(), (Object)((SKMapVC.Polygon)it.getFirst()).getId())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean newLineAlreadyExist(SKMapVC.Polyline polyline) {
        boolean bl;
        block5: {
            if (polyline.getId() != null) {
                Iterable $this$any$iv = this.polylineItems;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)polyline.getId(), (Object)((SKMapVC.Polyline)it.getFirst()).getId())) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public final void addPolygons(@NotNull List<SKMapVC.Polygon> polygons) {
        Intrinsics.checkNotNullParameter(polygons, (String)"polygons");
        this.mapView.getMapAsync(arg_0 -> MapInteractionHelper.addPolygons$lambda-15(this, polygons, arg_0));
    }

    public final void addLines(@NotNull List<SKMapVC.Polyline> polylines) {
        Intrinsics.checkNotNullParameter(polylines, (String)"polylines");
        this.mapView.getMapAsync(arg_0 -> MapInteractionHelper.addLines$lambda-27(this, polylines, arg_0));
    }

    @Nullable
    public final Bitmap getBitmap(@NotNull Context context, int resId, @Nullable Color color) {
        Bitmap bitmap;
        Drawable drawable;
        Drawable drawable2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Drawable drawable3 = ContextCompat.getDrawable((Context)context, (int)resId);
        if (drawable3 != null) {
            Drawable it = drawable3;
            boolean bl = false;
            drawable2 = color != null ? it.mutate() : it;
        } else {
            drawable2 = null;
        }
        Drawable drawable4 = drawable = drawable2;
        if (drawable4 != null) {
            Drawable it = drawable4;
            boolean bl = false;
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
            Color color2 = color;
            if (color2 != null) {
                Color it2 = color2;
                boolean bl2 = false;
                drawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(ResourcesExtensionsKt.toColor((Color)color, (Context)context), PorterDuff.Mode.MULTIPLY));
            }
            Bitmap bitmap2 = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(\n          \u2026g.ARGB_8888\n            )");
            Bitmap bitmap3 = bitmap2;
            Canvas canvas = new Canvas(bitmap3);
            drawable.draw(canvas);
            bitmap = bitmap3;
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    @Nullable
    public final BitmapDescriptor getIcon(@NotNull SKMapVC.Marker marker, boolean selected) {
        Object object;
        block19: {
            block21: {
                block23: {
                    String hash;
                    block22: {
                        SKMapView.BitmapDescriptorContainer bitmapDescriptorContainer5;
                        SKMapVC.Marker marker2;
                        block20: {
                            block18: {
                                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                                hash = (String)marker.getIconHash().invoke((Object)selected);
                                marker2 = marker;
                                if (!(marker2 instanceof SKMapVC.IconMarker)) break block18;
                                SKMapView.BitmapDescriptorContainer bitmapDescriptorContainer2 = (SKMapView.BitmapDescriptorContainer)this.memoryCache.get((Object)hash);
                                if (bitmapDescriptorContainer2 != null && (bitmapDescriptorContainer2 = bitmapDescriptorContainer2.getBitmapDescriptor()) != null) {
                                    SKMapView.BitmapDescriptorContainer bitmapDescriptorContainer3;
                                    SKMapView.BitmapDescriptorContainer $this$getIcon_u24lambda_u2d31 = bitmapDescriptorContainer3 = bitmapDescriptorContainer2;
                                    boolean bl = false;
                                    MapLoggerView.INSTANCE.d("icon : get icon bitmap " + marker.getId() + " from cache with hash " + hash);
                                    object = bitmapDescriptorContainer3;
                                } else {
                                    boolean bl = false;
                                    if (selected) {
                                        Bitmap bitmap = this.getBitmap(this.context, ((SKMapVC.IconMarker)marker).getSelectedIcon().getRes(), null);
                                        if (bitmap != null) {
                                            Bitmap it = bitmap;
                                            boolean bl2 = false;
                                            SKMapView.BitmapDescriptorContainer it2 = new SKMapView.BitmapDescriptorContainer(it);
                                            boolean bl3 = false;
                                            MapLoggerView.INSTANCE.d("icon : put icon bitmap " + marker.getId() + " in cache  with hash " + hash);
                                            this.memoryCache.put((Object)hash, (Object)it2);
                                            object = it2.getBitmapDescriptor();
                                        } else {
                                            object = null;
                                        }
                                    } else {
                                        Bitmap bitmap = this.getBitmap(this.context, ((SKMapVC.IconMarker)marker).getNormalIcon().getRes(), null);
                                        if (bitmap != null) {
                                            Bitmap it = bitmap;
                                            boolean bl4 = false;
                                            SKMapView.BitmapDescriptorContainer it3 = new SKMapView.BitmapDescriptorContainer(it);
                                            boolean bl5 = false;
                                            MapLoggerView.INSTANCE.d("icon : put icon bitmap " + marker.getId() + " in cache  with hash " + hash);
                                            this.memoryCache.put((Object)hash, (Object)it3);
                                            object = it3.getBitmapDescriptor();
                                        } else {
                                            object = null;
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (!(marker2 instanceof SKMapVC.ColorizedIconMarker)) break block20;
                            SKMapView.BitmapDescriptorContainer bitmapDescriptorContainer4 = (SKMapView.BitmapDescriptorContainer)this.memoryCache.get((Object)hash);
                            if (bitmapDescriptorContainer4 != null && (bitmapDescriptorContainer4 = bitmapDescriptorContainer4.getBitmapDescriptor()) != null) {
                                SKMapView.BitmapDescriptorContainer bl;
                                SKMapView.BitmapDescriptorContainer $this$getIcon_u24lambda_u2d37 = bl = bitmapDescriptorContainer4;
                                boolean bl6 = false;
                                MapLoggerView.INSTANCE.d("icon : get colorized bitmap " + marker.getId() + " from cache with hash " + hash);
                                object = bl;
                            } else {
                                boolean bitmapDescriptorContainer5 = false;
                                if (selected) {
                                    Bitmap bitmap = this.getBitmap(this.context, ((SKMapVC.ColorizedIconMarker)marker).getIcon().getRes(), ((SKMapVC.ColorizedIconMarker)marker).getSelectedColor());
                                    if (bitmap != null) {
                                        Bitmap it = bitmap;
                                        boolean bl = false;
                                        SKMapView.BitmapDescriptorContainer it4 = new SKMapView.BitmapDescriptorContainer(it);
                                        boolean bl7 = false;
                                        MapLoggerView.INSTANCE.d("icon : put colorized bitmap " + marker.getId() + " in cache  with hash " + hash);
                                        this.memoryCache.put((Object)hash, (Object)it4);
                                        object = it4.getBitmapDescriptor();
                                    } else {
                                        object = null;
                                    }
                                } else {
                                    Bitmap bitmap = this.getBitmap(this.context, ((SKMapVC.ColorizedIconMarker)marker).getIcon().getRes(), ((SKMapVC.ColorizedIconMarker)marker).getNormalColor());
                                    if (bitmap != null) {
                                        Bitmap it = bitmap;
                                        boolean bl = false;
                                        SKMapView.BitmapDescriptorContainer it5 = new SKMapView.BitmapDescriptorContainer(it);
                                        boolean bl8 = false;
                                        MapLoggerView.INSTANCE.d("icon : put colorized bitmap " + marker.getId() + " in cache  with hash " + hash);
                                        this.memoryCache.put((Object)hash, (Object)it5);
                                        object = it5.getBitmapDescriptor();
                                    } else {
                                        object = null;
                                    }
                                }
                            }
                            break block19;
                        }
                        if (!(marker2 instanceof SKMapVC.CustomMarker)) break block21;
                        SKMapView.BitmapDescriptorContainer bitmapDescriptorContainer6 = (SKMapView.BitmapDescriptorContainer)this.memoryCache.get((Object)hash);
                        if (bitmapDescriptorContainer6 == null || (bitmapDescriptorContainer6 = bitmapDescriptorContainer6.getBitmapDescriptor()) == null) break block22;
                        SKMapView.BitmapDescriptorContainer $this$getIcon_u24lambda_u2d43 = bitmapDescriptorContainer5 = bitmapDescriptorContainer6;
                        boolean bl = false;
                        MapLoggerView.INSTANCE.d("icon : get custom bitmap " + marker.getId() + " from cache with hash " + hash);
                        object = bitmapDescriptorContainer5;
                        break block19;
                    }
                    boolean bl = false;
                    object = this.onCreateCustomMarkerIcon;
                    if (object == null || (object = (Bitmap)object.invoke((Object)marker, (Object)selected)) == null) break block23;
                    Bitmap it = object;
                    boolean bl9 = false;
                    SKMapView.BitmapDescriptorContainer it6 = new SKMapView.BitmapDescriptorContainer(it);
                    boolean bl10 = false;
                    MapLoggerView.INSTANCE.d("icon : put custom bitmap " + marker.getId() + " in cache  with hash " + hash);
                    this.memoryCache.put((Object)hash, (Object)it6);
                    BitmapDescriptor bitmapDescriptor = it6.getBitmapDescriptor();
                    object = bitmapDescriptor;
                    if (bitmapDescriptor != null) break block19;
                }
                throw new NoSuchFieldException("onCreateCustomMarkerIcon must not be null with CustomMarker");
            }
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final void addPolygons$lambda-15(MapInteractionHelper this$0, List $polygons, GoogleMap googleMap) {
        void $this$mapTo$iv$iv;
        SKMapVC.Polygon it;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Object element$iv3;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$polygons, (String)"$polygons");
        Intrinsics.checkNotNullParameter((Object)googleMap, (String)"googleMap");
        Iterable $this$partition$iv = this$0.polygonItems;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv2 : $this$partition$iv) {
            Pair currentItem = (Pair)element$iv2;
            boolean bl = false;
            if (this$0.oldPolygonStillAvailable((SKMapVC.Polygon)currentItem.getFirst(), $polygons)) {
                first$iv.add(element$iv2);
                continue;
            }
            second$iv.add(element$iv2);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List oldItemsToUpdate = (List)pair.component1();
        List oldItemsToRemove = (List)pair.component2();
        Iterable $this$partition$iv2 = $polygons;
        boolean $i$f$partition2 = false;
        ArrayList first$iv2 = new ArrayList();
        ArrayList second$iv2 = new ArrayList();
        for (Object element$iv3 : $this$partition$iv2) {
            SKMapVC.Polygon marker = (SKMapVC.Polygon)element$iv3;
            boolean bl = false;
            if (this$0.newPolygonAlreadyExist(marker)) {
                first$iv2.add(element$iv3);
                continue;
            }
            second$iv2.add(element$iv3);
        }
        Pair pair2 = new Pair(first$iv2, second$iv2);
        List newValueForItemsToUpdate = (List)pair2.component1();
        List newItemsToAdd = (List)pair2.component2();
        Iterable $this$forEach$iv = oldItemsToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            Pair pair3 = (Pair)element$iv3;
            boolean bl = false;
            ((Polygon)pair3.getSecond()).remove();
        }
        Iterable $this$mapNotNull$iv = oldItemsToUpdate;
        boolean $i$f$mapNotNull = false;
        element$iv3 = $this$mapNotNull$iv;
        Iterable<Pair> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair4;
            Object v0;
            SKMapVC.Polygon it2;
            Pair currentPair;
            block12: {
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl6 = false;
                currentPair = (Pair)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable = newValueForItemsToUpdate;
                for (Object object : iterable) {
                    it2 = (SKMapVC.Polygon)object;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)((SKMapVC.Polygon)currentPair.getFirst()).getId())) continue;
                    v0 = object;
                    break block12;
                }
                v0 = null;
            }
            SKMapVC.Polygon polygon = v0;
            if (polygon != null) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                void $this$addPolygons_u24lambda_u2d15_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9;
                Object object;
                it = polygon;
                boolean bl7 = false;
                object = currentPair.getSecond();
                it2 = (Polygon)object;
                SKMapVC.Polygon polygon2 = it;
                boolean bl4 = false;
                Iterable iterable = it.getPoints();
                void var33_54 = $this$addPolygons_u24lambda_u2d15_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9;
                boolean $i$f$map = false;
                void var35_56 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it3;
                    Pair pair5 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl5 = false;
                    collection.add(new LatLng(((Number)it3.getFirst()).doubleValue(), ((Number)it3.getSecond()).doubleValue()));
                }
                var33_54.setPoints((List)destination$iv$iv2);
                $this$addPolygons_u24lambda_u2d15_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9.setVisible(!it.getHidden());
                $this$addPolygons_u24lambda_u2d15_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9.setFillColor(ResourcesExtensionsKt.toColor((Color)it.getFillColor(), (Context)this$0.context));
                $this$addPolygons_u24lambda_u2d15_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9.setStrokeColor(ResourcesExtensionsKt.toColor((Color)it.getStrokeColor(), (Context)this$0.context));
                $this$addPolygons_u24lambda_u2d15_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9.setStrokeWidth((float)ResourcesExtensionsKt.toPixelSize((Dimen)it.getLineWidth(), (Context)this$0.context));
                Object object2 = object;
                SKMapVC.Polygon polygon3 = polygon2;
                pair4 = new Pair((Object)polygon3, object2);
            } else {
                pair4 = null;
            }
            if (pair4 == null) continue;
            Pair it$iv$iv = pair4;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List updatedMarker = (List)destination$iv$iv;
        Iterable $this$map$iv = newItemsToAdd;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<LatLng> collection;
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            void polygon;
            element$iv$iv$iv = (SKMapVC.Polygon)item$iv$iv;
            Collection collection2 = destination$iv$iv3;
            boolean bl = false;
            Iterable bl6 = polygon.getPoints();
            PolygonOptions polygonOptions = new PolygonOptions();
            GoogleMap googleMap2 = googleMap;
            boolean $i$f$map2 = false;
            void bl7 = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void it4;
                Pair pair6 = (Pair)item$iv$iv2;
                collection = destination$iv$iv4;
                boolean bl8 = false;
                collection.add(new LatLng(((Number)it4.getFirst()).doubleValue(), ((Number)it4.getSecond()).doubleValue()));
            }
            collection = (List)destination$iv$iv4;
            it = googleMap2.addPolygon(polygonOptions.addAll((Iterable)collection).visible(!polygon.getHidden()).fillColor(ResourcesExtensionsKt.toColor((Color)polygon.getFillColor(), (Context)this$0.context)).strokeColor(ResourcesExtensionsKt.toColor((Color)polygon.getStrokeColor(), (Context)this$0.context)).strokeWidth((float)ResourcesExtensionsKt.toPixelSize((Dimen)polygon.getLineWidth(), (Context)this$0.context)));
            boolean bl9 = false;
            collection2.add(new Pair((Object)polygon, (Object)it));
        }
        List addedLines = (List)destination$iv$iv3;
        this$0.polygonItems = CollectionsKt.plus((Collection)updatedMarker, (Iterable)addedLines);
    }

    /*
     * WARNING - void declaration
     */
    private static final void addLines$lambda-27(MapInteractionHelper this$0, List $polylines, GoogleMap googleMap) {
        void $this$mapTo$iv$iv;
        SKMapVC.Polyline it;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Object element$iv3;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$polylines, (String)"$polylines");
        Intrinsics.checkNotNullParameter((Object)googleMap, (String)"googleMap");
        Iterable $this$partition$iv = this$0.polylineItems;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv2 : $this$partition$iv) {
            Pair currentItem = (Pair)element$iv2;
            boolean bl = false;
            if (this$0.oldLineStillAvailable((SKMapVC.Polyline)currentItem.getFirst(), $polylines)) {
                first$iv.add(element$iv2);
                continue;
            }
            second$iv.add(element$iv2);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List oldItemsToUpdate = (List)pair.component1();
        List oldItemsToRemove = (List)pair.component2();
        Iterable $this$partition$iv2 = $polylines;
        boolean $i$f$partition2 = false;
        ArrayList first$iv2 = new ArrayList();
        ArrayList second$iv2 = new ArrayList();
        for (Object element$iv3 : $this$partition$iv2) {
            SKMapVC.Polyline marker = (SKMapVC.Polyline)element$iv3;
            boolean bl = false;
            if (this$0.newLineAlreadyExist(marker)) {
                first$iv2.add(element$iv3);
                continue;
            }
            second$iv2.add(element$iv3);
        }
        Pair pair2 = new Pair(first$iv2, second$iv2);
        List newValueForItemsToUpdate = (List)pair2.component1();
        List newItemsToAdd = (List)pair2.component2();
        Iterable $this$forEach$iv = oldItemsToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            Pair pair3 = (Pair)element$iv3;
            boolean bl = false;
            ((Polyline)pair3.getSecond()).remove();
        }
        Iterable $this$mapNotNull$iv = oldItemsToUpdate;
        boolean $i$f$mapNotNull = false;
        element$iv3 = $this$mapNotNull$iv;
        Iterable<Pair> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair4;
            Object v0;
            SKMapVC.Polyline it2;
            Pair currentPair;
            block12: {
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl6 = false;
                currentPair = (Pair)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable = newValueForItemsToUpdate;
                for (Object object : iterable) {
                    it2 = (SKMapVC.Polyline)object;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)((SKMapVC.Polyline)currentPair.getFirst()).getId())) continue;
                    v0 = object;
                    break block12;
                }
                v0 = null;
            }
            SKMapVC.Polyline polyline = v0;
            if (polyline != null) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                void $this$addLines_u24lambda_u2d27_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21;
                Object object;
                it = polyline;
                boolean bl7 = false;
                object = currentPair.getSecond();
                it2 = (Polyline)object;
                SKMapVC.Polyline polyline2 = it;
                boolean bl4 = false;
                Iterable iterable = it.getPoints();
                void var33_54 = $this$addLines_u24lambda_u2d27_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21;
                boolean $i$f$map = false;
                void var35_56 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it3;
                    Pair pair5 = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl5 = false;
                    collection.add(new LatLng(((Number)it3.getFirst()).doubleValue(), ((Number)it3.getSecond()).doubleValue()));
                }
                var33_54.setPoints((List)destination$iv$iv2);
                $this$addLines_u24lambda_u2d27_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21.setVisible(!it.getHidden());
                $this$addLines_u24lambda_u2d27_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21.setColor(ResourcesExtensionsKt.toColor((Color)it.getColor(), (Context)this$0.context));
                $this$addLines_u24lambda_u2d27_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21.setWidth((float)ResourcesExtensionsKt.toPixelSize((Dimen)it.getLineWidth(), (Context)this$0.context));
                Object object2 = object;
                SKMapVC.Polyline polyline3 = polyline2;
                pair4 = new Pair((Object)polyline3, object2);
            } else {
                pair4 = null;
            }
            if (pair4 == null) continue;
            Pair it$iv$iv = pair4;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List updatedMarker = (List)destination$iv$iv;
        Iterable $this$map$iv = newItemsToAdd;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<LatLng> collection;
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            void line;
            element$iv$iv$iv = (SKMapVC.Polyline)item$iv$iv;
            Collection collection2 = destination$iv$iv3;
            boolean bl = false;
            Iterable bl6 = line.getPoints();
            PolylineOptions polylineOptions = new PolylineOptions();
            GoogleMap googleMap2 = googleMap;
            boolean $i$f$map2 = false;
            void bl7 = $this$map$iv2;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void it4;
                Pair pair6 = (Pair)item$iv$iv2;
                collection = destination$iv$iv4;
                boolean bl8 = false;
                collection.add(new LatLng(((Number)it4.getFirst()).doubleValue(), ((Number)it4.getSecond()).doubleValue()));
            }
            collection = (List)destination$iv$iv4;
            it = googleMap2.addPolyline(polylineOptions.addAll((Iterable)collection).visible(!line.getHidden()).color(ResourcesExtensionsKt.toColor((Color)line.getColor(), (Context)this$0.context)).width((float)ResourcesExtensionsKt.toPixelSize((Dimen)line.getLineWidth(), (Context)this$0.context)));
            boolean bl9 = false;
            collection2.add(new Pair((Object)line, (Object)it));
        }
        List addedLines = (List)destination$iv$iv3;
        this$0.polylineItems = CollectionsKt.plus((Collection)updatedMarker, (Iterable)addedLines);
    }
}

