/*
 * Decompiled with CFR 0.152.
 */
package tech.skot.libraries.map;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.skot.core.view.SKPermission;
import tech.skot.libraries.map.DeclaredPermissionHelper;
import tech.skot.view.SKPermissionAndroid;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ltech/skot/libraries/map/DeclaredPermissionHelperImpl;", "Ltech/skot/libraries/map/DeclaredPermissionHelper;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "isPermissionDeclaredForApp", "", "permission", "Ltech/skot/core/view/SKPermission;", "viewlegacy_release"})
public final class DeclaredPermissionHelperImpl
implements DeclaredPermissionHelper {
    @NotNull
    private final Context context;

    public DeclaredPermissionHelperImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public boolean isPermissionDeclaredForApp(@NotNull SKPermission permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        SKPermissionAndroid sKPermissionAndroid = permission instanceof SKPermissionAndroid ? (SKPermissionAndroid)permission : null;
        String name = sKPermissionAndroid != null ? sKPermissionAndroid.getName() : null;
        String packageName = this.context.getPackageName();
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(packageName, 4096);
            String[] declaredPermissions = packageInfo.requestedPermissions;
            if (declaredPermissions != null && !(declaredPermissions.length == 0)) {
                for (String p : declaredPermissions) {
                    if (!StringsKt.equals((String)p, (String)name, (boolean)true)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

