/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler.viewstateprovider;

import com.arellomobile.mvp.DefaultView;
import com.arellomobile.mvp.DefaultViewState;
import com.arellomobile.mvp.InjectViewState;
import com.arellomobile.mvp.MvpPresenter;
import com.arellomobile.mvp.compiler.ElementProcessor;
import com.arellomobile.mvp.compiler.MvpCompiler;
import com.arellomobile.mvp.compiler.Util;
import com.arellomobile.mvp.compiler.viewstateprovider.PresenterInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class InjectViewStateProcessor
extends ElementProcessor<TypeElement, PresenterInfo> {
    private static final String MVP_PRESENTER_CLASS = MvpPresenter.class.getCanonicalName();
    private final Set<TypeElement> usedViews = new HashSet<TypeElement>();
    private final List<TypeElement> presenterClassNames = new ArrayList<TypeElement>();

    public Set<TypeElement> getUsedViews() {
        return this.usedViews;
    }

    public List<TypeElement> getPresenterClassNames() {
        return this.presenterClassNames;
    }

    @Override
    public PresenterInfo process(TypeElement element) {
        this.presenterClassNames.add(element);
        return new PresenterInfo(element, this.getViewStateClassName(element));
    }

    private String getViewStateClassName(TypeElement typeElement) {
        String viewState = this.getViewStateClassFromAnnotationParams(typeElement);
        if (viewState == null) {
            String view = this.getViewClassFromAnnotationParams(typeElement);
            if (view == null) {
                view = this.getViewClassFromGeneric(typeElement);
            }
            if (view != null) {
                TypeElement viewTypeElement;
                if (view.contains("<")) {
                    view = view.substring(0, view.indexOf("<"));
                }
                if ((viewTypeElement = MvpCompiler.getElementUtils().getTypeElement(view)) == null) {
                    throw new IllegalArgumentException("View \"" + view + "\" for " + typeElement + " cannot be found");
                }
                this.usedViews.add(viewTypeElement);
                viewState = Util.getFullClassName(viewTypeElement) + "$$State";
            }
        }
        if (viewState != null) {
            return viewState;
        }
        return null;
    }

    private String getViewClassFromAnnotationParams(TypeElement typeElement) {
        InjectViewState annotation = typeElement.getAnnotation(InjectViewState.class);
        String mvpViewClassName = "";
        if (annotation != null) {
            TypeMirror value = null;
            try {
                annotation.view();
            }
            catch (MirroredTypeException mte) {
                value = mte.getTypeMirror();
            }
            mvpViewClassName = Util.getFullClassName(value);
        }
        if (mvpViewClassName.isEmpty() || DefaultView.class.getName().equals(mvpViewClassName)) {
            return null;
        }
        return mvpViewClassName;
    }

    private String getViewStateClassFromAnnotationParams(TypeElement typeElement) {
        InjectViewState annotation = typeElement.getAnnotation(InjectViewState.class);
        String mvpViewStateClassName = "";
        if (annotation != null) {
            try {
                annotation.value();
            }
            catch (MirroredTypeException mte) {
                TypeMirror value = mte.getTypeMirror();
                mvpViewStateClassName = value.toString();
            }
        }
        if (mvpViewStateClassName.isEmpty() || DefaultViewState.class.getName().equals(mvpViewStateClassName)) {
            return null;
        }
        return mvpViewStateClassName;
    }

    private String getViewClassFromGeneric(TypeElement typeElement) {
        TypeMirror superclass = typeElement.asType();
        Map<String, String> parentTypes = Collections.emptyMap();
        while (superclass.getKind() != TypeKind.NONE) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            List<? extends TypeMirror> typeArguments = ((DeclaredType)superclass).getTypeArguments();
            List<? extends TypeParameterElement> typeParameters = superclassElement.getTypeParameters();
            if (typeArguments.size() > typeParameters.size()) {
                throw new IllegalArgumentException("Code generation for interface " + typeElement.getSimpleName() + " failed. Simplify your generics. (" + typeArguments + " vs " + typeParameters + ")");
            }
            HashMap<String, String> types = new HashMap<String, String>();
            for (int i = 0; i < typeArguments.size(); ++i) {
                types.put(typeParameters.get(i).toString(), Util.fillGenerics(parentTypes, typeArguments.get(i)));
            }
            if (superclassElement.toString().equals(MVP_PRESENTER_CLASS)) {
                return Util.fillGenerics(parentTypes, typeArguments);
            }
            parentTypes = types;
            superclass = superclassElement.getSuperclass();
        }
        return "";
    }
}

