/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler;

import com.arellomobile.mvp.compiler.MvpCompiler;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;

public final class Util {
    public static String fillGenerics(Map<String, String> types, TypeMirror param) {
        return Util.fillGenerics(types, Collections.singletonList(param));
    }

    public static String fillGenerics(Map<String, String> types, List<? extends TypeMirror> params) {
        return Util.fillGenerics(types, params, ", ");
    }

    public static String fillGenerics(Map<String, String> types, List<? extends TypeMirror> params, String separator) {
        String result = "";
        for (TypeMirror typeMirror : params) {
            if (result.length() > 0) {
                result = result + separator;
            }
            if (typeMirror instanceof WildcardType) {
                TypeMirror superBound;
                result = result + "?";
                TypeMirror extendsBound = ((WildcardType)typeMirror).getExtendsBound();
                if (extendsBound != null) {
                    result = result + " extends " + Util.fillGenerics(types, extendsBound);
                }
                if ((superBound = ((WildcardType)typeMirror).getSuperBound()) == null) continue;
                result = result + " super " + Util.fillGenerics(types, superBound);
                continue;
            }
            if (typeMirror instanceof IntersectionType) {
                result = result + "?";
                List<? extends TypeMirror> bounds = ((IntersectionType)typeMirror).getBounds();
                if (bounds.isEmpty()) continue;
                result = result + " extends " + Util.fillGenerics(types, bounds, " & ");
                continue;
            }
            if (typeMirror instanceof DeclaredType) {
                result = result + ((DeclaredType)typeMirror).asElement();
                List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
                if (typeArguments.isEmpty()) continue;
                String s = Util.fillGenerics(types, typeArguments);
                result = result + "<" + s + ">";
                continue;
            }
            if (typeMirror instanceof TypeVariable) {
                String type = types.get(typeMirror.toString());
                if (type == null) {
                    type = typeMirror.toString();
                }
                result = result + type;
                continue;
            }
            result = result + typeMirror;
        }
        return result;
    }

    public static String getFullClassName(TypeMirror typeMirror) {
        if (!(typeMirror instanceof DeclaredType)) {
            return "";
        }
        TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
        return Util.getFullClassName(typeElement);
    }

    public static String getFullClassName(TypeElement typeElement) {
        String packageName = MvpCompiler.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString();
        if (packageName.length() > 0) {
            packageName = packageName + ".";
        }
        String className = typeElement.toString().substring(packageName.length());
        return packageName + className.replaceAll("\\.", "\\$");
    }

    public static AnnotationMirror getAnnotation(Element element, String annotationClass) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().toString().equals(annotationClass)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static TypeMirror getAnnotationValueAsTypeMirror(AnnotationMirror annotationMirror, String key) {
        AnnotationValue av = Util.getAnnotationValue(annotationMirror, key);
        if (av != null) {
            return (TypeMirror)av.getValue();
        }
        return null;
    }

    public static String getAnnotationValueAsString(AnnotationMirror annotationMirror, String key) {
        AnnotationValue av = Util.getAnnotationValue(annotationMirror, key);
        if (av != null) {
            return av.getValue().toString();
        }
        return null;
    }

    public static AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String key) {
        if (annotationMirror == null) {
            return null;
        }
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static Map<String, AnnotationValue> getAnnotationValues(AnnotationMirror annotationMirror) {
        if (annotationMirror == null) {
            return Collections.emptyMap();
        }
        HashMap<String, AnnotationValue> result = new HashMap<String, AnnotationValue>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            String key = entry.getKey().getSimpleName().toString();
            if (entry.getValue() == null) continue;
            result.put(key, entry.getValue());
        }
        return result;
    }

    public static boolean hasEmptyConstructor(TypeElement element) {
        for (Element element2 : element.getEnclosedElements()) {
            List<? extends VariableElement> parameters;
            if (element2.getKind() != ElementKind.CONSTRUCTOR || (parameters = ((ExecutableElement)element2).getParameters()) != null && !parameters.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static String decapitalizeString(String string) {
        return string == null || string.isEmpty() ? "" : (string.length() == 1 ? string.toLowerCase() : Character.toLowerCase(string.charAt(0)) + string.substring(1));
    }
}

