/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler.viewstate;

import com.arellomobile.mvp.compiler.MvpCompiler;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class ViewMethod {
    private final ExecutableElement methodElement;
    private final String name;
    private final TypeElement strategy;
    private final String tag;
    private final List<ParameterSpec> parameterSpecs;
    private final List<TypeName> exceptions;
    private final List<TypeVariableName> typeVariables;
    private final String argumentsString;
    private String uniqueSuffix;

    ViewMethod(DeclaredType targetInterfaceElement, ExecutableElement methodElement, TypeElement strategy, String tag) {
        this.methodElement = methodElement;
        this.name = methodElement.getSimpleName().toString();
        this.strategy = strategy;
        this.tag = tag;
        this.parameterSpecs = new ArrayList<ParameterSpec>();
        Types typeUtils = MvpCompiler.getTypeUtils();
        ExecutableType executableType = (ExecutableType)typeUtils.asMemberOf(targetInterfaceElement, methodElement);
        List<? extends VariableElement> parameters = methodElement.getParameters();
        List<? extends TypeMirror> resolvedParameterTypes = executableType.getParameterTypes();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement element = parameters.get(i);
            TypeName type = TypeName.get((TypeMirror)resolvedParameterTypes.get(i));
            String name = element.getSimpleName().toString();
            this.parameterSpecs.add(ParameterSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[0]).addModifiers(element.getModifiers()).build());
        }
        this.exceptions = methodElement.getThrownTypes().stream().map(TypeName::get).collect(Collectors.toList());
        this.typeVariables = methodElement.getTypeParameters().stream().map(TypeVariableName::get).collect(Collectors.toList());
        this.argumentsString = this.parameterSpecs.stream().map(parameterSpec -> parameterSpec.name).collect(Collectors.joining(", "));
        this.uniqueSuffix = "";
    }

    ExecutableElement getElement() {
        return this.methodElement;
    }

    String getName() {
        return this.name;
    }

    TypeElement getStrategy() {
        return this.strategy;
    }

    String getTag() {
        return this.tag;
    }

    List<ParameterSpec> getParameterSpecs() {
        return this.parameterSpecs;
    }

    List<TypeName> getExceptions() {
        return this.exceptions;
    }

    List<TypeVariableName> getTypeVariables() {
        return this.typeVariables;
    }

    String getArgumentsString() {
        return this.argumentsString;
    }

    String getCommandClassName() {
        return this.name.substring(0, 1).toUpperCase() + this.name.substring(1) + this.uniqueSuffix + "Command";
    }

    String getEnclosedClassName() {
        TypeElement typeElement = (TypeElement)this.methodElement.getEnclosingElement();
        return typeElement.getQualifiedName().toString();
    }

    String getUniqueSuffix() {
        return this.uniqueSuffix;
    }

    void setUniqueSuffix(String uniqueSuffix) {
        this.uniqueSuffix = uniqueSuffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewMethod that = (ViewMethod)o;
        return this.name.equals(that.name) && this.parameterSpecs.equals(that.parameterSpecs);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.parameterSpecs.hashCode();
        return result;
    }
}

