/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler.presenterbinder;

import com.arellomobile.mvp.MvpPresenter;
import com.arellomobile.mvp.PresenterBinder;
import com.arellomobile.mvp.compiler.JavaFilesGenerator;
import com.arellomobile.mvp.compiler.Util;
import com.arellomobile.mvp.compiler.presenterbinder.TargetClassInfo;
import com.arellomobile.mvp.compiler.presenterbinder.TargetPresenterField;
import com.arellomobile.mvp.presenter.PresenterField;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

public final class PresenterBinderClassGenerator
extends JavaFilesGenerator<TargetClassInfo> {
    @Override
    public List<JavaFile> generate(TargetClassInfo targetClassInfo) {
        ClassName targetClassName = targetClassInfo.getName();
        List<TargetPresenterField> fields = targetClassInfo.getFields();
        String containerSimpleName = String.join((CharSequence)"$", targetClassName.simpleNames());
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)(containerSimpleName + "$$PresentersBinder")).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(PresenterBinder.class), (TypeName[])new TypeName[]{targetClassName}));
        for (TargetPresenterField field : fields) {
            classBuilder.addType(PresenterBinderClassGenerator.generatePresenterBinderClass(field, targetClassName));
        }
        classBuilder.addMethod(PresenterBinderClassGenerator.generateGetPresentersMethod(fields, targetClassName));
        JavaFile javaFile = JavaFile.builder((String)targetClassName.packageName(), (TypeSpec)classBuilder.build()).indent("\t").build();
        return Collections.singletonList(javaFile);
    }

    private static MethodSpec generateGetPresentersMethod(List<TargetPresenterField> fields, ClassName containerClassName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getPresenterFields").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(PresenterField.class), (TypeName[])new TypeName[]{containerClassName})}));
        builder.addStatement("$T<$T<$T>> presenters = new $T<>($L)", new Object[]{List.class, PresenterField.class, containerClassName, ArrayList.class, fields.size()});
        for (TargetPresenterField field : fields) {
            builder.addStatement("presenters.add(new $L())", new Object[]{field.getGeneratedClassName()});
        }
        builder.addStatement("return presenters", new Object[0]);
        return builder.build();
    }

    private static TypeSpec generatePresenterBinderClass(TargetPresenterField field, ClassName targetClassName) {
        String tag = field.getTag();
        if (tag == null) {
            tag = field.getName();
        }
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)field.getGeneratedClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(PresenterField.class), (TypeName[])new TypeName[]{targetClassName})).addMethod(PresenterBinderClassGenerator.generatePresenterBinderConstructor(field, tag)).addMethod(PresenterBinderClassGenerator.generateBindMethod(field, targetClassName)).addMethod(PresenterBinderClassGenerator.generateProvidePresenterMethod(field, targetClassName));
        String tagProviderMethodName = field.getPresenterTagProviderMethodName();
        if (tagProviderMethodName != null) {
            classBuilder.addMethod(PresenterBinderClassGenerator.generateGetTagMethod(tagProviderMethodName, targetClassName));
        }
        return classBuilder.build();
    }

    private static MethodSpec generatePresenterBinderConstructor(TargetPresenterField field, String tag) {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($S, $T.$L, $S, $T.class)", new Object[]{tag, field.getPresenterType().getDeclaringClass(), field.getPresenterType().name(), field.getPresenterId(), field.getTypeName()}).build();
    }

    private static MethodSpec generateBindMethod(TargetPresenterField field, ClassName targetClassName) {
        return MethodSpec.methodBuilder((String)"bind").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)targetClassName, "target", new Modifier[0]).addParameter(MvpPresenter.class, "presenter", new Modifier[0]).addStatement("target.$L = ($T) presenter", new Object[]{field.getName(), field.getTypeName()}).build();
    }

    private static MethodSpec generateProvidePresenterMethod(TargetPresenterField field, ClassName targetClassName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"providePresenter").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(MvpPresenter.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)})).addParameter((TypeName)targetClassName, "delegated", new Modifier[0]);
        if (field.getPresenterProviderMethodName() != null) {
            builder.addStatement("return delegated.$L()", new Object[]{field.getPresenterProviderMethodName()});
        } else {
            boolean hasEmptyConstructor = Util.hasEmptyConstructor((TypeElement)((DeclaredType)field.getClazz()).asElement());
            if (hasEmptyConstructor) {
                builder.addStatement("return new $T()", new Object[]{field.getTypeName()});
            } else {
                builder.addStatement("throw new $T($S + $S)", new Object[]{IllegalStateException.class, field.getClazz(), " has not default constructor. You can apply @ProvidePresenter to some method which will construct Presenter. Also you can make it default constructor"});
            }
        }
        return builder.build();
    }

    private static MethodSpec generateGetTagMethod(String tagProviderMethodName, ClassName targetClassName) {
        return MethodSpec.methodBuilder((String)"getTag").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addParameter((TypeName)targetClassName, "delegated", new Modifier[0]).addStatement("return String.valueOf(delegated.$L())", new Object[]{tagProviderMethodName}).build();
    }
}

