/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.ramf;

import java.security.PrivateKey;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH&R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "", "recipientAddress", "", "payload", "", "senderCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "messageId", "creationTime", "Ljava/time/ZonedDateTime;", "ttl", "", "senderCertificateChain", "", "(Ljava/lang/String;[BLtech/relaycorp/relaynet/wrappers/x509/Certificate;Ljava/lang/String;Ljava/time/ZonedDateTime;Ljava/lang/Integer;Ljava/util/Set;)V", "getCreationTime", "()Ljava/time/ZonedDateTime;", "getMessageId", "()Ljava/lang/String;", "getPayload", "()[B", "getRecipientAddress", "getSenderCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getSenderCertificateChain", "()Ljava/util/Set;", "getTtl", "()I", "serialize", "senderPrivateKey", "Ljava/security/PrivateKey;", "relaynet"})
public abstract class RAMFMessage {
    @NotNull
    private final String messageId;
    @NotNull
    private final ZonedDateTime creationTime;
    private final int ttl;
    @NotNull
    private final Set<Certificate> senderCertificateChain;
    @NotNull
    private final String recipientAddress;
    @NotNull
    private final byte[] payload;
    @NotNull
    private final Certificate senderCertificate;

    @NotNull
    public final String getMessageId() {
        return this.messageId;
    }

    @NotNull
    public final ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    public final int getTtl() {
        return this.ttl;
    }

    @NotNull
    public final Set<Certificate> getSenderCertificateChain() {
        return this.senderCertificateChain;
    }

    @NotNull
    public abstract byte[] serialize(@NotNull PrivateKey var1);

    @NotNull
    public final String getRecipientAddress() {
        return this.recipientAddress;
    }

    @NotNull
    public final byte[] getPayload() {
        return this.payload;
    }

    @NotNull
    public final Certificate getSenderCertificate() {
        return this.senderCertificate;
    }

    public RAMFMessage(@NotNull String recipientAddress, @NotNull byte[] payload, @NotNull Certificate senderCertificate, @Nullable String messageId, @Nullable ZonedDateTime creationTime, @Nullable Integer ttl, @Nullable Set<Certificate> senderCertificateChain) {
        Intrinsics.checkParameterIsNotNull((Object)recipientAddress, (String)"recipientAddress");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)senderCertificate, (String)"senderCertificate");
        this.recipientAddress = recipientAddress;
        this.payload = payload;
        this.senderCertificate = senderCertificate;
        String string = messageId;
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
        }
        this.messageId = string;
        ZonedDateTime zonedDateTime = creationTime;
        if (zonedDateTime == null) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now(ZoneId.of("UTC"));
            zonedDateTime = zonedDateTime2;
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime2, (String)"ZonedDateTime.now(ZoneId.of(\"UTC\"))");
        }
        this.creationTime = zonedDateTime;
        Integer n = ttl;
        this.ttl = n != null ? n : 300;
        RAMFMessage rAMFMessage = this;
        Set<Certificate> set = senderCertificateChain;
        if (set == null) {
            RAMFMessage rAMFMessage2 = rAMFMessage;
            boolean bl = false;
            Set<Certificate> set2 = SetsKt.emptySet();
            rAMFMessage = rAMFMessage2;
            set = rAMFMessage.senderCertificateChain = set2;
        }
        if (1023 < this.recipientAddress.length()) {
            throw (Throwable)new RAMFException("Recipient address cannot span more than 1023 octets " + "(got " + this.recipientAddress.length() + ')');
        }
        if (255 < this.messageId.length()) {
            throw (Throwable)new RAMFException("Message id cannot span more than 255 octets " + "(got " + this.messageId.length() + ')');
        }
        if (this.ttl < 0) {
            throw (Throwable)new RAMFException("TTL cannot be negative (got " + this.ttl + ')');
        }
        if (15552000 < this.ttl) {
            throw (Throwable)new RAMFException("TTL cannot be greater than 15552000 (got " + this.ttl + ')');
        }
        if (0x800000 < this.payload.length) {
            throw (Throwable)new RAMFException("Payload cannot span more than 8388608 octets (got " + this.payload.length + ')');
        }
    }
}

