/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.ramf;

import java.security.PrivateKey;
import java.time.ZonedDateTime;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH&R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "", "recipientAddress", "", "messageId", "creationTime", "Ljava/time/ZonedDateTime;", "ttl", "", "payload", "", "senderCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "senderCertificateChain", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/time/ZonedDateTime;I[BLtech/relaycorp/relaynet/wrappers/x509/Certificate;Ljava/util/Set;)V", "getCreationTime", "()Ljava/time/ZonedDateTime;", "getMessageId", "()Ljava/lang/String;", "getPayload", "()[B", "getRecipientAddress", "getSenderCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getSenderCertificateChain", "()Ljava/util/Set;", "getTtl", "()I", "serialize", "senderPrivateKey", "Ljava/security/PrivateKey;", "relaynet"})
public abstract class RAMFMessage {
    @NotNull
    private final String recipientAddress;
    @NotNull
    private final String messageId;
    @NotNull
    private final ZonedDateTime creationTime;
    private final int ttl;
    @NotNull
    private final byte[] payload;
    @NotNull
    private final Certificate senderCertificate;
    @NotNull
    private final Set<Certificate> senderCertificateChain;

    @NotNull
    public abstract byte[] serialize(@NotNull PrivateKey var1);

    @NotNull
    public final String getRecipientAddress() {
        return this.recipientAddress;
    }

    @NotNull
    public final String getMessageId() {
        return this.messageId;
    }

    @NotNull
    public final ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    public final int getTtl() {
        return this.ttl;
    }

    @NotNull
    public final byte[] getPayload() {
        return this.payload;
    }

    @NotNull
    public final Certificate getSenderCertificate() {
        return this.senderCertificate;
    }

    @NotNull
    public final Set<Certificate> getSenderCertificateChain() {
        return this.senderCertificateChain;
    }

    public RAMFMessage(@NotNull String recipientAddress, @NotNull String messageId, @NotNull ZonedDateTime creationTime, int ttl, @NotNull byte[] payload, @NotNull Certificate senderCertificate, @NotNull Set<Certificate> senderCertificateChain) {
        Intrinsics.checkParameterIsNotNull((Object)recipientAddress, (String)"recipientAddress");
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        Intrinsics.checkParameterIsNotNull((Object)creationTime, (String)"creationTime");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)senderCertificate, (String)"senderCertificate");
        Intrinsics.checkParameterIsNotNull(senderCertificateChain, (String)"senderCertificateChain");
        this.recipientAddress = recipientAddress;
        this.messageId = messageId;
        this.creationTime = creationTime;
        this.ttl = ttl;
        this.payload = payload;
        this.senderCertificate = senderCertificate;
        this.senderCertificateChain = senderCertificateChain;
        if (1023 < this.recipientAddress.length()) {
            throw (Throwable)new RAMFException("Recipient address cannot span more than 1023 octets (got " + this.recipientAddress.length() + ')');
        }
        if (255 < this.messageId.length()) {
            throw (Throwable)new RAMFException("Message id cannot span more than 255 octets (got " + this.messageId.length() + ')');
        }
        if (this.ttl < 0) {
            throw (Throwable)new RAMFException("TTL cannot be negative (got " + this.ttl + ')');
        }
        if (15552000 < this.ttl) {
            throw (Throwable)new RAMFException("TTL cannot be greater than 15552000 (got " + this.ttl + ')');
        }
        if (0x800000 < this.payload.length) {
            throw (Throwable)new RAMFException("Payload cannot span more than 8388608 octets (got " + this.payload.length + ')');
        }
    }
}

