/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Ltech/relaycorp/relaynet/messages/control/HandshakeChallenge;", "", "nonce", "", "([B)V", "getNonce", "()[B", "serialize", "Companion", "relaynet"})
public final class HandshakeChallenge {
    @NotNull
    private final byte[] nonce;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize() {
        return ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)new DEROctetString(this.nonce)}, false);
    }

    @NotNull
    public final byte[] getNonce() {
        return this.nonce;
    }

    public HandshakeChallenge(@NotNull byte[] nonce) {
        Intrinsics.checkParameterIsNotNull((Object)nonce, (String)"nonce");
        this.nonce = nonce;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/messages/control/HandshakeChallenge$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/HandshakeChallenge;", "serialization", "", "relaynet"})
    public static final class Companion {
        @NotNull
        public final HandshakeChallenge deserialize(@NotNull byte[] serialization) {
            ASN1TaggedObject[] sequence;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw (Throwable)new InvalidMessageException("Handshake challenge is not a DER sequence", exc);
            }
            aSN1TaggedObjectArray = sequence = aSN1TaggedObjectArray;
            boolean bl = false;
            if (aSN1TaggedObjectArray.length == 0) {
                throw (Throwable)new InvalidMessageException("Handshake challenge sequence should have at least 1 item", null, 2, null);
            }
            DERVisibleString nonceASN1 = ASN1Utils.INSTANCE.getVisibleString(sequence[0]);
            byte[] byArray = nonceASN1.getOctets();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"nonceASN1.octets");
            return new HandshakeChallenge(byArray);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

