/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.x509;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.wrappers.PRNGKt;
import tech.relaycorp.relaynet.wrappers.x509.BasicConstraintsExtension;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 =2\u00020\u0001:\u0001=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00000'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00000'H\u0002J\u0018\u0010)\u001a\n +*\u0004\u0018\u00010*0*2\u0006\u0010,\u001a\u00020\u0000H\u0002J\u0018\u0010-\u001a\n +*\u0004\u0018\u00010\u00120\u00122\u0006\u0010.\u001a\u00020/H\u0002J\u0013\u00100\u001a\u00020\u00162\b\u00101\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J-\u00102\u001a\b\u0012\u0004\u0012\u00020\u0000032\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00000'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00000'\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u000206H\u0016J\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u00020:H\u0002J\b\u0010<\u001a\u00020:H\u0002R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001a\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u0011\u0010\u001c\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0014R\u0011\u0010\u001e\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0010R\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006>"}, d2={"Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "", "certificateHolder", "Lorg/bouncycastle/cert/X509CertificateHolder;", "(Lorg/bouncycastle/cert/X509CertificateHolder;)V", "basicConstraints", "Lorg/bouncycastle/asn1/x509/BasicConstraints;", "getBasicConstraints", "()Lorg/bouncycastle/asn1/x509/BasicConstraints;", "basicConstraints$delegate", "Lkotlin/Lazy;", "getCertificateHolder", "()Lorg/bouncycastle/cert/X509CertificateHolder;", "commonName", "", "getCommonName", "()Ljava/lang/String;", "expiryDate", "Ljava/time/ZonedDateTime;", "getExpiryDate", "()Ljava/time/ZonedDateTime;", "isCA", "", "isCA$relaynet", "()Z", "isCA$delegate", "issuerCommonName", "getIssuerCommonName", "startDate", "getStartDate", "subjectPrivateAddress", "getSubjectPrivateAddress", "subjectPublicKey", "Ljava/security/PublicKey;", "getSubjectPublicKey", "()Ljava/security/PublicKey;", "buildPath", "Ljava/security/cert/PKIXCertPathBuilderResult;", "intermediateCAs", "", "trustedCAs", "convertCertToJava", "Ljava/security/cert/X509Certificate;", "kotlin.jvm.PlatformType", "certificate", "dateToZonedDateTime", "date", "Ljava/util/Date;", "equals", "other", "getCertificationPath", "", "(Ljava/util/Collection;Ljava/util/Collection;)[Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "hashCode", "", "serialize", "", "validate", "", "validateCommonNamePresence", "validateValidityPeriod", "Companion", "relaynet"})
public final class Certificate {
    private final Lazy basicConstraints$delegate;
    @NotNull
    private final Lazy isCA$delegate;
    @NotNull
    private final X509CertificateHolder certificateHolder;
    private static final JcaX509CertificateConverter bcToJavaCertificateConverter;
    public static final Companion Companion;

    @NotNull
    public final String getCommonName() {
        X500Name x500Name = this.certificateHolder.getSubject();
        Intrinsics.checkExpressionValueIsNotNull((Object)x500Name, (String)"certificateHolder.subject");
        return Certificate.Companion.getCommonName(x500Name);
    }

    @NotNull
    public final PublicKey getSubjectPublicKey() {
        X509Certificate x509Certificate = this.convertCertToJava(this);
        Intrinsics.checkExpressionValueIsNotNull((Object)x509Certificate, (String)"convertCertToJava(this)");
        PublicKey publicKey = x509Certificate.getPublicKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"convertCertToJava(this).publicKey");
        return publicKey;
    }

    @NotNull
    public final String getSubjectPrivateAddress() {
        StringBuilder stringBuilder = new StringBuilder().append("0");
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.certificateHolder.getSubjectPublicKeyInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)subjectPublicKeyInfo, (String)"certificateHolder.subjectPublicKeyInfo");
        byte[] byArray = subjectPublicKeyInfo.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"certificateHolder.subjectPublicKeyInfo.encoded");
        return stringBuilder.append(CryptoUtils.getSHA256DigestHex(byArray)).toString();
    }

    @NotNull
    public final String getIssuerCommonName() {
        X500Name x500Name = this.certificateHolder.getIssuer();
        Intrinsics.checkExpressionValueIsNotNull((Object)x500Name, (String)"certificateHolder.issuer");
        return Certificate.Companion.getCommonName(x500Name);
    }

    @NotNull
    public final ZonedDateTime getStartDate() {
        Date date = this.certificateHolder.getNotBefore();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"certificateHolder.notBefore");
        ZonedDateTime zonedDateTime = this.dateToZonedDateTime(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"dateToZonedDateTime(certificateHolder.notBefore)");
        return zonedDateTime;
    }

    @NotNull
    public final ZonedDateTime getExpiryDate() {
        Date date = this.certificateHolder.getNotAfter();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"certificateHolder.notAfter");
        ZonedDateTime zonedDateTime = this.dateToZonedDateTime(date);
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"dateToZonedDateTime(certificateHolder.notAfter)");
        return zonedDateTime;
    }

    private final BasicConstraints getBasicConstraints() {
        Lazy lazy = this.basicConstraints$delegate;
        Certificate certificate = this;
        Object var3_3 = null;
        boolean bl = false;
        return (BasicConstraints)lazy.getValue();
    }

    public final boolean isCA$relaynet() {
        Lazy lazy = this.isCA$delegate;
        Certificate certificate = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Certificate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.certificateHolder, (Object)((Certificate)other).certificateHolder);
    }

    public int hashCode() {
        return this.certificateHolder.hashCode();
    }

    @NotNull
    public final byte[] serialize() {
        byte[] byArray = this.certificateHolder.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"certificateHolder.encoded");
        return byArray;
    }

    public final void validate() throws CertificateException {
        this.validateValidityPeriod();
        this.validateCommonNamePresence();
    }

    private final void validateValidityPeriod() {
        ZonedDateTime now = ZonedDateTime.now();
        if (now.compareTo(this.getStartDate()) < 0) {
            throw (Throwable)new CertificateException("Certificate is not yet valid", null, 2, null);
        }
        if (this.getExpiryDate().compareTo(now) < 0) {
            throw (Throwable)new CertificateException("Certificate already expired", null, 2, null);
        }
    }

    private final void validateCommonNamePresence() {
        RDN[] rDNArray = this.certificateHolder.getSubject().getRDNs(BCStyle.CN);
        Intrinsics.checkExpressionValueIsNotNull((Object)rDNArray, (String)"certificateHolder.subject.getRDNs(BCStyle.CN)");
        RDN[] rDNArray2 = rDNArray;
        boolean bl = false;
        if (rDNArray2.length == 0) {
            throw (Throwable)new CertificateException("Subject should have a Common Name", null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Certificate[] getCertificationPath(@NotNull Collection<Certificate> intermediateCAs, @NotNull Collection<Certificate> trustedCAs) throws CertificateException {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        PKIXCertPathBuilderResult pKIXCertPathBuilderResult;
        Intrinsics.checkParameterIsNotNull(intermediateCAs, (String)"intermediateCAs");
        Intrinsics.checkParameterIsNotNull(trustedCAs, (String)"trustedCAs");
        try {
            pKIXCertPathBuilderResult = this.buildPath(intermediateCAs, trustedCAs);
        }
        catch (CertPathBuilderException exc) {
            throw (Throwable)new CertificateException("No certification path could be found", exc);
        }
        PKIXCertPathBuilderResult pathBuilderResult = pKIXCertPathBuilderResult;
        CertPath certPath = pathBuilderResult.getCertPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)certPath, (String)"pathBuilderResult.certPath");
        List<? extends java.security.cert.Certificate> list = certPath.getCertificates();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"pathBuilderResult.certPath.certificates");
        Iterable $this$map$iv = list;
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            java.security.cert.Certificate certificate = (java.security.cert.Certificate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            object = new X509CertificateHolder(v2.getEncoded());
            collection.add(object);
        }
        List bcCertPath = (List)destination$iv$iv;
        $i$f$map = 1;
        Iterable $this$map$iv2 = CollectionsKt.slice((List)bcCertPath, (IntRange)new IntRange($i$f$map, CollectionsKt.getLastIndex((List)bcCertPath)));
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            X509CertificateHolder bl = (X509CertificateHolder)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Iterable $this$single$iv = intermediateCAs;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                void copy;
                Certificate original = (Certificate)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)copy, (Object)original.certificateHolder)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            object = single$iv;
            collection.add(object);
        }
        List cAs = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
        TrustAnchor trustAnchor = pathBuilderResult.getTrustAnchor();
        Intrinsics.checkExpressionValueIsNotNull((Object)trustAnchor, (String)"pathBuilderResult.trustAnchor");
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        Intrinsics.checkExpressionValueIsNotNull((Object)x509Certificate, (String)"pathBuilderResult.trustAnchor.trustedCert");
        X509CertificateHolder bcRootCACert = new X509CertificateHolder(x509Certificate.getEncoded());
        if (Intrinsics.areEqual((Object)bcRootCACert, (Object)this.certificateHolder) ^ true) {
            Iterable $this$single$iv = trustedCAs;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                Certificate it = (Certificate)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.certificateHolder, (Object)bcRootCACert)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Certificate rootCACert = single$iv;
            cAs.add(rootCACert);
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)this);
        Collection rootCACert = cAs;
        object = spreadBuilder;
        collection = spreadBuilder;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Certificate[] certificateArray = thisCollection$iv.toArray(new Certificate[0]);
        if (certificateArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Certificate[] certificateArray2 = certificateArray;
        Collection collection2 = collection;
        object.addSpread((Object)certificateArray2);
        return (Certificate[])collection2.toArray(new Certificate[collection2.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private final PKIXCertPathBuilderResult buildPath(Collection<Certificate> intermediateCAs, Collection<Certificate> trustedCAs) throws CertPathBuilderException {
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        X509Certificate javaEndEntityCert = this.convertCertToJava(this);
        Iterable iterable = intermediateCAs;
        Object object2 = this;
        boolean $i$f$map22 = false;
        void var8_8 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p1;
            Certificate certificate = (Certificate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = ((Certificate)object2).convertCertToJava((Certificate)p1);
            collection.add(object);
        }
        List javaIntermediateCACerts = (List)destination$iv$iv;
        object2 = trustedCAs;
        Certificate $i$f$map22 = this;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            Certificate bl = (Certificate)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = $i$f$map22.convertCertToJava((Certificate)p1);
            collection.add(object);
        }
        List javaTrustedCACerts = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = javaTrustedCACerts;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv3;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            X509Certificate p1 = (X509Certificate)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = new TrustAnchor((X509Certificate)it, null);
            collection.add(object);
        }
        Set trustAnchors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        CertStore intermediateCertStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(javaIntermediateCACerts), (Provider)CryptoUtils.getBC_PROVIDER());
        X509CertSelector endEntitySelector = new X509CertSelector();
        endEntitySelector.setCertificate(javaEndEntityCert);
        try {
            destination$iv$iv2 = new PKIXBuilderParameters(trustAnchors, (CertSelector)endEntitySelector);
        }
        catch (InvalidAlgorithmParameterException exc) {
            throw (Throwable)new CertificateException("Failed to initialize path builder; set of trusted CAs might be empty", exc);
        }
        PKIXParameters parameters = (PKIXParameters)destination$iv$iv2;
        parameters.setRevocationEnabled(false);
        parameters.addCertStore(intermediateCertStore);
        CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", (Provider)CryptoUtils.getBC_PROVIDER());
        Intrinsics.checkExpressionValueIsNotNull((Object)certPathBuilder, (String)"CertPathBuilder.getInsta\u2026ormance reasons\n        )");
        CertPathBuilder pathBuilder = certPathBuilder;
        CertPathBuilderResult certPathBuilderResult = pathBuilder.build(parameters);
        if (certPathBuilderResult == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.cert.PKIXCertPathBuilderResult");
        }
        return (PKIXCertPathBuilderResult)certPathBuilderResult;
    }

    private final X509Certificate convertCertToJava(Certificate certificate) {
        return bcToJavaCertificateConverter.getCertificate(certificate.certificateHolder);
    }

    private final ZonedDateTime dateToZonedDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault());
    }

    @NotNull
    public final X509CertificateHolder getCertificateHolder() {
        return this.certificateHolder;
    }

    public Certificate(@NotNull X509CertificateHolder certificateHolder) {
        Intrinsics.checkParameterIsNotNull((Object)certificateHolder, (String)"certificateHolder");
        this.certificateHolder = certificateHolder;
        this.basicConstraints$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BasicConstraints>(this){
            final /* synthetic */ Certificate this$0;

            public final BasicConstraints invoke() {
                return BasicConstraints.fromExtensions((Extensions)this.this$0.getCertificateHolder().getExtensions());
            }
            {
                this.this$0 = certificate;
                super(0);
            }
        }));
        this.isCA$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ Certificate this$0;

            public final boolean invoke() {
                BasicConstraints basicConstraints2 = Certificate.access$getBasicConstraints$p(this.this$0);
                return basicConstraints2 != null && basicConstraints2.isCA();
            }
            {
                this.this$0 = certificate;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter().setProvider((Provider)CryptoUtils.getBC_PROVIDER());
        Intrinsics.checkExpressionValueIsNotNull((Object)jcaX509CertificateConverter, (String)"JcaX509CertificateConver\u2026.setProvider(BC_PROVIDER)");
        bcToJavaCertificateConverter = jcaX509CertificateConverter;
    }

    public static final /* synthetic */ BasicConstraints access$getBasicConstraints$p(Certificate $this) {
        return $this.getBasicConstraints();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002JW\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltech/relaycorp/relaynet/wrappers/x509/Certificate$Companion;", "", "()V", "bcToJavaCertificateConverter", "Lorg/bouncycastle/cert/jcajce/JcaX509CertificateConverter;", "buildDistinguishedName", "Lorg/bouncycastle/asn1/x500/X500Name;", "commonName", "", "deserialize", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "certificateSerialized", "", "getCommonName", "x500Name", "issue", "subjectCommonName", "subjectPublicKey", "Ljava/security/PublicKey;", "issuerPrivateKey", "Ljava/security/PrivateKey;", "validityEndDate", "Ljava/time/ZonedDateTime;", "issuerCertificate", "isCA", "", "pathLenConstraint", "", "validityStartDate", "issue$relaynet", "relaynet"})
    public static final class Companion {
        @NotNull
        public final Certificate issue$relaynet(@NotNull String subjectCommonName, @NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull ZonedDateTime validityEndDate, @Nullable Certificate issuerCertificate, boolean isCA2, int pathLenConstraint, @NotNull ZonedDateTime validityStartDate) throws CertificateException {
            X509CertificateHolder certificateHolder;
            Intrinsics.checkParameterIsNotNull((Object)subjectCommonName, (String)"subjectCommonName");
            Intrinsics.checkParameterIsNotNull((Object)subjectPublicKey, (String)"subjectPublicKey");
            Intrinsics.checkParameterIsNotNull((Object)issuerPrivateKey, (String)"issuerPrivateKey");
            Intrinsics.checkParameterIsNotNull((Object)validityEndDate, (String)"validityEndDate");
            Intrinsics.checkParameterIsNotNull((Object)validityStartDate, (String)"validityStartDate");
            if (validityStartDate.compareTo(validityEndDate) >= 0) {
                throw (Throwable)new CertificateException("The end date must be later than the start date", null, 2, null);
            }
            if (issuerCertificate != null && !issuerCertificate.isCA$relaynet()) {
                throw (Throwable)new CertificateException("Issuer certificate should be marked as CA", null, 2, null);
            }
            X500Name subjectDistinguishedName = this.buildDistinguishedName(subjectCommonName);
            X500Name issuerDistinguishedName = issuerCertificate != null ? issuerCertificate.getCertificateHolder().getSubject() : subjectDistinguishedName;
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)subjectPublicKey.getEncoded());
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuerDistinguishedName, PRNGKt.generateRandomBigInteger(), Date.from(validityStartDate.toInstant()), Date.from(validityEndDate.toInstant()), subjectDistinguishedName, subjectPublicKeyInfo);
            BasicConstraintsExtension basicConstraints2 = new BasicConstraintsExtension(isCA2, pathLenConstraint);
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)basicConstraints2);
            SubjectPublicKeyInfo subjectPublicKeyInfo2 = subjectPublicKeyInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)subjectPublicKeyInfo2, (String)"subjectPublicKeyInfo");
            byte[] byArray = subjectPublicKeyInfo2.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"subjectPublicKeyInfo.encoded");
            byte[] subjectPublicKeyDigest = CryptoUtils.getSHA256Digest(byArray);
            SubjectKeyIdentifier subjectSKI = new SubjectKeyIdentifier(subjectPublicKeyDigest);
            builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)subjectSKI);
            SubjectKeyIdentifier issuerSKI = subjectSKI;
            if (issuerCertificate != null) {
                SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.fromExtensions((Extensions)issuerCertificate.getCertificateHolder().getExtensions());
                if (subjectKeyIdentifier == null) {
                    throw (Throwable)new CertificateException("Issuer must have the SubjectKeyIdentifier extension", null, 2, null);
                }
                issuerSKI = subjectKeyIdentifier;
            }
            AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(issuerSKI.getKeyIdentifier());
            builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)aki);
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WITHRSAANDMGF1").setProvider((Provider)CryptoUtils.getBC_PROVIDER()).build(issuerPrivateKey);
            X509CertificateHolder x509CertificateHolder = certificateHolder = builder.build(signer);
            Intrinsics.checkExpressionValueIsNotNull((Object)x509CertificateHolder, (String)"certificateHolder");
            return new Certificate(x509CertificateHolder);
        }

        public static /* synthetic */ Certificate issue$relaynet$default(Companion companion, String string, PublicKey publicKey, PrivateKey privateKey, ZonedDateTime zonedDateTime, Certificate certificate, boolean bl, int n, ZonedDateTime zonedDateTime2, int n2, Object object) throws CertificateException {
            if ((n2 & 0x10) != 0) {
                certificate = null;
            }
            if ((n2 & 0x20) != 0) {
                bl = false;
            }
            if ((n2 & 0x40) != 0) {
                n = 0;
            }
            if ((n2 & 0x80) != 0) {
                ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime3, (String)"ZonedDateTime.now()");
                zonedDateTime2 = zonedDateTime3;
            }
            return companion.issue$relaynet(string, publicKey, privateKey, zonedDateTime, certificate, bl, n, zonedDateTime2);
        }

        private final X500Name buildDistinguishedName(String commonName) throws CertificateException {
            X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
            builder.addRDN(BCStyle.CN, (ASN1Encodable)new DERBMPString(commonName));
            X500Name x500Name = builder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)x500Name, (String)"builder.build()");
            return x500Name;
        }

        @NotNull
        public final Certificate deserialize(@NotNull byte[] certificateSerialized) throws CertificateException {
            X509CertificateHolder x509CertificateHolder;
            Intrinsics.checkParameterIsNotNull((Object)certificateSerialized, (String)"certificateSerialized");
            try {
                x509CertificateHolder = new X509CertificateHolder(certificateSerialized);
            }
            catch (IOException exc) {
                throw (Throwable)new CertificateException("Value should be a DER-encoded, X.509 v3 certificate", exc);
            }
            X509CertificateHolder certificateHolder = x509CertificateHolder;
            return new Certificate(certificateHolder);
        }

        private final String getCommonName(X500Name x500Name) {
            Object[] commonNames = x500Name.getRDNs(BCStyle.CN);
            Intrinsics.checkExpressionValueIsNotNull((Object)commonNames, (String)"commonNames");
            Object object = ArraysKt.first((Object[])commonNames);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"commonNames.first()");
            AttributeTypeAndValue attributeTypeAndValue = ((RDN)object).getFirst();
            Intrinsics.checkExpressionValueIsNotNull((Object)attributeTypeAndValue, (String)"commonNames.first().first");
            return attributeTypeAndValue.getValue().toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

