/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.cms;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.ECKey;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyAgreeEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataException;
import tech.relaycorp.relaynet.wrappers.cms.RecipientIdentifier;
import tech.relaycorp.relaynet.wrappers.cms.SessionEnvelopedData;
import tech.relaycorp.relaynet.wrappers.cms.SessionlessEnvelopedData;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH&J\u0006\u0010\r\u001a\u00020\bJ\b\u0010\u000e\u001a\u00020\u000fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "", "bcEnvelopedData", "Lorg/bouncycastle/cms/CMSEnvelopedData;", "(Lorg/bouncycastle/cms/CMSEnvelopedData;)V", "getBcEnvelopedData", "()Lorg/bouncycastle/cms/CMSEnvelopedData;", "decrypt", "", "privateKey", "Ljava/security/PrivateKey;", "getRecipientKeyId", "Ltech/relaycorp/relaynet/wrappers/cms/RecipientIdentifier;", "serialize", "validate", "", "Companion", "relaynet"})
public abstract class EnvelopedData {
    @NotNull
    private final CMSEnvelopedData bcEnvelopedData;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize() {
        byte[] byArray = this.bcEnvelopedData.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"bcEnvelopedData.encoded");
        return byArray;
    }

    @NotNull
    public final byte[] decrypt(@NotNull PrivateKey privateKey) throws EnvelopedDataException {
        byte[] byArray;
        Collection recipients;
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
        RecipientInformationStore recipientInformationStore = this.bcEnvelopedData.getRecipientInfos();
        Intrinsics.checkExpressionValueIsNotNull((Object)recipientInformationStore, (String)"bcEnvelopedData.recipientInfos");
        Collection collection = recipients = recipientInformationStore.getRecipients();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"recipients");
        RecipientInformation recipientInfo = (RecipientInformation)CollectionsKt.first((Iterable)collection);
        Recipient recipient = privateKey instanceof ECKey ? (Recipient)new JceKeyAgreeEnvelopedRecipient(privateKey).setProvider((Provider)CryptoUtils.getBC_PROVIDER()) : (Recipient)new JceKeyTransEnvelopedRecipient(privateKey).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
        try {
            byte[] byArray2 = recipientInfo.getContent(recipient);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"recipientInfo.getContent(recipient)");
            byArray = byArray2;
        }
        catch (Exception exception) {
            throw (Throwable)new EnvelopedDataException("Could not decrypt value", exception);
        }
        return byArray;
    }

    @NotNull
    public abstract RecipientIdentifier getRecipientKeyId();

    public abstract void validate() throws EnvelopedDataException;

    @NotNull
    public final CMSEnvelopedData getBcEnvelopedData() {
        return this.bcEnvelopedData;
    }

    public EnvelopedData(@NotNull CMSEnvelopedData bcEnvelopedData) {
        Intrinsics.checkParameterIsNotNull((Object)bcEnvelopedData, (String)"bcEnvelopedData");
        this.bcEnvelopedData = bcEnvelopedData;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "envelopedDataSerialized", "", "relaynet"})
    public static final class Companion {
        @NotNull
        public final EnvelopedData deserialize(@NotNull byte[] envelopedDataSerialized) throws EnvelopedDataException {
            EnvelopedData envelopedData;
            CMSEnvelopedData cMSEnvelopedData;
            Intrinsics.checkParameterIsNotNull((Object)envelopedDataSerialized, (String)"envelopedDataSerialized");
            try {
                cMSEnvelopedData = new CMSEnvelopedData(envelopedDataSerialized);
            }
            catch (CMSException exception) {
                throw (Throwable)new EnvelopedDataException("Value should be a DER-encoded CMS EnvelopedData", exception);
            }
            CMSEnvelopedData bcEnvelopedData = cMSEnvelopedData;
            int recipientsSize = bcEnvelopedData.getRecipientInfos().size();
            if (recipientsSize != 1) {
                throw (Throwable)new EnvelopedDataException("Exactly one RecipientInfo is required (got " + recipientsSize + ')', null, 2, null);
            }
            RecipientInformationStore recipientInformationStore = bcEnvelopedData.getRecipientInfos();
            Intrinsics.checkExpressionValueIsNotNull((Object)recipientInformationStore, (String)"bcEnvelopedData.recipientInfos");
            RecipientInformation recipient = (RecipientInformation)CollectionsKt.first((Iterable)((Iterable)recipientInformationStore));
            if (recipient instanceof KeyTransRecipientInformation) {
                envelopedData = new SessionlessEnvelopedData(bcEnvelopedData);
            } else if (recipient instanceof KeyAgreeRecipientInformation) {
                envelopedData = new SessionEnvelopedData(bcEnvelopedData);
            } else {
                throw (Throwable)new EnvelopedDataException("Unsupported RecipientInfo (got " + recipient.getClass().getSimpleName() + ')', null, 2, null);
            }
            EnvelopedData envelopedData2 = envelopedData;
            envelopedData2.validate();
            return envelopedData2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

