/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.cms;

import java.security.Provider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.SymmetricEncryption;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0000\"(\u0010\u0000\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\u00030\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n \u0004*\u0004\u0018\u00010\u00030\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"KEY_WRAP_ALGORITHMS", "", "Ltech/relaycorp/relaynet/SymmetricEncryption;", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "kotlin.jvm.PlatformType", "getKEY_WRAP_ALGORITHMS", "()Ljava/util/Map;", "cmsContentEncryptionAlgorithm", "bcEncrypt", "Lorg/bouncycastle/cms/CMSEnvelopedData;", "plaintext", "", "symmetricEncryptionAlgorithm", "recipientInfoGenerator", "Lorg/bouncycastle/cms/RecipientInfoGenerator;", "relaynet"})
public final class EnvelopedDataKt {
    private static final Map<SymmetricEncryption, ASN1ObjectIdentifier> cmsContentEncryptionAlgorithm = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)SymmetricEncryption.AES_128), (Object)CMSAlgorithm.AES128_CBC), TuplesKt.to((Object)((Object)SymmetricEncryption.AES_192), (Object)CMSAlgorithm.AES192_CBC), TuplesKt.to((Object)((Object)SymmetricEncryption.AES_256), (Object)CMSAlgorithm.AES256_CBC)});
    @NotNull
    private static final Map<SymmetricEncryption, ASN1ObjectIdentifier> KEY_WRAP_ALGORITHMS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)SymmetricEncryption.AES_128), (Object)CMSAlgorithm.AES128_WRAP), TuplesKt.to((Object)((Object)SymmetricEncryption.AES_192), (Object)CMSAlgorithm.AES192_WRAP), TuplesKt.to((Object)((Object)SymmetricEncryption.AES_256), (Object)CMSAlgorithm.AES256_WRAP)});

    @NotNull
    public static final Map<SymmetricEncryption, ASN1ObjectIdentifier> getKEY_WRAP_ALGORITHMS() {
        return KEY_WRAP_ALGORITHMS;
    }

    @NotNull
    public static final CMSEnvelopedData bcEncrypt(@NotNull byte[] plaintext2, @NotNull SymmetricEncryption symmetricEncryptionAlgorithm, @NotNull RecipientInfoGenerator recipientInfoGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)plaintext2, (String)"plaintext");
        Intrinsics.checkParameterIsNotNull((Object)((Object)symmetricEncryptionAlgorithm), (String)"symmetricEncryptionAlgorithm");
        Intrinsics.checkParameterIsNotNull((Object)recipientInfoGenerator, (String)"recipientInfoGenerator");
        CMSEnvelopedDataGenerator cmsEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
        cmsEnvelopedDataGenerator.addRecipientInfoGenerator(recipientInfoGenerator);
        CMSProcessableByteArray msg = new CMSProcessableByteArray(plaintext2);
        ASN1ObjectIdentifier contentEncryptionAlgorithm = cmsContentEncryptionAlgorithm.get((Object)symmetricEncryptionAlgorithm);
        JceCMSContentEncryptorBuilder encryptorBuilder = new JceCMSContentEncryptorBuilder(contentEncryptionAlgorithm).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
        CMSEnvelopedData cMSEnvelopedData = cmsEnvelopedDataGenerator.generate((CMSTypedData)msg, encryptorBuilder.build());
        Intrinsics.checkExpressionValueIsNotNull((Object)cMSEnvelopedData, (String)"cmsEnvelopedDataGenerato\u2026encryptorBuilder.build())");
        return cMSEnvelopedData;
    }
}

