/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.ECDHCurve;
import tech.relaycorp.relaynet.wrappers.KeyException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\u001a\u0010\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0005\u001a\u0010\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\b*\u00020\u0011\u001a\u0014\u0010\u0012\u001a\u00020\b*\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u001a\n\u0010\u0014\u001a\u00020\b*\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0007\u001a\u00020\u0006*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"DEFAULT_RSA_KEY_MODULUS", "", "MIN_RSA_KEY_MODULUS", "ecdhCurveMap", "", "Ltech/relaycorp/relaynet/ECDHCurve;", "", "privateAddress", "Ljava/security/PublicKey;", "getPrivateAddress", "(Ljava/security/PublicKey;)Ljava/lang/String;", "generateECDHKeyPair", "Ljava/security/KeyPair;", "curve", "generateRSAKeyPair", "modulus", "deserializeECPublicKey", "", "deserializePublicKey", "algorithm", "deserializeRSAPublicKey", "relaynet"})
@JvmName(name="Keys")
public final class Keys {
    private static final int DEFAULT_RSA_KEY_MODULUS = 2048;
    private static final int MIN_RSA_KEY_MODULUS = 2048;
    private static final Map<ECDHCurve, String> ecdhCurveMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)ECDHCurve.P256), (Object)"P-256"), TuplesKt.to((Object)((Object)ECDHCurve.P384), (Object)"P-384"), TuplesKt.to((Object)((Object)ECDHCurve.P521), (Object)"P-521")});

    @NotNull
    public static final KeyPair generateRSAKeyPair(int modulus) throws KeyException {
        if (modulus < 2048) {
            throw (Throwable)new KeyException("Modulus should be at least 2048 (got " + modulus + ')', null, 2, null);
        }
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", (Provider)CryptoUtils.getBC_PROVIDER());
        keyGen.initialize(modulus);
        KeyPair keyPair = keyGen.generateKeyPair();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyPair, (String)"keyGen.generateKeyPair()");
        return keyPair;
    }

    public static /* synthetic */ KeyPair generateRSAKeyPair$default(int n, int n2, Object object) throws KeyException {
        if ((n2 & 1) != 0) {
            n = 2048;
        }
        return Keys.generateRSAKeyPair(n);
    }

    @NotNull
    public static final PublicKey deserializeRSAPublicKey(@NotNull byte[] $this$deserializeRSAPublicKey) {
        Intrinsics.checkParameterIsNotNull((Object)$this$deserializeRSAPublicKey, (String)"$this$deserializeRSAPublicKey");
        return Keys.deserializePublicKey($this$deserializeRSAPublicKey, "RSA");
    }

    @NotNull
    public static final PublicKey deserializeECPublicKey(@NotNull byte[] $this$deserializeECPublicKey) {
        Intrinsics.checkParameterIsNotNull((Object)$this$deserializeECPublicKey, (String)"$this$deserializeECPublicKey");
        return Keys.deserializePublicKey($this$deserializeECPublicKey, "EC");
    }

    private static final PublicKey deserializePublicKey(@NotNull byte[] $this$deserializePublicKey, String algorithm) {
        PublicKey publicKey;
        X509EncodedKeySpec spec = new X509EncodedKeySpec($this$deserializePublicKey);
        KeyFactory factory = KeyFactory.getInstance(algorithm, (Provider)CryptoUtils.getBC_PROVIDER());
        try {
            PublicKey publicKey2 = factory.generatePublic(spec);
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey2, (String)"factory.generatePublic(spec)");
            publicKey = publicKey2;
        }
        catch (InvalidKeySpecException exc) {
            throw (Throwable)new KeyException("Value is not a valid " + algorithm + " public key", exc);
        }
        return publicKey;
    }

    @NotNull
    public static final KeyPair generateECDHKeyPair(@NotNull ECDHCurve curve) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)curve), (String)"curve");
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", (Provider)CryptoUtils.getBC_PROVIDER());
        ECGenParameterSpec ecSpec = new ECGenParameterSpec(ecdhCurveMap.get((Object)curve));
        keyGen.initialize(ecSpec);
        KeyPair keyPair = keyGen.generateKeyPair();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyPair, (String)"keyGen.generateKeyPair()");
        return keyPair;
    }

    public static /* synthetic */ KeyPair generateECDHKeyPair$default(ECDHCurve eCDHCurve, int n, Object object) {
        if ((n & 1) != 0) {
            eCDHCurve = ECDHCurve.P256;
        }
        return Keys.generateECDHKeyPair(eCDHCurve);
    }

    @NotNull
    public static final String getPrivateAddress(@NotNull PublicKey $this$privateAddress) {
        Intrinsics.checkParameterIsNotNull((Object)$this$privateAddress, (String)"$this$privateAddress");
        StringBuilder stringBuilder = new StringBuilder().append('0');
        byte[] byArray = $this$privateAddress.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"this.encoded");
        return stringBuilder.append(CryptoUtils.getSHA256DigestHex(byArray)).toString();
    }
}

