/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.bindings.pdc;

import java.security.PrivateKey;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.bindings.pdc.InvalidSignatureException;
import tech.relaycorp.relaynet.crypto.SignedData;
import tech.relaycorp.relaynet.crypto.SignedDataException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0016"}, d2={"Ltech/relaycorp/relaynet/bindings/pdc/DetachedSignatureType;", "", "oid", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "(Ljava/lang/String;ILorg/bouncycastle/asn1/ASN1ObjectIdentifier;)V", "getOid$relaynet", "()Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "makePlaintextSafe", "", "plaintext", "sign", "privateKey", "Ljava/security/PrivateKey;", "signerCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "verify", "signatureSerialized", "expectedPlaintext", "trustedCertificates", "", "PARCEL_DELIVERY", "NONCE", "relaynet"})
public final class DetachedSignatureType
extends Enum<DetachedSignatureType> {
    public static final /* enum */ DetachedSignatureType PARCEL_DELIVERY;
    public static final /* enum */ DetachedSignatureType NONCE;
    private static final /* synthetic */ DetachedSignatureType[] $VALUES;
    @NotNull
    private final ASN1ObjectIdentifier oid;

    static {
        DetachedSignatureType[] detachedSignatureTypeArray = new DetachedSignatureType[2];
        DetachedSignatureType[] detachedSignatureTypeArray2 = detachedSignatureTypeArray;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = OIDs.INSTANCE.getDETACHED_SIGNATURE().branch("0").intern();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1ObjectIdentifier, (String)"OIDs.DETACHED_SIGNATURE.branch(\"0\").intern()");
        detachedSignatureTypeArray[0] = PARCEL_DELIVERY = new DetachedSignatureType(aSN1ObjectIdentifier);
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = OIDs.INSTANCE.getDETACHED_SIGNATURE().branch("1").intern();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1ObjectIdentifier2, (String)"OIDs.DETACHED_SIGNATURE.branch(\"1\").intern()");
        detachedSignatureTypeArray[1] = NONCE = new DetachedSignatureType(aSN1ObjectIdentifier2);
        $VALUES = detachedSignatureTypeArray;
    }

    @NotNull
    public final byte[] sign(@NotNull byte[] plaintext2, @NotNull PrivateKey privateKey, @NotNull Certificate signerCertificate2) {
        Intrinsics.checkParameterIsNotNull((Object)plaintext2, (String)"plaintext");
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
        Intrinsics.checkParameterIsNotNull((Object)signerCertificate2, (String)"signerCertificate");
        byte[] safePlaintext = this.makePlaintextSafe(plaintext2);
        SignedData signedData = SignedData.Companion.sign$default(SignedData.Companion, safePlaintext, privateKey, signerCertificate2, SetsKt.setOf((Object)signerCertificate2), null, false, 16, null);
        return signedData.serialize();
    }

    @NotNull
    public final Certificate verify(@NotNull byte[] signatureSerialized, @NotNull byte[] expectedPlaintext, @NotNull List<Certificate> trustedCertificates) throws InvalidSignatureException {
        SignedData signedData;
        Intrinsics.checkParameterIsNotNull((Object)signatureSerialized, (String)"signatureSerialized");
        Intrinsics.checkParameterIsNotNull((Object)expectedPlaintext, (String)"expectedPlaintext");
        Intrinsics.checkParameterIsNotNull(trustedCertificates, (String)"trustedCertificates");
        byte[] safePlaintext = this.makePlaintextSafe(expectedPlaintext);
        try {
            signedData = SignedData.Companion.deserialize(signatureSerialized);
            boolean bl = false;
            boolean bl2 = false;
            SignedData it = signedData;
            boolean bl3 = false;
            it.verify(safePlaintext);
        }
        catch (SignedDataException exc) {
            throw (Throwable)new InvalidSignatureException("SignedData value is invalid", exc);
        }
        SignedData signedData2 = signedData;
        Certificate certificate = signedData2.getSignerCertificate();
        if (certificate == null) {
            Intrinsics.throwNpe();
        }
        Certificate signerCertificate2 = certificate;
        try {
            signerCertificate2.getCertificationPath(CollectionsKt.emptyList(), (Collection<Certificate>)trustedCertificates);
        }
        catch (CertificateException exc) {
            throw (Throwable)new InvalidSignatureException("Signer is not trusted", exc);
        }
        return signerCertificate2;
    }

    private final byte[] makePlaintextSafe(byte[] plaintext2) {
        return ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)this.oid, (ASN1Encodable)new DEROctetString(plaintext2)}, false);
    }

    @NotNull
    public final ASN1ObjectIdentifier getOid$relaynet() {
        return this.oid;
    }

    private DetachedSignatureType(ASN1ObjectIdentifier oid) {
        this.oid = oid;
    }

    public static DetachedSignatureType[] values() {
        return (DetachedSignatureType[])$VALUES.clone();
    }

    public static DetachedSignatureType valueOf(String string) {
        return Enum.valueOf(DetachedSignatureType.class, string);
    }
}

