/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.crypto.RSASigning;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Ltech/relaycorp/relaynet/messages/control/ClientRegistrationAuthorization;", "", "expiryDate", "Ljava/time/ZonedDateTime;", "serverData", "", "(Ljava/time/ZonedDateTime;[B)V", "getExpiryDate", "()Ljava/time/ZonedDateTime;", "getServerData", "()[B", "serialize", "serverPrivateKey", "Ljava/security/PrivateKey;", "Companion", "relaynet"})
public final class ClientRegistrationAuthorization {
    @NotNull
    private final ZonedDateTime expiryDate;
    @NotNull
    private final byte[] serverData;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize(@NotNull PrivateKey serverPrivateKey) {
        Intrinsics.checkParameterIsNotNull((Object)serverPrivateKey, (String)"serverPrivateKey");
        DERGeneralizedTime expiryDateASN1 = ASN1Utils.INSTANCE.derEncodeUTCDate(this.expiryDate);
        DEROctetString serverDataASN1 = new DEROctetString(this.serverData);
        byte[] signaturePlaintext = ClientRegistrationAuthorization.Companion.makeSignaturePlaintext((ASN1GeneralizedTime)expiryDateASN1, (ASN1OctetString)serverDataASN1);
        byte[] signature = RSASigning.INSTANCE.sign(signaturePlaintext, serverPrivateKey);
        return ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)expiryDateASN1, (ASN1Encodable)serverDataASN1, (ASN1Encodable)new DEROctetString(signature)}, false);
    }

    @NotNull
    public final ZonedDateTime getExpiryDate() {
        return this.expiryDate;
    }

    @NotNull
    public final byte[] getServerData() {
        return this.serverData;
    }

    public ClientRegistrationAuthorization(@NotNull ZonedDateTime expiryDate, @NotNull byte[] serverData) {
        Intrinsics.checkParameterIsNotNull((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkParameterIsNotNull((Object)serverData, (String)"serverData");
        this.expiryDate = expiryDate;
        this.serverData = serverData;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/messages/control/ClientRegistrationAuthorization$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/ClientRegistrationAuthorization;", "serialization", "", "serverPublicKey", "Ljava/security/PublicKey;", "makeSignaturePlaintext", "expiryDateASN1", "Lorg/bouncycastle/asn1/ASN1GeneralizedTime;", "serverDataASN1", "Lorg/bouncycastle/asn1/ASN1OctetString;", "relaynet"})
    public static final class Companion {
        @NotNull
        public final ClientRegistrationAuthorization deserialize(@NotNull byte[] serialization, @NotNull PublicKey serverPublicKey) throws InvalidMessageException {
            ASN1GeneralizedTime expiryDateASN1;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
            Intrinsics.checkParameterIsNotNull((Object)serverPublicKey, (String)"serverPublicKey");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw (Throwable)new InvalidMessageException("CRA is not a valid DER sequence", exc);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 3) {
                throw (Throwable)new InvalidMessageException("CRA plaintext should have at least 3 items (got " + sequence.length + ')', null, 2, null);
            }
            ASN1GeneralizedTime aSN1GeneralizedTime = expiryDateASN1 = DERGeneralizedTime.getInstance((ASN1TaggedObject)sequence[0], (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1GeneralizedTime, (String)"expiryDateASN1");
            ZonedDateTime expiryDate = ZonedDateTime.ofInstant(aSN1GeneralizedTime.getDate().toInstant(), ZoneId.systemDefault());
            if (expiryDate.compareTo(ZonedDateTime.now()) < 0) {
                throw (Throwable)new InvalidMessageException("CRA already expired", null, 2, null);
            }
            ASN1OctetString serverDataASN1 = ASN1Utils.INSTANCE.getOctetString(sequence[1]);
            byte[] signature = ASN1Utils.INSTANCE.getOctetString(sequence[2]).getOctets();
            byte[] expectedPlaintext = this.makeSignaturePlaintext(expiryDateASN1, serverDataASN1);
            Intrinsics.checkExpressionValueIsNotNull((Object)signature, (String)"signature");
            if (!RSASigning.INSTANCE.verify(signature, serverPublicKey, expectedPlaintext)) {
                throw (Throwable)new InvalidMessageException("CRA signature is invalid", null, 2, null);
            }
            ZonedDateTime zonedDateTime = expiryDate;
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"expiryDate");
            byte[] byArray = serverDataASN1.getOctets();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"serverDataASN1.octets");
            return new ClientRegistrationAuthorization(zonedDateTime, byArray);
        }

        private final byte[] makeSignaturePlaintext(ASN1GeneralizedTime expiryDateASN1, ASN1OctetString serverDataASN1) {
            return ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)OIDs.INSTANCE.getCRA(), (ASN1Encodable)expiryDateASN1, (ASN1Encodable)serverDataASN1}, false);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

