/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import java.security.PrivateKey;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.crypto.SignedData;
import tech.relaycorp.relaynet.crypto.SignedDataException;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Ltech/relaycorp/relaynet/messages/control/NonceSignature;", "", "nonce", "", "signerCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "([BLtech/relaycorp/relaynet/wrappers/x509/Certificate;)V", "getNonce", "()[B", "getSignerCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "serialize", "privateKey", "Ljava/security/PrivateKey;", "Companion", "relaynet"})
public final class NonceSignature {
    @NotNull
    private final byte[] nonce;
    @NotNull
    private final Certificate signerCertificate;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize(@NotNull PrivateKey privateKey) {
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
        byte[] plaintext2 = ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)OIDs.INSTANCE.getNONCE_SIGNATURE(), (ASN1Encodable)new DEROctetString(this.nonce)}, false);
        SignedData signedData = SignedData.Companion.sign$default(SignedData.Companion, plaintext2, privateKey, this.signerCertificate, SetsKt.setOf((Object)this.signerCertificate), null, false, 48, null);
        return signedData.serialize();
    }

    @NotNull
    public final byte[] getNonce() {
        return this.nonce;
    }

    @NotNull
    public final Certificate getSignerCertificate() {
        return this.signerCertificate;
    }

    public NonceSignature(@NotNull byte[] nonce, @NotNull Certificate signerCertificate2) {
        Intrinsics.checkParameterIsNotNull((Object)nonce, (String)"nonce");
        Intrinsics.checkParameterIsNotNull((Object)signerCertificate2, (String)"signerCertificate");
        this.nonce = nonce;
        this.signerCertificate = signerCertificate2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/messages/control/NonceSignature$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/NonceSignature;", "serialization", "", "relaynet"})
    public static final class Companion {
        @NotNull
        public final NonceSignature deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            Object[] exc2;
            SignedData signedData;
            Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
            try {
                signedData = SignedData.Companion.deserialize(serialization);
                boolean bl = false;
                boolean bl2 = false;
                SignedData it = signedData;
                boolean bl3 = false;
                SignedData.verify$default(it, null, null, 3, null);
            }
            catch (SignedDataException exc2) {
                throw (Throwable)new InvalidMessageException("SignedData value is invalid", exc2);
            }
            SignedData signedData2 = signedData;
            try {
                byte[] byArray = signedData2.getPlaintext();
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                exc2 = ASN1Utils.INSTANCE.deserializeSequence(byArray);
            }
            catch (ASN1Exception exc3) {
                throw (Throwable)new InvalidMessageException("Signature plaintext is not a DER sequence", exc3);
            }
            Object[] sequence = exc2;
            if (sequence.length < 2) {
                throw (Throwable)new InvalidMessageException("Signature sequence should have at least 2 items (got " + sequence.length + ')', null, 2, null);
            }
            ASN1ObjectIdentifier oid = ASN1Utils.INSTANCE.getOID((ASN1TaggedObject)ArraysKt.first((Object[])sequence));
            if (Intrinsics.areEqual((Object)oid, (Object)OIDs.INSTANCE.getNONCE_SIGNATURE()) ^ true) {
                throw (Throwable)new InvalidMessageException("Signature OID is invalid (got " + oid.getId() + ')', null, 2, null);
            }
            ASN1OctetString nonce = ASN1Utils.INSTANCE.getOctetString((ASN1TaggedObject)sequence[1]);
            byte[] byArray = nonce.getOctets();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"nonce.octets");
            Certificate certificate = signedData2.getSignerCertificate();
            if (certificate == null) {
                Intrinsics.throwNpe();
            }
            return new NonceSignature(byArray, certificate);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

