/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Ltech/relaycorp/relaynet/messages/control/ParcelDelivery;", "", "deliveryId", "", "parcelSerialized", "", "(Ljava/lang/String;[B)V", "getDeliveryId", "()Ljava/lang/String;", "getParcelSerialized", "()[B", "serialize", "Companion", "relaynet"})
public final class ParcelDelivery {
    @NotNull
    private final String deliveryId;
    @NotNull
    private final byte[] parcelSerialized;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize() {
        return ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)new DERVisibleString(this.deliveryId), (ASN1Encodable)new DEROctetString(this.parcelSerialized)}, false);
    }

    @NotNull
    public final String getDeliveryId() {
        return this.deliveryId;
    }

    @NotNull
    public final byte[] getParcelSerialized() {
        return this.parcelSerialized;
    }

    public ParcelDelivery(@NotNull String deliveryId, @NotNull byte[] parcelSerialized) {
        Intrinsics.checkParameterIsNotNull((Object)deliveryId, (String)"deliveryId");
        Intrinsics.checkParameterIsNotNull((Object)parcelSerialized, (String)"parcelSerialized");
        this.deliveryId = deliveryId;
        this.parcelSerialized = parcelSerialized;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/relaynet/messages/control/ParcelDelivery$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/ParcelDelivery;", "serialization", "", "relaynet"})
    public static final class Companion {
        @NotNull
        public final ParcelDelivery deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw (Throwable)new InvalidMessageException("Delivery is not a DER sequence", exc);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 2) {
                throw (Throwable)new InvalidMessageException("Delivery sequence should have at least 2 items (got " + sequence.length + ')', null, 2, null);
            }
            DERVisibleString deliveryIdASN1 = ASN1Utils.INSTANCE.getVisibleString(sequence[0]);
            ASN1OctetString parcelSerializedASN1 = ASN1Utils.INSTANCE.getOctetString(sequence[1]);
            String string = deliveryIdASN1.getString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"deliveryIdASN1.string");
            byte[] byArray = parcelSerializedASN1.getOctets();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"parcelSerializedASN1.octets");
            return new ParcelDelivery(string, byArray);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

