/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import java.security.PrivateKey;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.crypto.SignedData;
import tech.relaycorp.relaynet.crypto.SignedDataException;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.KeyException;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Ltech/relaycorp/relaynet/messages/control/ClientRegistrationRequest;", "", "clientPublicKey", "Ljava/security/PublicKey;", "craSerialized", "", "(Ljava/security/PublicKey;[B)V", "getClientPublicKey", "()Ljava/security/PublicKey;", "getCraSerialized", "()[B", "serialize", "clientPrivateKey", "Ljava/security/PrivateKey;", "Companion", "relaynet"})
public final class ClientRegistrationRequest {
    @NotNull
    private final PublicKey clientPublicKey;
    @NotNull
    private final byte[] craSerialized;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize(@NotNull PrivateKey clientPrivateKey) {
        Intrinsics.checkParameterIsNotNull((Object)clientPrivateKey, (String)"clientPrivateKey");
        byte[] craCountersignaturePlaintext = ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)OIDs.INSTANCE.getCRA_COUNTERSIGNATURE(), (ASN1Encodable)new DEROctetString(this.craSerialized)}, false);
        SignedData craCountersignature = SignedData.Companion.sign$default(SignedData.Companion, craCountersignaturePlaintext, clientPrivateKey, null, false, 12, null);
        return ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)new DEROctetString(this.clientPublicKey.getEncoded()), (ASN1Encodable)new DEROctetString(craCountersignature.serialize())}, false);
    }

    @NotNull
    public final PublicKey getClientPublicKey() {
        return this.clientPublicKey;
    }

    @NotNull
    public final byte[] getCraSerialized() {
        return this.craSerialized;
    }

    public ClientRegistrationRequest(@NotNull PublicKey clientPublicKey, @NotNull byte[] craSerialized) {
        Intrinsics.checkParameterIsNotNull((Object)clientPublicKey, (String)"clientPublicKey");
        Intrinsics.checkParameterIsNotNull((Object)craSerialized, (String)"craSerialized");
        this.clientPublicKey = clientPublicKey;
        this.craSerialized = craSerialized;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Ltech/relaycorp/relaynet/messages/control/ClientRegistrationRequest$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/ClientRegistrationRequest;", "serialization", "", "extractCRAFromCountersignature", "craCountersignatureASN1", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "clientPublicKey", "Ljava/security/PublicKey;", "relaynet"})
    public static final class Companion {
        @NotNull
        public final ClientRegistrationRequest deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            PublicKey publicKey;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw (Throwable)new InvalidMessageException("CRR is not a DER sequence", exc);
            }
            ASN1TaggedObject[] crrSequence = aSN1TaggedObjectArray;
            if (crrSequence.length < 2) {
                throw (Throwable)new InvalidMessageException("CRR sequence should have at least 2 items (got " + crrSequence.length + ')', null, 2, null);
            }
            ASN1OctetString clientPublicKeyASN1 = ASN1Utils.INSTANCE.getOctetString(crrSequence[0]);
            try {
                byte[] byArray = clientPublicKeyASN1.getOctets();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"clientPublicKeyASN1.octets");
                publicKey = Keys.deserializeRSAPublicKey(byArray);
            }
            catch (KeyException exc) {
                throw (Throwable)new InvalidMessageException("Client public key is invalid", exc);
            }
            PublicKey clientPublicKey = publicKey;
            byte[] craSerialized = this.extractCRAFromCountersignature(crrSequence[1], clientPublicKey);
            return new ClientRegistrationRequest(clientPublicKey, craSerialized);
        }

        private final byte[] extractCRAFromCountersignature(ASN1TaggedObject craCountersignatureASN1, PublicKey clientPublicKey) throws InvalidMessageException {
            ASN1TaggedObject[] exc2;
            SignedData signedData;
            byte[] craCountersignatureSerialized = ASN1Utils.INSTANCE.getOctetString(craCountersignatureASN1).getOctets();
            try {
                Intrinsics.checkExpressionValueIsNotNull((Object)craCountersignatureSerialized, (String)"craCountersignatureSerialized");
                signedData = SignedData.Companion.deserialize(craCountersignatureSerialized);
                boolean bl = false;
                boolean bl2 = false;
                SignedData it = signedData;
                boolean bl3 = false;
                SignedData.verify$default(it, null, clientPublicKey, 1, null);
            }
            catch (SignedDataException exc2) {
                throw (Throwable)new InvalidMessageException("CRA countersignature is not a valid SignedData value", exc2);
            }
            SignedData craCountersignature = signedData;
            try {
                byte[] byArray = craCountersignature.getPlaintext();
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                exc2 = ASN1Utils.INSTANCE.deserializeSequence(byArray);
            }
            catch (ASN1Exception exc3) {
                throw (Throwable)new InvalidMessageException("CRA countersignature plaintext should be a DER sequence", exc3);
            }
            ASN1TaggedObject[] craCountersignatureSequence = exc2;
            if (craCountersignatureSequence.length < 2) {
                throw (Throwable)new InvalidMessageException("CRA countersignature sequence should have at least 2 items (got " + craCountersignatureSequence.length + ')', null, 2, null);
            }
            ASN1ObjectIdentifier craCountersignatureOID = ASN1Utils.INSTANCE.getOID(craCountersignatureSequence[0]);
            if (Intrinsics.areEqual((Object)craCountersignatureOID, (Object)OIDs.INSTANCE.getCRA_COUNTERSIGNATURE()) ^ true) {
                throw (Throwable)new InvalidMessageException("CRA countersignature has invalid OID (got " + craCountersignatureOID.getId() + ')', null, 2, null);
            }
            byte[] byArray = ASN1Utils.INSTANCE.getOctetString(craCountersignatureSequence[1]).getOctets();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ASN1Utils.getOctetString\u2026natureSequence[1]).octets");
            return byArray;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

