/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.crypto.SignedData;
import tech.relaycorp.relaynet.crypto.SignedDataException;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Ltech/relaycorp/relaynet/messages/control/ClientRegistrationAuthorization;", "", "expiryDate", "Ljava/time/ZonedDateTime;", "serverData", "", "(Ljava/time/ZonedDateTime;[B)V", "getExpiryDate", "()Ljava/time/ZonedDateTime;", "getServerData", "()[B", "serialize", "serverPrivateKey", "Ljava/security/PrivateKey;", "Companion", "relaynet"})
public final class ClientRegistrationAuthorization {
    @NotNull
    private final ZonedDateTime expiryDate;
    @NotNull
    private final byte[] serverData;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize(@NotNull PrivateKey serverPrivateKey) {
        Intrinsics.checkParameterIsNotNull((Object)serverPrivateKey, (String)"serverPrivateKey");
        byte[] plaintext2 = ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)OIDs.INSTANCE.getCRA(), (ASN1Encodable)ASN1Utils.INSTANCE.derEncodeUTCDate(this.expiryDate), (ASN1Encodable)new DEROctetString(this.serverData)}, false);
        SignedData signedData = SignedData.Companion.sign$default(SignedData.Companion, plaintext2, serverPrivateKey, null, false, 12, null);
        return signedData.serialize();
    }

    @NotNull
    public final ZonedDateTime getExpiryDate() {
        return this.expiryDate;
    }

    @NotNull
    public final byte[] getServerData() {
        return this.serverData;
    }

    public ClientRegistrationAuthorization(@NotNull ZonedDateTime expiryDate, @NotNull byte[] serverData) {
        Intrinsics.checkParameterIsNotNull((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkParameterIsNotNull((Object)serverData, (String)"serverData");
        this.expiryDate = expiryDate;
        this.serverData = serverData;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ltech/relaycorp/relaynet/messages/control/ClientRegistrationAuthorization$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/ClientRegistrationAuthorization;", "serialization", "", "serverPublicKey", "Ljava/security/PublicKey;", "relaynet"})
    public static final class Companion {
        @NotNull
        public final ClientRegistrationAuthorization deserialize(@NotNull byte[] serialization, @NotNull PublicKey serverPublicKey) throws InvalidMessageException {
            ASN1GeneralizedTime expiryDateDer;
            Object[] exc2;
            SignedData signedData;
            Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
            Intrinsics.checkParameterIsNotNull((Object)serverPublicKey, (String)"serverPublicKey");
            try {
                signedData = SignedData.Companion.deserialize(serialization);
                boolean bl = false;
                boolean bl2 = false;
                SignedData it = signedData;
                boolean bl3 = false;
                SignedData.verify$default(it, null, serverPublicKey, 1, null);
            }
            catch (SignedDataException exc2) {
                throw (Throwable)new InvalidMessageException("Serialization is not a valid SignedData value", exc2);
            }
            SignedData signedData2 = signedData;
            try {
                byte[] byArray = signedData2.getPlaintext();
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                exc2 = ASN1Utils.INSTANCE.deserializeSequence(byArray);
            }
            catch (ASN1Exception exc3) {
                throw (Throwable)new InvalidMessageException("CRA plaintext should be a DER sequence", null, 2, null);
            }
            Object[] sequence = exc2;
            if (sequence.length < 3) {
                throw (Throwable)new InvalidMessageException("CRA plaintext should have at least 3 items (got " + sequence.length + ')', null, 2, null);
            }
            Object object = ArraysKt.first((Object[])sequence);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
            }
            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance((ASN1TaggedObject)((ASN1TaggedObject)object), (boolean)false);
            if (Intrinsics.areEqual((Object)oid, (Object)OIDs.INSTANCE.getCRA()) ^ true) {
                StringBuilder stringBuilder = new StringBuilder().append("CRA plaintext has invalid OID (got ");
                ASN1ObjectIdentifier aSN1ObjectIdentifier = oid;
                Intrinsics.checkExpressionValueIsNotNull((Object)aSN1ObjectIdentifier, (String)"oid");
                throw (Throwable)new InvalidMessageException(stringBuilder.append(aSN1ObjectIdentifier.getId()).append(')').toString(), null, 2, null);
            }
            Object object2 = sequence[1];
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
            }
            ASN1GeneralizedTime aSN1GeneralizedTime = expiryDateDer = DERGeneralizedTime.getInstance((ASN1TaggedObject)((ASN1TaggedObject)object2), (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1GeneralizedTime, (String)"expiryDateDer");
            ZonedDateTime expiryDate = ZonedDateTime.ofInstant(aSN1GeneralizedTime.getDate().toInstant(), ZoneId.systemDefault());
            if (expiryDate.compareTo(ZonedDateTime.now()) < 0) {
                throw (Throwable)new InvalidMessageException("CRA already expired", null, 2, null);
            }
            Object object3 = sequence[2];
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
            }
            ASN1OctetString serverDataDER = DEROctetString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)object3), (boolean)false);
            ZonedDateTime zonedDateTime = expiryDate;
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"expiryDate");
            ASN1OctetString aSN1OctetString = serverDataDER;
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1OctetString, (String)"serverDataDER");
            byte[] byArray = aSN1OctetString.getOctets();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"serverDataDER.octets");
            return new ClientRegistrationAuthorization(zonedDateTime, byArray);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

