/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.messages.control;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.messages.InvalidMessageException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\f"}, d2={"Ltech/relaycorp/relaynet/messages/control/ClientRegistration;", "", "clientCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "serverCertificate", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;Ltech/relaycorp/relaynet/wrappers/x509/Certificate;)V", "getClientCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getServerCertificate", "serialize", "", "Companion", "relaynet"})
public final class ClientRegistration {
    @NotNull
    private final Certificate clientCertificate;
    @NotNull
    private final Certificate serverCertificate;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final byte[] serialize() {
        DEROctetString clientCertificateASN1 = new DEROctetString(this.clientCertificate.serialize());
        DEROctetString serverCertificateASN1 = new DEROctetString(this.serverCertificate.serialize());
        return ASN1Utils.INSTANCE.serializeSequence(new ASN1Encodable[]{(ASN1Encodable)clientCertificateASN1, (ASN1Encodable)serverCertificateASN1}, false);
    }

    @NotNull
    public final Certificate getClientCertificate() {
        return this.clientCertificate;
    }

    @NotNull
    public final Certificate getServerCertificate() {
        return this.serverCertificate;
    }

    public ClientRegistration(@NotNull Certificate clientCertificate, @NotNull Certificate serverCertificate) {
        Intrinsics.checkParameterIsNotNull((Object)clientCertificate, (String)"clientCertificate");
        Intrinsics.checkParameterIsNotNull((Object)serverCertificate, (String)"serverCertificate");
        this.clientCertificate = clientCertificate;
        this.serverCertificate = serverCertificate;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Ltech/relaycorp/relaynet/messages/control/ClientRegistration$Companion;", "", "()V", "deserialize", "Ltech/relaycorp/relaynet/messages/control/ClientRegistration;", "serialization", "", "deserializeCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "asn1Object", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "relaynet"})
    public static final class Companion {
        @NotNull
        public final ClientRegistration deserialize(@NotNull byte[] serialization) throws InvalidMessageException {
            Certificate certificate;
            Certificate exc2;
            ASN1Encodable[] aSN1EncodableArray;
            Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
            try {
                aSN1EncodableArray = ASN1Utils.INSTANCE.deserializeSequence(serialization);
            }
            catch (ASN1Exception exc2) {
                throw (Throwable)new InvalidMessageException("Client registration is not a DER sequence", exc2);
            }
            ASN1Encodable[] sequence = aSN1EncodableArray;
            if (sequence.length < 2) {
                throw (Throwable)new InvalidMessageException("Client registration sequence should have at least two items (got " + sequence.length + ')', null, 2, null);
            }
            try {
                ASN1Encodable aSN1Encodable = sequence[0];
                if (aSN1Encodable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
                }
                exc2 = this.deserializeCertificate((ASN1TaggedObject)aSN1Encodable);
            }
            catch (CertificateException exc3) {
                throw (Throwable)new InvalidMessageException("Client registration contains invalid client certificate", exc3);
            }
            Certificate clientCertificate = exc2;
            try {
                ASN1Encodable aSN1Encodable = sequence[1];
                if (aSN1Encodable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
                }
                certificate = this.deserializeCertificate((ASN1TaggedObject)aSN1Encodable);
            }
            catch (CertificateException exc4) {
                throw (Throwable)new InvalidMessageException("Client registration contains invalid server certificate", exc4);
            }
            Certificate serverCertificate = certificate;
            return new ClientRegistration(clientCertificate, serverCertificate);
        }

        private final Certificate deserializeCertificate(ASN1TaggedObject asn1Object) throws CertificateException {
            ASN1OctetString certificateASN1;
            ASN1OctetString aSN1OctetString = certificateASN1 = DEROctetString.getInstance((ASN1TaggedObject)asn1Object, (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1OctetString, (String)"certificateASN1");
            byte[] byArray = aSN1OctetString.getOctets();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"certificateASN1.octets");
            return Certificate.Companion.deserialize(byArray);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

