/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.asn1;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J#\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Ltech/relaycorp/relaynet/wrappers/asn1/ASN1Utils;", "", "()V", "BER_DATETIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getBER_DATETIME_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "derEncodeUTCDate", "Lorg/bouncycastle/asn1/DERGeneralizedTime;", "date", "Ljava/time/ZonedDateTime;", "deserializeOID", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "oidSerialized", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "explicitTagging", "", "deserializeSequence", "", "Lorg/bouncycastle/asn1/ASN1Encodable;", "serialization", "", "([B)[Lorg/bouncycastle/asn1/ASN1Encodable;", "serializeSequence", "items", "([Lorg/bouncycastle/asn1/ASN1Encodable;Z)[B", "relaynet"})
public final class ASN1Utils {
    @NotNull
    private static final DateTimeFormatter BER_DATETIME_FORMATTER;
    public static final ASN1Utils INSTANCE;

    @NotNull
    public final DateTimeFormatter getBER_DATETIME_FORMATTER() {
        return BER_DATETIME_FORMATTER;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] serializeSequence(@NotNull ASN1Encodable[] items, boolean explicitTagging) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        ASN1EncodableVector messagesVector = new ASN1EncodableVector(items.length);
        if (explicitTagging) {
            list = ArraysKt.asList((Object[])items);
        } else {
            void $this$mapIndexedTo$iv$iv;
            ASN1Encodable[] $this$mapIndexed$iv = items;
            boolean $i$f$mapIndexed = false;
            ASN1Encodable[] aSN1EncodableArray = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void item;
                void index;
                int n = index$iv$iv++;
                void var15_15 = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DERTaggedObject dERTaggedObject = new DERTaggedObject(false, (int)index, (ASN1Encodable)item);
                collection.add(dERTaggedObject);
            }
            list = (List)destination$iv$iv;
        }
        List finalItems = list;
        Iterable $this$forEach$iv = finalItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASN1Encodable it = (ASN1Encodable)element$iv;
            boolean bl = false;
            messagesVector.add(it);
        }
        DERSequence sequence = new DERSequence(messagesVector);
        byte[] byArray = sequence.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sequence.encoded");
        return byArray;
    }

    public static /* synthetic */ byte[] serializeSequence$default(ASN1Utils aSN1Utils, ASN1Encodable[] aSN1EncodableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return aSN1Utils.serializeSequence(aSN1EncodableArray, bl);
    }

    @NotNull
    public final ASN1Encodable[] deserializeSequence(@NotNull byte[] serialization) throws ASN1Exception {
        ASN1Sequence aSN1Sequence;
        ASN1Primitive aSN1Primitive;
        Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
        byte[] byArray = serialization;
        boolean bl = false;
        if (byArray.length == 0) {
            throw (Throwable)new ASN1Exception("Value is empty", null, 2, null);
        }
        ASN1InputStream asn1InputStream = new ASN1InputStream(serialization);
        try {
            aSN1Primitive = asn1InputStream.readObject();
        }
        catch (IOException _) {
            throw (Throwable)new ASN1Exception("Value is not DER-encoded", null, 2, null);
        }
        ASN1Primitive asn1Value = aSN1Primitive;
        try {
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance((Object)asn1Value);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1Sequence2, (String)"ASN1Sequence.getInstance(asn1Value)");
            aSN1Sequence = aSN1Sequence2;
        }
        catch (IllegalArgumentException _) {
            throw (Throwable)new ASN1Exception("Value is not an ASN.1 sequence", null, 2, null);
        }
        ASN1Sequence fieldSequence = aSN1Sequence;
        ASN1Encodable[] aSN1EncodableArray = fieldSequence.toArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1EncodableArray, (String)"fieldSequence.toArray()");
        return aSN1EncodableArray;
    }

    @NotNull
    public final DERGeneralizedTime derEncodeUTCDate(@NotNull ZonedDateTime date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        ZonedDateTime dateUTC = date.withZoneSameInstant(ZoneOffset.UTC);
        return new DERGeneralizedTime(dateUTC.format(BER_DATETIME_FORMATTER));
    }

    @NotNull
    public final ASN1ObjectIdentifier deserializeOID(@NotNull ASN1TaggedObject oidSerialized, boolean explicitTagging) throws ASN1Exception {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        Intrinsics.checkParameterIsNotNull((Object)oidSerialized, (String)"oidSerialized");
        try {
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = ASN1ObjectIdentifier.getInstance((ASN1TaggedObject)oidSerialized, (boolean)explicitTagging);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1ObjectIdentifier2, (String)"ASN1ObjectIdentifier.get\u2026ialized, explicitTagging)");
            aSN1ObjectIdentifier = aSN1ObjectIdentifier2;
        }
        catch (IllegalArgumentException exc) {
            throw (Throwable)new ASN1Exception("Value is not an OID", exc);
        }
        return aSN1ObjectIdentifier;
    }

    public static /* synthetic */ ASN1ObjectIdentifier deserializeOID$default(ASN1Utils aSN1Utils, ASN1TaggedObject aSN1TaggedObject, boolean bl, int n, Object object) throws ASN1Exception {
        if ((n & 2) != 0) {
            bl = false;
        }
        return aSN1Utils.deserializeOID(aSN1TaggedObject, bl);
    }

    private ASN1Utils() {
    }

    static {
        ASN1Utils aSN1Utils;
        INSTANCE = aSN1Utils = new ASN1Utils();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPattern(\"yyyyMMddHHmmss\")");
        BER_DATETIME_FORMATTER = dateTimeFormatter;
    }
}

