/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.asn1;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J#\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Ltech/relaycorp/relaynet/wrappers/asn1/ASN1Utils;", "", "()V", "BER_DATETIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getBER_DATETIME_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "derEncodeUTCDate", "Lorg/bouncycastle/asn1/DERGeneralizedTime;", "date", "Ljava/time/ZonedDateTime;", "deserializeSequence", "", "Lorg/bouncycastle/asn1/ASN1Encodable;", "serialization", "", "([B)[Lorg/bouncycastle/asn1/ASN1Encodable;", "serializeSequence", "items", "explicitTagging", "", "([Lorg/bouncycastle/asn1/ASN1Encodable;Z)[B", "relaynet"})
public final class ASN1Utils {
    @NotNull
    private static final DateTimeFormatter BER_DATETIME_FORMATTER;
    public static final ASN1Utils INSTANCE;

    @NotNull
    public final DateTimeFormatter getBER_DATETIME_FORMATTER() {
        return BER_DATETIME_FORMATTER;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] serializeSequence(@NotNull ASN1Encodable[] items, boolean explicitTagging) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        ASN1EncodableVector messagesVector = new ASN1EncodableVector(items.length);
        if (explicitTagging) {
            list = ArraysKt.asList((Object[])items);
        } else {
            void $this$mapIndexedTo$iv$iv;
            ASN1Encodable[] $this$mapIndexed$iv = items;
            boolean $i$f$mapIndexed = false;
            ASN1Encodable[] aSN1EncodableArray = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList($this$mapIndexed$iv.length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void item;
                void index;
                int n = index$iv$iv++;
                void var15_15 = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DERTaggedObject dERTaggedObject = new DERTaggedObject(false, (int)index, (ASN1Encodable)item);
                collection.add(dERTaggedObject);
            }
            list = (List)destination$iv$iv;
        }
        List finalItems = list;
        Iterable $this$forEach$iv = finalItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASN1Encodable it = (ASN1Encodable)element$iv;
            boolean bl = false;
            messagesVector.add(it);
        }
        DERSequence sequence = new DERSequence(messagesVector);
        byte[] byArray = sequence.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"sequence.encoded");
        return byArray;
    }

    public static /* synthetic */ byte[] serializeSequence$default(ASN1Utils aSN1Utils, ASN1Encodable[] aSN1EncodableArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return aSN1Utils.serializeSequence(aSN1EncodableArray, bl);
    }

    @NotNull
    public final ASN1Encodable[] deserializeSequence(@NotNull byte[] serialization) throws ASN1Exception {
        ASN1Sequence aSN1Sequence;
        ASN1Primitive aSN1Primitive;
        Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
        byte[] byArray = serialization;
        boolean bl = false;
        if (byArray.length == 0) {
            throw (Throwable)new ASN1Exception("Value is empty");
        }
        ASN1InputStream asn1InputStream = new ASN1InputStream(serialization);
        try {
            aSN1Primitive = asn1InputStream.readObject();
        }
        catch (IOException _) {
            throw (Throwable)new ASN1Exception("Value is not DER-encoded");
        }
        ASN1Primitive asn1Value = aSN1Primitive;
        try {
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance((Object)asn1Value);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1Sequence2, (String)"ASN1Sequence.getInstance(asn1Value)");
            aSN1Sequence = aSN1Sequence2;
        }
        catch (IllegalArgumentException _) {
            throw (Throwable)new ASN1Exception("Value is not an ASN.1 sequence");
        }
        ASN1Sequence fieldSequence = aSN1Sequence;
        ASN1Encodable[] aSN1EncodableArray = fieldSequence.toArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1EncodableArray, (String)"fieldSequence.toArray()");
        return aSN1EncodableArray;
    }

    @NotNull
    public final DERGeneralizedTime derEncodeUTCDate(@NotNull ZonedDateTime date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        ZonedDateTime dateUTC = date.withZoneSameInstant(ZoneOffset.UTC);
        return new DERGeneralizedTime(dateUTC.format(BER_DATETIME_FORMATTER));
    }

    private ASN1Utils() {
    }

    static {
        ASN1Utils aSN1Utils;
        INSTANCE = aSN1Utils = new ASN1Utils();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter, (String)"DateTimeFormatter.ofPattern(\"yyyyMMddHHmmss\")");
        BER_DATETIME_FORMATTER = dateTimeFormatter;
    }
}

