/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\t"}, d2={"BC_PROVIDER", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "getBC_PROVIDER", "()Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "getSHA256Digest", "", "input", "getSHA256DigestHex", "", "relaynet"})
@JvmName(name="CryptoUtils")
public final class CryptoUtils {
    @NotNull
    private static final BouncyCastleProvider BC_PROVIDER = new BouncyCastleProvider();

    @NotNull
    public static final byte[] getSHA256Digest(@NotNull byte[] input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] byArray = digest.digest(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digest.digest(input)");
        return byArray;
    }

    @NotNull
    public static final String getSHA256DigestHex(@NotNull byte[] input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return ArraysKt.joinToString$default((byte[])CryptoUtils.getSHA256Digest(input), (CharSequence)"", null, null, (int)0, null, (Function1)getSHA256DigestHex.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final BouncyCastleProvider getBC_PROVIDER() {
        return BC_PROVIDER;
    }
}

