/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.wrappers.KeyException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0001\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"DEFAULT_RSA_KEY_MODULUS", "", "MIN_RSA_KEY_MODULUS", "generateRSAKeyPair", "Ljava/security/KeyPair;", "modulus", "deserializeRSAPublicKey", "Ljava/security/PublicKey;", "", "relaynet"})
public final class KeysKt {
    private static final int DEFAULT_RSA_KEY_MODULUS = 2048;
    private static final int MIN_RSA_KEY_MODULUS = 2048;

    @NotNull
    public static final KeyPair generateRSAKeyPair(int modulus) throws KeyException {
        if (modulus < 2048) {
            throw (Throwable)new KeyException("Modulus should be at least 2048 (got " + modulus + ')', null, 2, null);
        }
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(modulus);
        KeyPair keyPair = keyGen.generateKeyPair();
        Intrinsics.checkExpressionValueIsNotNull((Object)keyPair, (String)"keyGen.generateKeyPair()");
        return keyPair;
    }

    public static /* synthetic */ KeyPair generateRSAKeyPair$default(int n, int n2, Object object) throws KeyException {
        if ((n2 & 1) != 0) {
            n = 2048;
        }
        return KeysKt.generateRSAKeyPair(n);
    }

    @NotNull
    public static final PublicKey deserializeRSAPublicKey(@NotNull byte[] $this$deserializeRSAPublicKey) {
        PublicKey publicKey;
        Intrinsics.checkParameterIsNotNull((Object)$this$deserializeRSAPublicKey, (String)"$this$deserializeRSAPublicKey");
        X509EncodedKeySpec spec = new X509EncodedKeySpec($this$deserializeRSAPublicKey);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        try {
            PublicKey publicKey2 = factory.generatePublic(spec);
            Intrinsics.checkExpressionValueIsNotNull((Object)publicKey2, (String)"factory.generatePublic(spec)");
            publicKey = publicKey2;
        }
        catch (InvalidKeySpecException exc) {
            throw (Throwable)new KeyException("Value is not a valid RSA public key", exc);
        }
        return publicKey;
    }
}

