/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.crypto;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.HashingAlgorithm;
import tech.relaycorp.relaynet.crypto.SignedDataException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001c\u001a\u00020\u000fJ\u0006\u0010\u001d\u001a\u00020\u001eR!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000b\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Ltech/relaycorp/relaynet/crypto/SignedData;", "", "bcSignedData", "Lorg/bouncycastle/cms/CMSSignedData;", "(Lorg/bouncycastle/cms/CMSSignedData;)V", "attachedCertificates", "", "Lorg/bouncycastle/cert/X509CertificateHolder;", "getAttachedCertificates", "()Ljava/util/Set;", "attachedCertificates$delegate", "Lkotlin/Lazy;", "getBcSignedData$relaynet", "()Lorg/bouncycastle/cms/CMSSignedData;", "plaintext", "", "getPlaintext", "()[B", "plaintext$delegate", "signerCertificate", "getSignerCertificate", "()Lorg/bouncycastle/cert/X509CertificateHolder;", "signerCertificate$delegate", "signerInfo", "Lorg/bouncycastle/cms/SignerInformation;", "getSignerInfo", "()Lorg/bouncycastle/cms/SignerInformation;", "signerInfo$delegate", "serialize", "verify", "", "Companion", "relaynet"})
public final class SignedData {
    @Nullable
    private final Lazy plaintext$delegate;
    @NotNull
    private final Lazy signerCertificate$delegate;
    @NotNull
    private final Lazy attachedCertificates$delegate;
    private final Lazy signerInfo$delegate;
    @NotNull
    private final CMSSignedData bcSignedData;
    private static final Map<HashingAlgorithm, String> signatureAlgorithmMap;
    public static final Companion Companion;

    @Nullable
    public final byte[] getPlaintext() {
        Lazy lazy = this.plaintext$delegate;
        SignedData signedData = this;
        Object var3_3 = null;
        boolean bl = false;
        return (byte[])lazy.getValue();
    }

    @NotNull
    public final X509CertificateHolder getSignerCertificate() {
        Lazy lazy = this.signerCertificate$delegate;
        SignedData signedData = this;
        Object var3_3 = null;
        boolean bl = false;
        return (X509CertificateHolder)lazy.getValue();
    }

    @NotNull
    public final Set<X509CertificateHolder> getAttachedCertificates() {
        Lazy lazy = this.attachedCertificates$delegate;
        SignedData signedData = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final byte[] serialize() {
        byte[] byArray = this.bcSignedData.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"bcSignedData.encoded");
        return byArray;
    }

    public final void verify() {
        if (this.getPlaintext() == null) {
            throw (Throwable)new SignedDataException("Signed plaintext should be encapsulated");
        }
        SignerInformationVerifier verifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider((Provider)CryptoUtils.getBC_PROVIDER()).build(this.getSignerCertificate());
        try {
            this.getSignerInfo().verify(verifier);
        }
        catch (CMSException _) {
            throw (Throwable)new SignedDataException("Invalid signature");
        }
    }

    private final SignerInformation getSignerInfo() {
        Lazy lazy = this.signerInfo$delegate;
        SignedData signedData = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SignerInformation)lazy.getValue();
    }

    @NotNull
    public final CMSSignedData getBcSignedData$relaynet() {
        return this.bcSignedData;
    }

    public SignedData(@NotNull CMSSignedData bcSignedData) {
        Intrinsics.checkParameterIsNotNull((Object)bcSignedData, (String)"bcSignedData");
        this.bcSignedData = bcSignedData;
        this.plaintext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this){
            final /* synthetic */ SignedData this$0;

            @Nullable
            public final byte[] invoke() {
                CMSTypedData cMSTypedData = this.this$0.getBcSignedData$relaynet().getSignedContent();
                return (byte[])(cMSTypedData != null ? cMSTypedData.getContent() : null);
            }
            {
                this.this$0 = signedData;
                super(0);
            }
        }));
        this.signerCertificate$delegate = LazyKt.lazy((Function0)((Function0)new Function0<X509CertificateHolder>(this){
            final /* synthetic */ SignedData this$0;

            public final X509CertificateHolder invoke() {
                X509CertificateHolder x509CertificateHolder;
                SignerId signerId = SignedData.access$getSignerInfo$p(this.this$0).getSID();
                Intrinsics.checkExpressionValueIsNotNull((Object)signerId, (String)"signerInfo.sid");
                X500Name x500Name = signerId.getIssuer();
                SignerId signerId2 = SignedData.access$getSignerInfo$p(this.this$0).getSID();
                Intrinsics.checkExpressionValueIsNotNull((Object)signerId2, (String)"signerInfo.sid");
                Selector signerCertSelector = (Selector)new X509CertificateHolderSelector(x500Name, signerId2.getSerialNumber());
                Collection signerCertMatches = this.this$0.getBcSignedData$relaynet().getCertificates().getMatches(signerCertSelector);
                try {
                    Collection collection = signerCertMatches;
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"signerCertMatches");
                    x509CertificateHolder = (X509CertificateHolder)CollectionsKt.first((Iterable)collection);
                }
                catch (NoSuchElementException _) {
                    throw (Throwable)new SignedDataException("Certificate of signer should be attached");
                }
                return x509CertificateHolder;
            }
            {
                this.this$0 = signedData;
                super(0);
            }
        }));
        this.attachedCertificates$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends X509CertificateHolder>>(this){
            final /* synthetic */ SignedData this$0;

            @NotNull
            public final Set<X509CertificateHolder> invoke() {
                Store store = this.this$0.getBcSignedData$relaynet().getCertificates();
                if (store == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.util.CollectionStore<org.bouncycastle.cert.X509CertificateHolder!>");
                }
                return CollectionsKt.toSet((Iterable)((Iterable)((CollectionStore)store)));
            }
            {
                this.this$0 = signedData;
                super(0);
            }
        }));
        this.signerInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SignerInformation>(this){
            final /* synthetic */ SignedData this$0;

            public final SignerInformation invoke() {
                int signersCount = this.this$0.getBcSignedData$relaynet().getSignerInfos().size();
                if (signersCount != 1) {
                    throw (Throwable)new SignedDataException("SignedData should contain exactly one SignerInfo (got " + signersCount + ')');
                }
                SignerInformationStore signerInformationStore = this.this$0.getBcSignedData$relaynet().getSignerInfos();
                Intrinsics.checkExpressionValueIsNotNull((Object)signerInformationStore, (String)"bcSignedData.signerInfos");
                return (SignerInformation)CollectionsKt.first((Iterable)((Iterable)signerInformationStore));
            }
            {
                this.this$0 = signedData;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        signatureAlgorithmMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)HashingAlgorithm.SHA256), (Object)"SHA256WITHRSAANDMGF1"), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA384), (Object)"SHA384WITHRSAANDMGF1"), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA512), (Object)"SHA512WITHRSAANDMGF1")});
    }

    public static final /* synthetic */ SignerInformation access$getSignerInfo$p(SignedData $this) {
        return $this.getSignerInfo();
    }

    @JvmStatic
    @NotNull
    public static final SignedData sign(@NotNull byte[] plaintext2, @NotNull PrivateKey signerPrivateKey, @NotNull X509CertificateHolder signerCertificate2, @NotNull Set<? extends X509CertificateHolder> caCertificates, @Nullable HashingAlgorithm hashingAlgorithm) {
        return Companion.sign(plaintext2, signerPrivateKey, signerCertificate2, caCertificates, hashingAlgorithm);
    }

    @JvmStatic
    @NotNull
    public static final SignedData deserialize(@NotNull byte[] serialization) {
        return Companion.deserialize(serialization);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J<\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltech/relaycorp/relaynet/crypto/SignedData$Companion;", "", "()V", "signatureAlgorithmMap", "", "Ltech/relaycorp/relaynet/HashingAlgorithm;", "", "deserialize", "Ltech/relaycorp/relaynet/crypto/SignedData;", "serialization", "", "sign", "plaintext", "signerPrivateKey", "Ljava/security/PrivateKey;", "signerCertificate", "Lorg/bouncycastle/cert/X509CertificateHolder;", "caCertificates", "", "hashingAlgorithm", "relaynet"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SignedData sign(@NotNull byte[] plaintext2, @NotNull PrivateKey signerPrivateKey, @NotNull X509CertificateHolder signerCertificate2, @NotNull Set<? extends X509CertificateHolder> caCertificates, @Nullable HashingAlgorithm hashingAlgorithm) {
            CMSSignedData bcSignedData;
            void $this$toTypedArray$iv;
            Intrinsics.checkParameterIsNotNull((Object)plaintext2, (String)"plaintext");
            Intrinsics.checkParameterIsNotNull((Object)signerPrivateKey, (String)"signerPrivateKey");
            Intrinsics.checkParameterIsNotNull((Object)signerCertificate2, (String)"signerCertificate");
            Intrinsics.checkParameterIsNotNull(caCertificates, (String)"caCertificates");
            CMSSignedDataGenerator signedDataGenerator = new CMSSignedDataGenerator();
            HashingAlgorithm hashingAlgorithm2 = hashingAlgorithm;
            if (hashingAlgorithm2 == null) {
                hashingAlgorithm2 = HashingAlgorithm.SHA256;
            }
            HashingAlgorithm algorithm = hashingAlgorithm2;
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder((String)signatureAlgorithmMap.get((Object)algorithm)).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
            ContentSigner contentSigner = signerBuilder.build(signerPrivateKey);
            Intrinsics.checkExpressionValueIsNotNull((Object)contentSigner, (String)"signerBuilder.build(signerPrivateKey)");
            ContentSigner contentSigner2 = contentSigner;
            SignerInfoGenerator signerInfoGenerator = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(contentSigner2, signerCertificate2);
            signedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)signerCertificate2);
            Collection collection = caCertificates;
            SpreadBuilder spreadBuilder2 = spreadBuilder;
            SpreadBuilder spreadBuilder3 = spreadBuilder;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            X509CertificateHolder[] x509CertificateHolderArray = thisCollection$iv.toArray(new X509CertificateHolder[0]);
            if (x509CertificateHolderArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            X509CertificateHolder[] x509CertificateHolderArray2 = x509CertificateHolderArray;
            SpreadBuilder spreadBuilder4 = spreadBuilder3;
            spreadBuilder2.addSpread((Object)x509CertificateHolderArray2);
            Collection collection2 = CollectionsKt.listOf((Object[])((X509CertificateHolder[])spreadBuilder4.toArray((Object[])new X509CertificateHolder[spreadBuilder4.size()])));
            JcaCertStore certs = new JcaCertStore(collection2);
            signedDataGenerator.addCertificates((Store)certs);
            CMSTypedData plaintextCms = (CMSTypedData)new CMSProcessableByteArray(plaintext2);
            CMSSignedData cMSSignedData = bcSignedData = signedDataGenerator.generate(plaintextCms, true);
            Intrinsics.checkExpressionValueIsNotNull((Object)cMSSignedData, (String)"bcSignedData");
            return new SignedData(cMSSignedData);
        }

        public static /* synthetic */ SignedData sign$default(Companion companion, byte[] byArray, PrivateKey privateKey, X509CertificateHolder x509CertificateHolder, Set set, HashingAlgorithm hashingAlgorithm, int n, Object object) {
            if ((n & 8) != 0) {
                boolean bl = false;
                set = SetsKt.emptySet();
            }
            if ((n & 0x10) != 0) {
                hashingAlgorithm = null;
            }
            return companion.sign(byArray, privateKey, x509CertificateHolder, set, hashingAlgorithm);
        }

        @JvmStatic
        @NotNull
        public final SignedData deserialize(@NotNull byte[] serialization) {
            CMSSignedData cMSSignedData;
            ContentInfo _2;
            ASN1Primitive aSN1Primitive;
            Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
            ASN1InputStream asn1Stream = new ASN1InputStream(serialization);
            try {
                aSN1Primitive = asn1Stream.readObject();
            }
            catch (IOException _2) {
                throw (Throwable)new SignedDataException("Value is not DER-encoded");
            }
            ASN1Primitive asn1Sequence = aSN1Primitive;
            try {
                _2 = ContentInfo.getInstance((Object)asn1Sequence);
            }
            catch (IllegalArgumentException _3) {
                throw (Throwable)new SignedDataException("SignedData value is not wrapped in ContentInfo");
            }
            ContentInfo contentInfo = _2;
            try {
                cMSSignedData = new CMSSignedData(contentInfo);
            }
            catch (CMSException _4) {
                throw (Throwable)new SignedDataException("ContentInfo wraps invalid SignedData value");
            }
            CMSSignedData bcSignedData = cMSSignedData;
            return new SignedData(bcSignedData);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

