/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.cms;

import java.io.IOException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.HashingAlgorithm;
import tech.relaycorp.relaynet.wrappers.cms.SignatureVerification;
import tech.relaycorp.relaynet.wrappers.cms.SignedDataException;
import tech.relaycorp.relaynet.wrappers.cms.SignedDataKt;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a<\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0000\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"signatureAlgorithmMap", "", "Ltech/relaycorp/relaynet/HashingAlgorithm;", "", "getSignerInfoFromSignedData", "Lorg/bouncycastle/cms/SignerInformation;", "signedData", "Lorg/bouncycastle/cms/CMSSignedData;", "parseCmsSignedData", "cmsSignedDataSerialized", "", "sign", "plaintext", "signerPrivateKey", "Ljava/security/PrivateKey;", "signerCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "caCertificates", "", "hashingAlgorithm", "verifySignature", "Ltech/relaycorp/relaynet/wrappers/cms/SignatureVerification;", "cmsSignedData", "relaynet"})
public final class SignedDataKt {
    private static final Map<HashingAlgorithm, String> signatureAlgorithmMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)HashingAlgorithm.SHA256), (Object)"SHA256withRSA"), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA384), (Object)"SHA384withRSA"), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA512), (Object)"SHA512withRSA")});

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final byte[] sign(@NotNull byte[] plaintext, @NotNull PrivateKey signerPrivateKey, @NotNull Certificate signerCertificate, @NotNull Set<Certificate> caCertificates, @Nullable HashingAlgorithm hashingAlgorithm) throws SignedDataException {
        CMSSignedData cmsSignedData;
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
        Intrinsics.checkParameterIsNotNull((Object)signerPrivateKey, (String)"signerPrivateKey");
        Intrinsics.checkParameterIsNotNull((Object)signerCertificate, (String)"signerCertificate");
        Intrinsics.checkParameterIsNotNull(caCertificates, (String)"caCertificates");
        CMSSignedDataGenerator signedDataGenerator = new CMSSignedDataGenerator();
        HashingAlgorithm hashingAlgorithm2 = hashingAlgorithm;
        if (hashingAlgorithm2 == null) {
            hashingAlgorithm2 = HashingAlgorithm.SHA256;
        }
        HashingAlgorithm algorithm = hashingAlgorithm2;
        JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(signatureAlgorithmMap.get((Object)algorithm));
        ContentSigner contentSigner = signerBuilder.build(signerPrivateKey);
        Intrinsics.checkExpressionValueIsNotNull((Object)contentSigner, (String)"signerBuilder.build(signerPrivateKey)");
        ContentSigner contentSigner2 = contentSigner;
        SignerInfoGenerator signerInfoGenerator = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).build(contentSigner2, signerCertificate.getCertificateHolder());
        signedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
        Iterable $this$map$iv = caCertificates;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void c;
            Certificate certificate = (Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            X509CertificateHolder x509CertificateHolder = c.getCertificateHolder();
            collection.add(x509CertificateHolder);
        }
        List caCertHolders = (List)destination$iv$iv;
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)signerCertificate.getCertificateHolder());
        Collection $i$f$map22 = caCertHolders;
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        SpreadBuilder spreadBuilder3 = spreadBuilder;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        X509CertificateHolder[] x509CertificateHolderArray = thisCollection$iv.toArray(new X509CertificateHolder[0]);
        if (x509CertificateHolderArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        X509CertificateHolder[] x509CertificateHolderArray2 = x509CertificateHolderArray;
        SpreadBuilder spreadBuilder4 = spreadBuilder3;
        spreadBuilder2.addSpread((Object)x509CertificateHolderArray2);
        Collection collection = CollectionsKt.listOf((Object[])((X509CertificateHolder[])spreadBuilder4.toArray((Object[])new X509CertificateHolder[spreadBuilder4.size()])));
        JcaCertStore certs = new JcaCertStore(collection);
        signedDataGenerator.addCertificates((Store)certs);
        CMSTypedData plaintextCms = (CMSTypedData)new CMSProcessableByteArray(plaintext);
        CMSSignedData cMSSignedData = cmsSignedData = signedDataGenerator.generate(plaintextCms, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)cMSSignedData, (String)"cmsSignedData");
        byte[] byArray = cMSSignedData.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"cmsSignedData.encoded");
        return byArray;
    }

    public static /* synthetic */ byte[] sign$default(byte[] byArray, PrivateKey privateKey, Certificate certificate, Set set, HashingAlgorithm hashingAlgorithm, int n, Object object) throws SignedDataException {
        if ((n & 8) != 0) {
            boolean bl = false;
            set = SetsKt.emptySet();
        }
        if ((n & 0x10) != 0) {
            hashingAlgorithm = null;
        }
        return SignedDataKt.sign(byArray, privateKey, certificate, set, hashingAlgorithm);
    }

    @NotNull
    public static final SignatureVerification verifySignature(@NotNull byte[] cmsSignedData) throws SignedDataException {
        X509CertificateHolder x509CertificateHolder;
        Intrinsics.checkParameterIsNotNull((Object)cmsSignedData, (String)"cmsSignedData");
        CMSSignedData signedData = SignedDataKt.parseCmsSignedData(cmsSignedData);
        SignerInformation signerInfo = SignedDataKt.getSignerInfoFromSignedData(signedData);
        SignerId signerId = signerInfo.getSID();
        Intrinsics.checkExpressionValueIsNotNull((Object)signerId, (String)"signerInfo.sid");
        X500Name x500Name = signerId.getIssuer();
        SignerId signerId2 = signerInfo.getSID();
        Intrinsics.checkExpressionValueIsNotNull((Object)signerId2, (String)"signerInfo.sid");
        Selector signerCertSelector = (Selector)new X509CertificateHolderSelector(x500Name, signerId2.getSerialNumber());
        Collection signerCertMatches = signedData.getCertificates().getMatches(signerCertSelector);
        try {
            Collection collection = signerCertMatches;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"signerCertMatches");
            x509CertificateHolder = (X509CertificateHolder)CollectionsKt.first((Iterable)collection);
        }
        catch (NoSuchElementException _) {
            throw (Throwable)new SignedDataException("Certificate of signer should be attached");
        }
        X509CertificateHolder signerCertificateHolder = x509CertificateHolder;
        SignerInformationVerifier verifier = new JcaSimpleSignerInfoVerifierBuilder().build(signerCertificateHolder);
        try {
            signerInfo.verify(verifier);
        }
        catch (CMSException _) {
            throw (Throwable)new SignedDataException("Invalid signature");
        }
        Store store = signedData.getCertificates();
        if (store == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.util.CollectionStore<org.bouncycastle.cert.X509CertificateHolder!>");
        }
        Sequence attachedCerts = CollectionsKt.asSequence((Iterable)((Iterable)((CollectionStore)store)));
        CMSTypedData cMSTypedData = signedData.getSignedContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)cMSTypedData, (String)"signedData.signedContent");
        Object object = cMSTypedData.getContent();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
        }
        byte[] byArray = (byte[])object;
        X509CertificateHolder x509CertificateHolder2 = signerCertificateHolder;
        Intrinsics.checkExpressionValueIsNotNull((Object)x509CertificateHolder2, (String)"signerCertificateHolder");
        return new SignatureVerification(byArray, new Certificate(x509CertificateHolder2), SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)attachedCerts, (Function1)verifySignature.1.INSTANCE)));
    }

    private static final SignerInformation getSignerInfoFromSignedData(CMSSignedData signedData) {
        if (signedData.getSignedContent() == null) {
            throw (Throwable)new SignedDataException("Signed plaintext should be encapsulated");
        }
        int signersCount = signedData.getSignerInfos().size();
        if (signersCount != 1) {
            throw (Throwable)new SignedDataException("SignedData should contain exactly one SignerInfo (got " + signersCount + ')');
        }
        SignerInformationStore signerInformationStore = signedData.getSignerInfos();
        Intrinsics.checkExpressionValueIsNotNull((Object)signerInformationStore, (String)"signedData.signerInfos");
        Object object = CollectionsKt.first((Iterable)((Iterable)signerInformationStore));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"signedData.signerInfos.first()");
        return (SignerInformation)object;
    }

    private static final CMSSignedData parseCmsSignedData(byte[] cmsSignedDataSerialized) throws SignedDataException {
        ContentInfo contentInfo;
        ASN1Primitive aSN1Primitive;
        ASN1InputStream asn1Stream = new ASN1InputStream(cmsSignedDataSerialized);
        try {
            aSN1Primitive = asn1Stream.readObject();
        }
        catch (IOException _) {
            throw (Throwable)new SignedDataException("Value is not DER-encoded");
        }
        ASN1Primitive asn1Sequence = aSN1Primitive;
        try {
            contentInfo = ContentInfo.getInstance((Object)asn1Sequence);
        }
        catch (IllegalArgumentException _) {
            throw (Throwable)new SignedDataException("SignedData value is not wrapped in ContentInfo");
        }
        ContentInfo contentInfo2 = contentInfo;
        try {
            contentInfo = new CMSSignedData(contentInfo2);
        }
        catch (CMSException _) {
            throw (Throwable)new SignedDataException("ContentInfo wraps invalid SignedData value");
        }
        return contentInfo;
    }
}

