/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.x509;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.sql.Date;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.DateTimeKt;
import tech.relaycorp.relaynet.wrappers.PRNGKt;
import tech.relaycorp.relaynet.wrappers.x509.BasicConstraintsExtension;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0019"}, d2={"Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "", "certificateHolder", "Lorg/bouncycastle/cert/X509CertificateHolder;", "(Lorg/bouncycastle/cert/X509CertificateHolder;)V", "getCertificateHolder", "()Lorg/bouncycastle/cert/X509CertificateHolder;", "commonName", "", "getCommonName", "()Ljava/lang/String;", "subjectPrivateAddress", "getSubjectPrivateAddress", "equals", "", "other", "hashCode", "", "serialize", "", "validate", "", "validateCommonNamePresence", "validateValidityPeriod", "Companion", "relaynet"})
public final class Certificate {
    @NotNull
    private final X509CertificateHolder certificateHolder;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getCommonName() {
        Object[] commonNames = this.certificateHolder.getSubject().getRDNs(BCStyle.CN);
        Intrinsics.checkExpressionValueIsNotNull((Object)commonNames, (String)"commonNames");
        Object object = ArraysKt.first((Object[])commonNames);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"commonNames.first()");
        AttributeTypeAndValue attributeTypeAndValue = ((RDN)object).getFirst();
        Intrinsics.checkExpressionValueIsNotNull((Object)attributeTypeAndValue, (String)"commonNames.first().first");
        return attributeTypeAndValue.getValue().toString();
    }

    @NotNull
    public final String getSubjectPrivateAddress() {
        StringBuilder stringBuilder = new StringBuilder().append("0");
        SubjectPublicKeyInfo subjectPublicKeyInfo = this.certificateHolder.getSubjectPublicKeyInfo();
        Intrinsics.checkExpressionValueIsNotNull((Object)subjectPublicKeyInfo, (String)"certificateHolder.subjectPublicKeyInfo");
        byte[] byArray = subjectPublicKeyInfo.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"certificateHolder.subjectPublicKeyInfo.encoded");
        return stringBuilder.append(CryptoUtils.getSHA256DigestHex(byArray)).toString();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Certificate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.certificateHolder, (Object)((Certificate)other).certificateHolder);
    }

    public int hashCode() {
        return this.certificateHolder.hashCode();
    }

    @NotNull
    public final byte[] serialize() {
        byte[] byArray = this.certificateHolder.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"certificateHolder.encoded");
        return byArray;
    }

    public final void validate() throws CertificateException {
        this.validateValidityPeriod();
        this.validateCommonNamePresence();
    }

    private final void validateValidityPeriod() {
        ZonedDateTime now = ZonedDateTime.now();
        java.util.Date date = this.certificateHolder.getNotBefore();
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"certificateHolder.notBefore");
        if (now.compareTo(DateTimeKt.dateToZonedDateTime(date)) < 0) {
            throw (Throwable)new CertificateException("Certificate is not yet valid");
        }
        java.util.Date date2 = this.certificateHolder.getNotAfter();
        Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"certificateHolder.notAfter");
        if (DateTimeKt.dateToZonedDateTime(date2).compareTo(now) < 0) {
            throw (Throwable)new CertificateException("Certificate already expired");
        }
    }

    private final void validateCommonNamePresence() {
        RDN[] rDNArray = this.certificateHolder.getSubject().getRDNs(BCStyle.CN);
        Intrinsics.checkExpressionValueIsNotNull((Object)rDNArray, (String)"certificateHolder.subject.getRDNs(BCStyle.CN)");
        RDN[] rDNArray2 = rDNArray;
        boolean bl = false;
        if (rDNArray2.length == 0) {
            throw (Throwable)new CertificateException("Subject should have a Common Name");
        }
    }

    @NotNull
    public final X509CertificateHolder getCertificateHolder() {
        return this.certificateHolder;
    }

    public Certificate(@NotNull X509CertificateHolder certificateHolder) {
        Intrinsics.checkParameterIsNotNull((Object)certificateHolder, (String)"certificateHolder");
        this.certificateHolder = certificateHolder;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJW\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a8\u0006\u001c"}, d2={"Ltech/relaycorp/relaynet/wrappers/x509/Certificate$Companion;", "", "()V", "buildDistinguishedName", "Lorg/bouncycastle/asn1/x500/X500Name;", "commonName", "", "deserialize", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "certificateSerialized", "", "issue", "subjectCommonName", "subjectPublicKey", "Ljava/security/PublicKey;", "issuerPrivateKey", "Ljava/security/PrivateKey;", "validityEndDate", "Ljava/time/ZonedDateTime;", "issuerCertificate", "isCA", "", "pathLenConstraint", "", "validityStartDate", "issue$relaynet", "requireCertificateToBeCA", "", "relaynet"})
    public static final class Companion {
        @NotNull
        public final Certificate issue$relaynet(@NotNull String subjectCommonName, @NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull ZonedDateTime validityEndDate, @Nullable Certificate issuerCertificate, boolean isCA, int pathLenConstraint, @NotNull ZonedDateTime validityStartDate) throws CertificateException {
            Intrinsics.checkParameterIsNotNull((Object)subjectCommonName, (String)"subjectCommonName");
            Intrinsics.checkParameterIsNotNull((Object)subjectPublicKey, (String)"subjectPublicKey");
            Intrinsics.checkParameterIsNotNull((Object)issuerPrivateKey, (String)"issuerPrivateKey");
            Intrinsics.checkParameterIsNotNull((Object)validityEndDate, (String)"validityEndDate");
            Intrinsics.checkParameterIsNotNull((Object)validityStartDate, (String)"validityStartDate");
            if (validityStartDate.compareTo(validityEndDate) >= 0) {
                throw (Throwable)new CertificateException("The end date must be later than the start date");
            }
            if (issuerCertificate != null) {
                this.requireCertificateToBeCA(issuerCertificate);
            }
            X500Name subjectDistinguishedName = this.buildDistinguishedName(subjectCommonName);
            X500Name issuerDistinguishedName = issuerCertificate != null ? issuerCertificate.getCertificateHolder().getSubject() : subjectDistinguishedName;
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)subjectPublicKey.getEncoded());
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuerDistinguishedName, PRNGKt.generateRandomBigInteger(), Date.from(validityStartDate.toInstant()), Date.from(validityEndDate.toInstant()), subjectDistinguishedName, subjectPublicKeyInfo);
            BasicConstraintsExtension basicConstraints = new BasicConstraintsExtension(isCA, pathLenConstraint);
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)basicConstraints);
            SubjectPublicKeyInfo subjectPublicKeyInfo2 = subjectPublicKeyInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)subjectPublicKeyInfo2, (String)"subjectPublicKeyInfo");
            byte[] byArray = subjectPublicKeyInfo2.getEncoded();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"subjectPublicKeyInfo.encoded");
            byte[] subjectPublicKeyDigest = CryptoUtils.getSHA256Digest(byArray);
            SubjectKeyIdentifier subjectSKI = new SubjectKeyIdentifier(subjectPublicKeyDigest);
            builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)subjectSKI);
            SubjectKeyIdentifier issuerSKI = subjectSKI;
            if (issuerCertificate != null) {
                SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.fromExtensions((Extensions)issuerCertificate.getCertificateHolder().getExtensions());
                if (subjectKeyIdentifier == null) {
                    throw (Throwable)new CertificateException("Issuer must have the SubjectKeyIdentifier extension");
                }
                issuerSKI = subjectKeyIdentifier;
            }
            AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(issuerSKI.getKeyIdentifier());
            builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)aki);
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WITHRSAANDMGF1").setProvider((Provider)CryptoUtils.getBC_PROVIDER()).build(issuerPrivateKey);
            X509CertificateHolder x509CertificateHolder = builder.build(signer);
            Intrinsics.checkExpressionValueIsNotNull((Object)x509CertificateHolder, (String)"builder.build(signer)");
            return new Certificate(x509CertificateHolder);
        }

        public static /* synthetic */ Certificate issue$relaynet$default(Companion companion, String string, PublicKey publicKey, PrivateKey privateKey, ZonedDateTime zonedDateTime, Certificate certificate, boolean bl, int n, ZonedDateTime zonedDateTime2, int n2, Object object) throws CertificateException {
            if ((n2 & 0x10) != 0) {
                certificate = null;
            }
            if ((n2 & 0x20) != 0) {
                bl = false;
            }
            if ((n2 & 0x40) != 0) {
                n = 0;
            }
            if ((n2 & 0x80) != 0) {
                ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime3, (String)"ZonedDateTime.now()");
                zonedDateTime2 = zonedDateTime3;
            }
            return companion.issue$relaynet(string, publicKey, privateKey, zonedDateTime, certificate, bl, n, zonedDateTime2);
        }

        private final X500Name buildDistinguishedName(String commonName) throws CertificateException {
            X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
            builder.addRDN(BCStyle.CN, (ASN1Encodable)new DERBMPString(commonName));
            X500Name x500Name = builder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)x500Name, (String)"builder.build()");
            return x500Name;
        }

        private final void requireCertificateToBeCA(Certificate issuerCertificate) {
            BasicConstraints issuerBasicConstraints;
            Extension extension = issuerCertificate.getCertificateHolder().getExtension(Extension.basicConstraints);
            if (extension == null) {
                throw (Throwable)new CertificateException("Issuer certificate should have basic constraints extension");
            }
            Extension issuerBasicConstraintsExtension = extension;
            BasicConstraints basicConstraints = issuerBasicConstraints = BasicConstraints.getInstance((Object)issuerBasicConstraintsExtension.getParsedValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)basicConstraints, (String)"issuerBasicConstraints");
            if (!basicConstraints.isCA()) {
                throw (Throwable)new CertificateException("Issuer certificate should be marked as CA");
            }
        }

        @NotNull
        public final Certificate deserialize(@NotNull byte[] certificateSerialized) throws CertificateException {
            X509CertificateHolder x509CertificateHolder;
            Intrinsics.checkParameterIsNotNull((Object)certificateSerialized, (String)"certificateSerialized");
            try {
                x509CertificateHolder = new X509CertificateHolder(certificateSerialized);
            }
            catch (IOException _) {
                throw (Throwable)new CertificateException("Value should be a DER-encoded, X.509 v3 certificate");
            }
            X509CertificateHolder certificateHolder = x509CertificateHolder;
            return new Certificate(certificateHolder);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

