/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.cms;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.Collection;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.jcajce.JcaAlgorithmParametersConverter;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.SymmetricEncryption;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedData;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataException;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataKt;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionlessEnvelopedData;", "Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "bcEnvelopedData", "Lorg/bouncycastle/cms/CMSEnvelopedData;", "(Lorg/bouncycastle/cms/CMSEnvelopedData;)V", "decrypt", "", "privateKey", "Ljava/security/PrivateKey;", "getRecipientKeyId", "Ljava/math/BigInteger;", "validate", "", "Companion", "relaynet"})
public final class SessionlessEnvelopedData
extends EnvelopedData {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public byte[] decrypt(@NotNull PrivateKey privateKey) throws EnvelopedDataException {
        byte[] byArray;
        Collection recipients;
        Intrinsics.checkParameterIsNotNull((Object)privateKey, (String)"privateKey");
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkExpressionValueIsNotNull((Object)recipientInformationStore, (String)"bcEnvelopedData.recipientInfos");
        Collection collection = recipients = recipientInformationStore.getRecipients();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"recipients");
        Object object = CollectionsKt.first((Iterable)collection);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.cms.KeyTransRecipientInformation");
        }
        KeyTransRecipientInformation recipientInfo = (KeyTransRecipientInformation)object;
        JceKeyTransRecipient recipient = new JceKeyTransEnvelopedRecipient(privateKey).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
        try {
            byte[] byArray2 = recipientInfo.getContent((Recipient)recipient);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"recipientInfo.getContent(recipient)");
            byArray = byArray2;
        }
        catch (Exception exception) {
            throw (Throwable)new EnvelopedDataException("Could not decrypt value", exception);
        }
        return byArray;
    }

    @Override
    @NotNull
    public BigInteger getRecipientKeyId() {
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkExpressionValueIsNotNull((Object)recipientInformationStore, (String)"bcEnvelopedData.recipientInfos");
        Object object = CollectionsKt.first((Iterable)((Iterable)recipientInformationStore));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bcEnvelopedData.recipientInfos.first()");
        RecipientId recipientId = ((RecipientInformation)object).getRID();
        if (recipientId == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.cms.KeyTransRecipientId");
        }
        KeyTransRecipientId rid = (KeyTransRecipientId)recipientId;
        BigInteger bigInteger = rid.getSerialNumber();
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger, (String)"rid.serialNumber");
        return bigInteger;
    }

    @Override
    public void validate() throws EnvelopedDataException {
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkExpressionValueIsNotNull((Object)recipientInformationStore, (String)"bcEnvelopedData.recipientInfos");
        Object object = CollectionsKt.first((Iterable)((Iterable)recipientInformationStore));
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bcEnvelopedData.recipientInfos.first()");
        RecipientId recipientId = ((RecipientInformation)object).getRID();
        if (recipientId == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.cms.KeyTransRecipientId");
        }
        KeyTransRecipientId rid = (KeyTransRecipientId)recipientId;
        if (rid.getSerialNumber() == null) {
            throw (Throwable)new EnvelopedDataException("Required recipient key id to be IssuerAndSerialNumber (got SubjectKeyIdentifier)", null, 2, null);
        }
    }

    public SessionlessEnvelopedData(@NotNull CMSEnvelopedData bcEnvelopedData) {
        Intrinsics.checkParameterIsNotNull((Object)bcEnvelopedData, (String)"bcEnvelopedData");
        super(bcEnvelopedData, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionlessEnvelopedData$Companion;", "", "()V", "encrypt", "Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "plaintext", "", "recipientCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "symmetricEncryptionAlgorithm", "Ltech/relaycorp/relaynet/SymmetricEncryption;", "makeRecipientInfoGenerator", "Lorg/bouncycastle/cms/jcajce/JceKeyTransRecipientInfoGenerator;", "relaynet"})
    public static final class Companion {
        @NotNull
        public final EnvelopedData encrypt(@NotNull byte[] plaintext, @NotNull Certificate recipientCertificate, @NotNull SymmetricEncryption symmetricEncryptionAlgorithm) {
            CMSEnvelopedData bcEnvelopedData;
            Intrinsics.checkParameterIsNotNull((Object)plaintext, (String)"plaintext");
            Intrinsics.checkParameterIsNotNull((Object)recipientCertificate, (String)"recipientCertificate");
            Intrinsics.checkParameterIsNotNull((Object)((Object)symmetricEncryptionAlgorithm), (String)"symmetricEncryptionAlgorithm");
            CMSEnvelopedDataGenerator cmsEnvelopedDataGenerator = new CMSEnvelopedDataGenerator();
            JceKeyTransRecipientInfoGenerator recipientInfoGenerator = this.makeRecipientInfoGenerator(recipientCertificate);
            cmsEnvelopedDataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)recipientInfoGenerator);
            CMSProcessableByteArray msg = new CMSProcessableByteArray(plaintext);
            ASN1ObjectIdentifier contentEncryptionAlgorithm = (ASN1ObjectIdentifier)EnvelopedDataKt.access$getCmsContentEncryptionAlgorithm$p().get((Object)symmetricEncryptionAlgorithm);
            JceCMSContentEncryptorBuilder encryptorBuilder = new JceCMSContentEncryptorBuilder(contentEncryptionAlgorithm).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
            CMSEnvelopedData cMSEnvelopedData = bcEnvelopedData = cmsEnvelopedDataGenerator.generate((CMSTypedData)msg, encryptorBuilder.build());
            Intrinsics.checkExpressionValueIsNotNull((Object)cMSEnvelopedData, (String)"bcEnvelopedData");
            return new SessionlessEnvelopedData(cMSEnvelopedData);
        }

        public static /* synthetic */ EnvelopedData encrypt$default(Companion companion, byte[] byArray, Certificate certificate, SymmetricEncryption symmetricEncryption, int n, Object object) {
            if ((n & 4) != 0) {
                symmetricEncryption = SymmetricEncryption.AES_128;
            }
            return companion.encrypt(byArray, certificate, symmetricEncryption);
        }

        private final JceKeyTransRecipientInfoGenerator makeRecipientInfoGenerator(Certificate recipientCertificate) {
            X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(recipientCertificate.getCertificateHolder());
            AlgorithmIdentifier algorithmIdentifier = new JcaAlgorithmParametersConverter().getAlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (AlgorithmParameterSpec)new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT));
            JceKeyTransRecipientInfoGenerator jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(x509Certificate, algorithmIdentifier).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
            Intrinsics.checkExpressionValueIsNotNull((Object)jceKeyTransRecipientInfoGenerator, (String)"JceKeyTransRecipientInfo\u2026.setProvider(BC_PROVIDER)");
            return jceKeyTransRecipientInfoGenerator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

