/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.ramf;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerDateTime;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerOctetString;
import com.beanit.jasn1.ber.types.string.BerVisibleString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.ramf.RAMFMessage;
import tech.relaycorp.relaynet.ramf.RAMFSerializerKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003BA\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012*\u0010\u0007\u001a&\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR2\u0010\u0007\u001a&\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFSerializer;", "T", "Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "", "concreteMessageType", "", "concreteMessageVersion", "messageClazz", "Lkotlin/Function5;", "", "Ljava/time/ZonedDateTime;", "", "", "(BBLkotlin/jvm/functions/Function5;)V", "getConcreteMessageType", "()B", "getConcreteMessageVersion", "deserialize", "serialization", "([B)Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "deserializeFields", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "serialize", "message", "(Ltech/relaycorp/relaynet/ramf/RAMFMessage;)[B", "serializeMessage", "relaynet"})
public class RAMFSerializer<T extends RAMFMessage> {
    private final byte concreteMessageType;
    private final byte concreteMessageVersion;
    private final Function5<String, String, ZonedDateTime, Integer, byte[], T> messageClazz;

    @NotNull
    public final byte[] serialize(@NotNull T message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String string = "Relaynet";
        ByteArrayOutputStream byteArrayOutputStream = output;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byteArrayOutputStream.write(byArray2);
        output.write(this.concreteMessageType);
        output.write(this.concreteMessageVersion);
        output.write(this.serializeMessage(message));
        byte[] byArray3 = output.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"output.toByteArray()");
        return byArray3;
    }

    private final byte[] serializeMessage(T message) throws IOException {
        BigInteger bigInteger;
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(1000, true);
        int codeLength = 0;
        codeLength += new BerOctetString(((RAMFMessage)message).getPayload()).encode((OutputStream)reverseOS, false);
        reverseOS.write(132);
        int n = ((RAMFMessage)message).getTtl();
        int n2 = ++codeLength;
        boolean bl = false;
        BigInteger bigInteger2 = BigInteger.valueOf(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2, (String)"BigInteger.valueOf(this.toLong())");
        BigInteger bigInteger3 = bigInteger = bigInteger2;
        codeLength = n2 + new BerInteger(bigInteger3).encode((OutputStream)reverseOS, false);
        reverseOS.write(131);
        ++codeLength;
        ZonedDateTime creationTimeUtc = ((RAMFMessage)message).getCreationTime().withZoneSameInstant(RAMFSerializerKt.access$getUTC_ZONE_ID$p());
        codeLength += new BerDateTime(creationTimeUtc.format(RAMFSerializerKt.getBER_DATETIME_FORMATTER())).encode((OutputStream)reverseOS, false);
        reverseOS.write(130);
        ++codeLength;
        codeLength += new BerVisibleString(((RAMFMessage)message).getMessageId()).encode((OutputStream)reverseOS, false);
        reverseOS.write(129);
        ++codeLength;
        codeLength += new BerVisibleString(((RAMFMessage)message).getRecipientAddress()).encode((OutputStream)reverseOS, false);
        reverseOS.write(128);
        BerLength.encodeLength((OutputStream)((OutputStream)reverseOS), (int)(++codeLength));
        RAMFSerializerKt.access$getDER_SEQUENCE_TAG$p().encode((OutputStream)reverseOS);
        byte[] byArray = reverseOS.getArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"reverseOS.array");
        return byArray;
    }

    @NotNull
    public final T deserialize(@NotNull byte[] serialization) throws RAMFException {
        Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
        ByteArrayInputStream serializationStream = new ByteArrayInputStream(serialization);
        if (serializationStream.available() < 10) {
            throw (Throwable)new RAMFException("Serialization is too short to contain format signature");
        }
        byte[] byArray = serializationStream.readNBytes(8);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"serializationStream.readNBytes(8)");
        byte[] byArray2 = byArray;
        Charset charset = Charset.forName("ASCII");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"ASCII\")");
        Charset charset2 = charset;
        boolean bl = false;
        boolean bl2 = false;
        String magicConstant = new String(byArray2, charset2);
        if (Intrinsics.areEqual((Object)magicConstant, (Object)"Relaynet") ^ true) {
            throw (Throwable)new RAMFException("Format signature should start with magic constant 'Relaynet'");
        }
        int messageType = serializationStream.read();
        if (messageType != this.concreteMessageType) {
            throw (Throwable)new RAMFException("Message type should be " + this.concreteMessageType + " (got " + messageType + ')');
        }
        int messageVersion = serializationStream.read();
        if (messageVersion != this.concreteMessageVersion) {
            throw (Throwable)new RAMFException("Message version should be " + this.concreteMessageVersion + " (got " + messageVersion + ')');
        }
        return this.deserializeFields(serializationStream);
    }

    private final T deserializeFields(InputStream serialization) throws RAMFException {
        LocalDateTime localDateTime;
        ASN1Sequence _2;
        ASN1Primitive aSN1Primitive;
        ASN1InputStream asn1InputStream = new ASN1InputStream(serialization);
        try {
            aSN1Primitive = asn1InputStream.readObject();
        }
        catch (IOException _2) {
            throw (Throwable)new RAMFException("Message fields are not a DER-encoded");
        }
        ASN1Primitive asn1Value = aSN1Primitive;
        try {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)asn1Value);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1Sequence, (String)"ASN1Sequence.getInstance(asn1Value)");
            _2 = aSN1Sequence;
        }
        catch (IllegalArgumentException _3) {
            throw (Throwable)new RAMFException("Message fields are not a ASN.1 sequence");
        }
        ASN1Sequence fieldSequence = _2;
        ASN1Encodable[] fields = fieldSequence.toArray();
        if (fields.length != 5) {
            throw (Throwable)new RAMFException("Field sequence should contain 5 items (got " + fields.length + ')');
        }
        ASN1Encodable aSN1Encodable = fields[0];
        if (aSN1Encodable == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
        }
        DERVisibleString recipientAddress = DERVisibleString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable), (boolean)false);
        ASN1Encodable aSN1Encodable2 = fields[1];
        if (aSN1Encodable2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
        }
        DERVisibleString messageId = DERVisibleString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable2), (boolean)false);
        ASN1Encodable aSN1Encodable3 = fields[2];
        if (aSN1Encodable3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
        }
        DERVisibleString creationTimeDer = DERVisibleString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable3), (boolean)false);
        try {
            DERVisibleString dERVisibleString = creationTimeDer;
            Intrinsics.checkExpressionValueIsNotNull((Object)dERVisibleString, (String)"creationTimeDer");
            localDateTime = LocalDateTime.parse(dERVisibleString.getString(), RAMFSerializerKt.getBER_DATETIME_FORMATTER());
        }
        catch (DateTimeParseException _4) {
            throw (Throwable)new RAMFException("Creation time should be an ASN.1 DATE-TIME value");
        }
        LocalDateTime creationTime = localDateTime;
        ASN1Encodable aSN1Encodable4 = fields[3];
        if (aSN1Encodable4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
        }
        ASN1Integer ttlDer = ASN1Integer.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable4), (boolean)false);
        ASN1Encodable aSN1Encodable5 = fields[4];
        if (aSN1Encodable5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
        }
        ASN1OctetString payloadDer = DEROctetString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable5), (boolean)false);
        DERVisibleString dERVisibleString = recipientAddress;
        Intrinsics.checkExpressionValueIsNotNull((Object)dERVisibleString, (String)"recipientAddress");
        String string = dERVisibleString.getString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"recipientAddress.string");
        DERVisibleString dERVisibleString2 = messageId;
        Intrinsics.checkExpressionValueIsNotNull((Object)dERVisibleString2, (String)"messageId");
        String string2 = dERVisibleString2.getString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"messageId.string");
        ZonedDateTime zonedDateTime = ZonedDateTime.of(creationTime, RAMFSerializerKt.access$getUTC_ZONE_ID$p());
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.of(creationTime, UTC_ZONE_ID)");
        Integer n = ttlDer.intPositiveValueExact();
        ASN1OctetString aSN1OctetString = payloadDer;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1OctetString, (String)"payloadDer");
        byte[] byArray = aSN1OctetString.getOctets();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"payloadDer.octets");
        return (T)((RAMFMessage)this.messageClazz.invoke((Object)string, (Object)string2, (Object)zonedDateTime, (Object)n, (Object)byArray));
    }

    public final byte getConcreteMessageType() {
        return this.concreteMessageType;
    }

    public final byte getConcreteMessageVersion() {
        return this.concreteMessageVersion;
    }

    public RAMFSerializer(byte concreteMessageType, byte concreteMessageVersion, @NotNull Function5<? super String, ? super String, ? super ZonedDateTime, ? super Integer, ? super byte[], ? extends T> messageClazz) {
        Intrinsics.checkParameterIsNotNull(messageClazz, (String)"messageClazz");
        this.concreteMessageType = concreteMessageType;
        this.concreteMessageVersion = concreteMessageVersion;
        this.messageClazz = messageClazz;
    }
}

