/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.asn1;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Ltech/relaycorp/relaynet/wrappers/asn1/ASN1Utils;", "", "()V", "deserializeSequence", "", "Lorg/bouncycastle/asn1/ASN1Encodable;", "serialization", "", "([B)[Lorg/bouncycastle/asn1/ASN1Encodable;", "relaynet"})
public final class ASN1Utils {
    public static final ASN1Utils INSTANCE;

    @NotNull
    public final ASN1Encodable[] deserializeSequence(@NotNull byte[] serialization) throws ASN1Exception {
        ASN1Sequence aSN1Sequence;
        ASN1Primitive aSN1Primitive;
        Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
        ASN1InputStream asn1InputStream = new ASN1InputStream(serialization);
        try {
            aSN1Primitive = asn1InputStream.readObject();
        }
        catch (IOException _) {
            throw (Throwable)new ASN1Exception("Value is not DER-encoded");
        }
        ASN1Primitive asn1Value = aSN1Primitive;
        try {
            ASN1Sequence aSN1Sequence2 = ASN1Sequence.getInstance((Object)asn1Value);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1Sequence2, (String)"ASN1Sequence.getInstance(asn1Value)");
            aSN1Sequence = aSN1Sequence2;
        }
        catch (IllegalArgumentException _) {
            throw (Throwable)new ASN1Exception("Value is not an ASN.1 sequence");
        }
        ASN1Sequence fieldSequence = aSN1Sequence;
        ASN1Encodable[] aSN1EncodableArray = fieldSequence.toArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1EncodableArray, (String)"fieldSequence.toArray()");
        return aSN1EncodableArray;
    }

    private ASN1Utils() {
    }

    static {
        ASN1Utils aSN1Utils;
        INSTANCE = aSN1Utils = new ASN1Utils();
    }
}

