/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet;

import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u00a8\u0006\u0005"}, d2={"getSHA256Digest", "", "input", "getSHA256DigestHex", "", "relaynet"})
@JvmName(name="CryptoUtils")
public final class CryptoUtils {
    @NotNull
    public static final byte[] getSHA256Digest(@NotNull byte[] input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] byArray = digest.digest(input);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digest.digest(input)");
        return byArray;
    }

    @NotNull
    public static final String getSHA256DigestHex(@NotNull byte[] input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return ArraysKt.joinToString$default((byte[])CryptoUtils.getSHA256Digest(input), (CharSequence)"", null, null, (int)0, null, (Function1)getSHA256DigestHex.1.INSTANCE, (int)30, null);
    }
}

