/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.ramf;

import java.security.PrivateKey;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.HashingAlgorithm;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.ramf.RAMFSerializer;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006$"}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "", "serializer", "Ltech/relaycorp/relaynet/ramf/RAMFSerializer;", "recipientAddress", "", "payload", "", "senderCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "id", "creationDate", "Ljava/time/ZonedDateTime;", "ttl", "", "senderCertificateChain", "", "(Ltech/relaycorp/relaynet/ramf/RAMFSerializer;Ljava/lang/String;[BLtech/relaycorp/relaynet/wrappers/x509/Certificate;Ljava/lang/String;Ljava/time/ZonedDateTime;Ljava/lang/Integer;Ljava/util/Set;)V", "getCreationDate", "()Ljava/time/ZonedDateTime;", "getId", "()Ljava/lang/String;", "getPayload", "()[B", "getRecipientAddress", "getSenderCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getSenderCertificateChain", "()Ljava/util/Set;", "getTtl", "()I", "serialize", "senderPrivateKey", "Ljava/security/PrivateKey;", "hashingAlgorithm", "Ltech/relaycorp/relaynet/HashingAlgorithm;", "relaynet"})
public abstract class RAMFMessage {
    @NotNull
    private final String id;
    @NotNull
    private final ZonedDateTime creationDate;
    private final int ttl;
    @NotNull
    private final Set<Certificate> senderCertificateChain;
    private final RAMFSerializer serializer;
    @NotNull
    private final String recipientAddress;
    @NotNull
    private final byte[] payload;
    @NotNull
    private final Certificate senderCertificate;

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final ZonedDateTime getCreationDate() {
        return this.creationDate;
    }

    public final int getTtl() {
        return this.ttl;
    }

    @NotNull
    public final Set<Certificate> getSenderCertificateChain() {
        return this.senderCertificateChain;
    }

    @NotNull
    public final byte[] serialize(@NotNull PrivateKey senderPrivateKey, @Nullable HashingAlgorithm hashingAlgorithm) {
        Intrinsics.checkParameterIsNotNull((Object)senderPrivateKey, (String)"senderPrivateKey");
        return this.serializer.serialize(this, senderPrivateKey, hashingAlgorithm);
    }

    public static /* synthetic */ byte[] serialize$default(RAMFMessage rAMFMessage, PrivateKey privateKey, HashingAlgorithm hashingAlgorithm, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: serialize");
        }
        if ((n & 2) != 0) {
            hashingAlgorithm = null;
        }
        return rAMFMessage.serialize(privateKey, hashingAlgorithm);
    }

    @NotNull
    public final String getRecipientAddress() {
        return this.recipientAddress;
    }

    @NotNull
    public final byte[] getPayload() {
        return this.payload;
    }

    @NotNull
    public final Certificate getSenderCertificate() {
        return this.senderCertificate;
    }

    public RAMFMessage(@NotNull RAMFSerializer serializer, @NotNull String recipientAddress, @NotNull byte[] payload, @NotNull Certificate senderCertificate, @Nullable String id, @Nullable ZonedDateTime creationDate, @Nullable Integer ttl, @Nullable Set<Certificate> senderCertificateChain) {
        Intrinsics.checkParameterIsNotNull((Object)serializer, (String)"serializer");
        Intrinsics.checkParameterIsNotNull((Object)recipientAddress, (String)"recipientAddress");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        Intrinsics.checkParameterIsNotNull((Object)senderCertificate, (String)"senderCertificate");
        this.serializer = serializer;
        this.recipientAddress = recipientAddress;
        this.payload = payload;
        this.senderCertificate = senderCertificate;
        String string = id;
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
        }
        this.id = string;
        ZonedDateTime zonedDateTime = creationDate;
        if (zonedDateTime == null) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now(ZoneId.of("UTC"));
            zonedDateTime = zonedDateTime2;
            Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime2, (String)"ZonedDateTime.now(ZoneId.of(\"UTC\"))");
        }
        this.creationDate = zonedDateTime;
        Integer n = ttl;
        this.ttl = n != null ? n : 300;
        RAMFMessage rAMFMessage = this;
        Set set = senderCertificateChain;
        if (set == null) {
            RAMFMessage rAMFMessage2 = rAMFMessage;
            boolean bl = false;
            Set set2 = SetsKt.emptySet();
            rAMFMessage = rAMFMessage2;
            set = set2;
        }
        rAMFMessage.senderCertificateChain = set;
        if (1024 < this.recipientAddress.length()) {
            throw (Throwable)new RAMFException("Recipient address cannot span more than 1024 octets " + "(got " + this.recipientAddress.length() + ')');
        }
        if (64 < this.id.length()) {
            throw (Throwable)new RAMFException("Message id cannot span more than 64 octets " + "(got " + this.id.length() + ')');
        }
        if (this.ttl < 0) {
            throw (Throwable)new RAMFException("TTL cannot be negative (got " + this.ttl + ')');
        }
        if (15552000 < this.ttl) {
            throw (Throwable)new RAMFException("TTL cannot be greater than 15552000 (got " + this.ttl + ')');
        }
        if (0x800000 < this.payload.length) {
            throw (Throwable)new RAMFException("Payload cannot span more than 8388608 octets (got " + this.payload.length + ')');
        }
    }
}

