/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.x509;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.sql.Date;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.wrappers.PRNGKt;
import tech.relaycorp.relaynet.wrappers.x509.BasicConstraintsExtension;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "", "certificateHolder", "Lorg/bouncycastle/cert/X509CertificateHolder;", "(Lorg/bouncycastle/cert/X509CertificateHolder;)V", "getCertificateHolder", "()Lorg/bouncycastle/cert/X509CertificateHolder;", "equals", "", "other", "hashCode", "", "serialize", "", "Companion", "relaynet"})
public final class Certificate {
    @NotNull
    private final X509CertificateHolder certificateHolder;
    private static final String DEFAULT_ALGORITHM = "SHA256WithRSAEncryption";
    public static final Companion Companion = new Companion(null);

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Certificate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.certificateHolder, (Object)((Certificate)other).certificateHolder);
    }

    public int hashCode() {
        return this.certificateHolder.hashCode();
    }

    @NotNull
    public final byte[] serialize() {
        byte[] byArray = this.certificateHolder.getEncoded();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"certificateHolder.encoded");
        return byArray;
    }

    @NotNull
    public final X509CertificateHolder getCertificateHolder() {
        return this.certificateHolder;
    }

    public Certificate(@NotNull X509CertificateHolder certificateHolder) {
        Intrinsics.checkParameterIsNotNull((Object)certificateHolder, (String)"certificateHolder");
        this.certificateHolder = certificateHolder;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002JP\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ltech/relaycorp/relaynet/wrappers/x509/Certificate$Companion;", "", "()V", "DEFAULT_ALGORITHM", "", "buildDistinguishedName", "Lorg/bouncycastle/asn1/x500/X500Name;", "commonName", "deserialize", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "certificateSerialized", "", "getPublicKeyInfoDigest", "keyInfo", "Lorg/bouncycastle/asn1/x509/SubjectPublicKeyInfo;", "issue", "subjectCommonName", "subjectPublicKey", "Ljava/security/PublicKey;", "issuerPrivateKey", "Ljava/security/PrivateKey;", "validityEndDate", "Ljava/time/ZonedDateTime;", "issuerCertificate", "isCA", "", "pathLenConstraint", "", "validityStartDate", "makeSigner", "Lorg/bouncycastle/operator/ContentSigner;", "requireCertificateToBeCA", "", "relaynet"})
    public static final class Companion {
        @NotNull
        public final Certificate issue(@NotNull String subjectCommonName, @NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull ZonedDateTime validityEndDate, @Nullable Certificate issuerCertificate, boolean isCA, int pathLenConstraint, @NotNull ZonedDateTime validityStartDate) throws CertificateException {
            byte[] byArray;
            Intrinsics.checkParameterIsNotNull((Object)subjectCommonName, (String)"subjectCommonName");
            Intrinsics.checkParameterIsNotNull((Object)subjectPublicKey, (String)"subjectPublicKey");
            Intrinsics.checkParameterIsNotNull((Object)issuerPrivateKey, (String)"issuerPrivateKey");
            Intrinsics.checkParameterIsNotNull((Object)validityEndDate, (String)"validityEndDate");
            Intrinsics.checkParameterIsNotNull((Object)validityStartDate, (String)"validityStartDate");
            if (validityStartDate.compareTo(validityEndDate) >= 0) {
                throw (Throwable)new CertificateException("The end date must be later than the start date");
            }
            if (issuerCertificate != null) {
                this.requireCertificateToBeCA(issuerCertificate);
            }
            X500Name subjectDistinguishedName = this.buildDistinguishedName(subjectCommonName);
            X500Name issuerDistinguishedName = issuerCertificate != null ? issuerCertificate.getCertificateHolder().getIssuer() : subjectDistinguishedName;
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)subjectPublicKey.getEncoded());
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuerDistinguishedName, PRNGKt.generateRandomBigInteger(), (java.util.Date)Date.valueOf(validityStartDate.toLocalDate()), (java.util.Date)Date.valueOf(validityEndDate.toLocalDate()), subjectDistinguishedName, subjectPublicKeyInfo);
            BasicConstraintsExtension basicConstraints = new BasicConstraintsExtension(isCA, pathLenConstraint);
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)basicConstraints);
            SubjectPublicKeyInfo subjectPublicKeyInfo2 = subjectPublicKeyInfo;
            Intrinsics.checkExpressionValueIsNotNull((Object)subjectPublicKeyInfo2, (String)"subjectPublicKeyInfo");
            byte[] subjectPublicKeyDigest = this.getPublicKeyInfoDigest(subjectPublicKeyInfo2);
            SubjectKeyIdentifier ski = new SubjectKeyIdentifier(subjectPublicKeyDigest);
            builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)ski);
            if (issuerCertificate != null) {
                SubjectPublicKeyInfo subjectPublicKeyInfo3 = issuerCertificate.getCertificateHolder().getSubjectPublicKeyInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)subjectPublicKeyInfo3, (String)"issuerCertificate.certif\u2026lder.subjectPublicKeyInfo");
                byArray = this.getPublicKeyInfoDigest(subjectPublicKeyInfo3);
            } else {
                byArray = subjectPublicKeyDigest;
            }
            byte[] issuerPublicKeyDigest = byArray;
            AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(issuerPublicKeyDigest);
            builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)aki);
            ContentSigner signerBuilder = this.makeSigner(issuerPrivateKey);
            X509CertificateHolder x509CertificateHolder = builder.build(signerBuilder);
            Intrinsics.checkExpressionValueIsNotNull((Object)x509CertificateHolder, (String)"builder.build(signerBuilder)");
            return new Certificate(x509CertificateHolder);
        }

        public static /* synthetic */ Certificate issue$default(Companion companion, String string, PublicKey publicKey, PrivateKey privateKey, ZonedDateTime zonedDateTime, Certificate certificate, boolean bl, int n, ZonedDateTime zonedDateTime2, int n2, Object object) throws CertificateException {
            if ((n2 & 0x10) != 0) {
                certificate = null;
            }
            if ((n2 & 0x20) != 0) {
                bl = false;
            }
            if ((n2 & 0x40) != 0) {
                n = 0;
            }
            if ((n2 & 0x80) != 0) {
                ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime3, (String)"ZonedDateTime.now()");
                zonedDateTime2 = zonedDateTime3;
            }
            return companion.issue(string, publicKey, privateKey, zonedDateTime, certificate, bl, n, zonedDateTime2);
        }

        private final byte[] getPublicKeyInfoDigest(SubjectPublicKeyInfo keyInfo) {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            ASN1Primitive aSN1Primitive = keyInfo.parsePublicKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1Primitive, (String)"keyInfo.parsePublicKey()");
            byte[] byArray = digest.digest(aSN1Primitive.getEncoded());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digest.digest(keyInfo.parsePublicKey().encoded)");
            return byArray;
        }

        private final X500Name buildDistinguishedName(String commonName) throws CertificateException {
            X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
            builder.addRDN(BCStyle.C, commonName);
            X500Name x500Name = builder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)x500Name, (String)"builder.build()");
            return x500Name;
        }

        private final void requireCertificateToBeCA(Certificate issuerCertificate) {
            BasicConstraints issuerBasicConstraints;
            Extension extension = issuerCertificate.getCertificateHolder().getExtension(Extension.basicConstraints);
            if (extension == null) {
                throw (Throwable)new CertificateException("Issuer certificate should have basic constraints extension");
            }
            Extension issuerBasicConstraintsExtension = extension;
            BasicConstraints basicConstraints = issuerBasicConstraints = BasicConstraints.getInstance((Object)issuerBasicConstraintsExtension.getParsedValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)basicConstraints, (String)"issuerBasicConstraints");
            if (!basicConstraints.isCA()) {
                throw (Throwable)new CertificateException("Issuer certificate should be marked as CA");
            }
        }

        private final ContentSigner makeSigner(PrivateKey issuerPrivateKey) {
            AlgorithmIdentifier signatureAlgorithm = new DefaultSignatureAlgorithmIdentifierFinder().find(Certificate.DEFAULT_ALGORITHM);
            AlgorithmIdentifier digestAlgorithm = new DefaultDigestAlgorithmIdentifierFinder().find(signatureAlgorithm);
            AsymmetricKeyParameter asymmetricKeyParameter = PrivateKeyFactory.createKey((byte[])issuerPrivateKey.getEncoded());
            Intrinsics.checkExpressionValueIsNotNull((Object)asymmetricKeyParameter, (String)"PrivateKeyFactory.create\u2026issuerPrivateKey.encoded)");
            AsymmetricKeyParameter privateKeyParam = asymmetricKeyParameter;
            BcRSAContentSignerBuilder contentSignerBuilder = new BcRSAContentSignerBuilder(signatureAlgorithm, digestAlgorithm);
            ContentSigner contentSigner = contentSignerBuilder.build(privateKeyParam);
            Intrinsics.checkExpressionValueIsNotNull((Object)contentSigner, (String)"contentSignerBuilder.build(privateKeyParam)");
            return contentSigner;
        }

        @NotNull
        public final Certificate deserialize(@NotNull byte[] certificateSerialized) throws CertificateException {
            X509CertificateHolder x509CertificateHolder;
            Intrinsics.checkParameterIsNotNull((Object)certificateSerialized, (String)"certificateSerialized");
            try {
                x509CertificateHolder = new X509CertificateHolder(certificateSerialized);
            }
            catch (IOException _) {
                throw (Throwable)new CertificateException("Value should be a DER-encoded, X.509 v3 certificate");
            }
            X509CertificateHolder certificateHolder = x509CertificateHolder;
            return new Certificate(certificateHolder);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

