/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.ramf;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerDateTime;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerOctetString;
import com.beanit.jasn1.ber.types.string.BerVisibleString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.PrivateKey;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function7;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERVisibleString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.HashingAlgorithm;
import tech.relaycorp.relaynet.ramf.FieldSet;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.ramf.RAMFMessage;
import tech.relaycorp.relaynet.ramf.RAMFSerializerKt;
import tech.relaycorp.relaynet.wrappers.cms.SignatureVerification;
import tech.relaycorp.relaynet.wrappers.cms.SignedDataException;
import tech.relaycorp.relaynet.wrappers.cms.SignedDataKt;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005JW\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\f2<\u0010\r\u001a8\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0013\u0012\u0004\u0012\u0002H\n0\u000e\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001f"}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFSerializer;", "", "concreteMessageType", "", "concreteMessageVersion", "(BB)V", "getConcreteMessageType", "()B", "getConcreteMessageVersion", "deserialize", "T", "serialization", "", "messageClazz", "Lkotlin/Function7;", "", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "Ljava/time/ZonedDateTime;", "", "", "([BLkotlin/jvm/functions/Function7;)Ljava/lang/Object;", "deserializeFields", "Ltech/relaycorp/relaynet/ramf/FieldSet;", "serialize", "message", "Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "signerPrivateKey", "Ljava/security/PrivateKey;", "hashingAlgorithm", "Ltech/relaycorp/relaynet/HashingAlgorithm;", "serializeMessage", "relaynet"})
public final class RAMFSerializer {
    private final byte concreteMessageType;
    private final byte concreteMessageVersion;

    @NotNull
    public final byte[] serialize(@NotNull RAMFMessage message, @NotNull PrivateKey signerPrivateKey, @Nullable HashingAlgorithm hashingAlgorithm) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)signerPrivateKey, (String)"signerPrivateKey");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String string = "Relaynet";
        ByteArrayOutputStream byteArrayOutputStream = output;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byteArrayOutputStream.write(byArray2);
        output.write(this.concreteMessageType);
        output.write(this.concreteMessageVersion);
        byte[] fieldSetSerialized = this.serializeMessage(message);
        byte[] signedData = SignedDataKt.sign(fieldSetSerialized, signerPrivateKey, message.getSenderCertificate(), message.getSenderCertificateChain(), hashingAlgorithm);
        output.write(signedData);
        byte[] byArray3 = output.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"output.toByteArray()");
        return byArray3;
    }

    public static /* synthetic */ byte[] serialize$default(RAMFSerializer rAMFSerializer, RAMFMessage rAMFMessage, PrivateKey privateKey, HashingAlgorithm hashingAlgorithm, int n, Object object) {
        if ((n & 4) != 0) {
            hashingAlgorithm = null;
        }
        return rAMFSerializer.serialize(rAMFMessage, privateKey, hashingAlgorithm);
    }

    private final byte[] serializeMessage(RAMFMessage message) throws IOException {
        BigInteger bigInteger;
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(1000, true);
        int codeLength = 0;
        codeLength += new BerOctetString(message.getPayload()).encode((OutputStream)reverseOS, false);
        reverseOS.write(132);
        int n = message.getTtl();
        int n2 = ++codeLength;
        boolean bl = false;
        BigInteger bigInteger2 = BigInteger.valueOf(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2, (String)"BigInteger.valueOf(this.toLong())");
        BigInteger bigInteger3 = bigInteger = bigInteger2;
        codeLength = n2 + new BerInteger(bigInteger3).encode((OutputStream)reverseOS, false);
        reverseOS.write(131);
        ++codeLength;
        ZonedDateTime creationTimeUtc = message.getCreationTime().withZoneSameInstant(RAMFSerializerKt.access$getUTC_ZONE_ID$p());
        codeLength += new BerDateTime(creationTimeUtc.format(RAMFSerializerKt.access$getBER_DATETIME_FORMATTER$p())).encode((OutputStream)reverseOS, false);
        reverseOS.write(130);
        ++codeLength;
        codeLength += new BerVisibleString(message.getMessageId()).encode((OutputStream)reverseOS, false);
        reverseOS.write(129);
        ++codeLength;
        codeLength += new BerVisibleString(message.getRecipientAddress()).encode((OutputStream)reverseOS, false);
        reverseOS.write(128);
        BerLength.encodeLength((OutputStream)((OutputStream)reverseOS), (int)(++codeLength));
        RAMFSerializerKt.access$getDER_SEQUENCE_TAG$p().encode((OutputStream)reverseOS);
        byte[] byArray = reverseOS.getArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"reverseOS.array");
        return byArray;
    }

    public final <T> T deserialize(@NotNull byte[] serialization, @NotNull Function7<? super String, ? super byte[], ? super Certificate, ? super String, ? super ZonedDateTime, ? super Integer, ? super Set<Certificate>, ? extends T> messageClazz) throws RAMFException, SignedDataException {
        Intrinsics.checkParameterIsNotNull((Object)serialization, (String)"serialization");
        Intrinsics.checkParameterIsNotNull(messageClazz, (String)"messageClazz");
        ByteArrayInputStream serializationStream = new ByteArrayInputStream(serialization);
        int serializationSize = serializationStream.available();
        if (0x900000 < serializationSize) {
            throw (Throwable)new RAMFException("Message should not be larger than 9 MiB");
        }
        if (serializationSize < 10) {
            throw (Throwable)new RAMFException("Serialization is too short to contain format signature");
        }
        byte[] magicConstant = new byte[8];
        serializationStream.read(magicConstant, 0, magicConstant.length);
        byte[] byArray = magicConstant;
        Charset charset = Charset.forName("ASCII");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"ASCII\")");
        Charset charset2 = charset;
        boolean bl = false;
        boolean bl2 = false;
        if (Intrinsics.areEqual((Object)new String(byArray, charset2), (Object)"Relaynet") ^ true) {
            throw (Throwable)new RAMFException("Format signature should start with magic constant 'Relaynet'");
        }
        int messageType = serializationStream.read();
        if (messageType != this.concreteMessageType) {
            throw (Throwable)new RAMFException("Message type should be " + this.concreteMessageType + " (got " + messageType + ')');
        }
        int messageVersion = serializationStream.read();
        if (messageVersion != this.concreteMessageVersion) {
            throw (Throwable)new RAMFException("Message version should be " + this.concreteMessageVersion + " (got " + messageVersion + ')');
        }
        SignatureVerification cmsSignedDataResult = SignedDataKt.verifySignature(ByteStreamsKt.readBytes((InputStream)serializationStream));
        FieldSet fields = this.deserializeFields(cmsSignedDataResult.getPlaintext());
        return (T)messageClazz.invoke((Object)fields.getRecipientAddress(), (Object)fields.getPayload(), (Object)cmsSignedDataResult.getSignerCertificate(), (Object)fields.getMessageId(), (Object)fields.getCreationDate(), (Object)fields.getTtl(), cmsSignedDataResult.getAttachedCertificates());
    }

    private final FieldSet deserializeFields(byte[] serialization) throws RAMFException {
        LocalDateTime localDateTime;
        ASN1Sequence _2;
        ASN1Primitive aSN1Primitive;
        ASN1InputStream asn1InputStream = new ASN1InputStream(serialization);
        try {
            aSN1Primitive = asn1InputStream.readObject();
        }
        catch (IOException _2) {
            throw (Throwable)new RAMFException("Message fields are not a DER-encoded");
        }
        ASN1Primitive asn1Value = aSN1Primitive;
        try {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance((Object)asn1Value);
            Intrinsics.checkExpressionValueIsNotNull((Object)aSN1Sequence, (String)"ASN1Sequence.getInstance(asn1Value)");
            _2 = aSN1Sequence;
        }
        catch (IllegalArgumentException _3) {
            throw (Throwable)new RAMFException("Message fields are not a ASN.1 sequence");
        }
        ASN1Sequence fieldSequence = _2;
        ASN1Encodable[] fields = fieldSequence.toArray();
        if (fields.length != 5) {
            throw (Throwable)new RAMFException("Field sequence should contain 5 items (got " + fields.length + ')');
        }
        ASN1Encodable aSN1Encodable = fields[0];
        if (aSN1Encodable == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
        }
        DERVisibleString recipientAddress = DERVisibleString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable), (boolean)false);
        ASN1Encodable aSN1Encodable2 = fields[1];
        if (aSN1Encodable2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
        }
        DERVisibleString messageId = DERVisibleString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable2), (boolean)false);
        ASN1Encodable aSN1Encodable3 = fields[2];
        if (aSN1Encodable3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
        }
        DERVisibleString creationTimeDer = DERVisibleString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable3), (boolean)false);
        try {
            DERVisibleString dERVisibleString = creationTimeDer;
            Intrinsics.checkExpressionValueIsNotNull((Object)dERVisibleString, (String)"creationTimeDer");
            localDateTime = LocalDateTime.parse(dERVisibleString.getString(), RAMFSerializerKt.access$getBER_DATETIME_FORMATTER$p());
        }
        catch (DateTimeParseException _4) {
            throw (Throwable)new RAMFException("Creation time should be an ASN.1 DATE-TIME value");
        }
        LocalDateTime creationTime = localDateTime;
        ASN1Encodable aSN1Encodable4 = fields[3];
        if (aSN1Encodable4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
        }
        ASN1Integer ttlDer = ASN1Integer.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable4), (boolean)false);
        ASN1Encodable aSN1Encodable5 = fields[4];
        if (aSN1Encodable5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
        }
        ASN1OctetString payloadDer = DEROctetString.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable5), (boolean)false);
        DERVisibleString dERVisibleString = recipientAddress;
        Intrinsics.checkExpressionValueIsNotNull((Object)dERVisibleString, (String)"recipientAddress");
        String string = dERVisibleString.getString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"recipientAddress.string");
        DERVisibleString dERVisibleString2 = messageId;
        Intrinsics.checkExpressionValueIsNotNull((Object)dERVisibleString2, (String)"messageId");
        String string2 = dERVisibleString2.getString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"messageId.string");
        ZonedDateTime zonedDateTime = ZonedDateTime.of(creationTime, RAMFSerializerKt.access$getUTC_ZONE_ID$p());
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"ZonedDateTime.of(creationTime, UTC_ZONE_ID)");
        int n = ttlDer.intPositiveValueExact();
        ASN1OctetString aSN1OctetString = payloadDer;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSN1OctetString, (String)"payloadDer");
        byte[] byArray = aSN1OctetString.getOctets();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"payloadDer.octets");
        return new FieldSet(string, string2, zonedDateTime, n, byArray);
    }

    public final byte getConcreteMessageType() {
        return this.concreteMessageType;
    }

    public final byte getConcreteMessageVersion() {
        return this.concreteMessageVersion;
    }

    public RAMFSerializer(byte concreteMessageType, byte concreteMessageVersion) {
        this.concreteMessageType = concreteMessageType;
        this.concreteMessageVersion = concreteMessageVersion;
    }
}

