/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.ramf;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerDateTime;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerOctetString;
import com.beanit.jasn1.ber.types.string.BerVisibleString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.ramf.RAMFException;
import tech.relaycorp.relaynet.ramf.RAMFMessageKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0011\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u001b\u001a\u00020\rJ\b\u0010\u001c\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFMessage;", "", "concreteMessageType", "", "concreteMessageVersion", "recipientAddress", "", "messageId", "creationTime", "Ljava/time/ZonedDateTime;", "ttl", "", "payload", "", "(BBLjava/lang/String;Ljava/lang/String;Ljava/time/ZonedDateTime;I[B)V", "getConcreteMessageType", "()B", "getConcreteMessageVersion", "getCreationTime", "()Ljava/time/ZonedDateTime;", "getMessageId", "()Ljava/lang/String;", "getPayload", "()[B", "getRecipientAddress", "getTtl", "()I", "serialize", "serializeFields", "Companion", "relaynet"})
public final class RAMFMessage {
    private final byte concreteMessageType;
    private final byte concreteMessageVersion;
    @NotNull
    private final String recipientAddress;
    @NotNull
    private final String messageId;
    @NotNull
    private final ZonedDateTime creationTime;
    private final int ttl;
    @NotNull
    private final byte[] payload;
    private static final BerTag tag;
    public static final Companion Companion;

    @NotNull
    public final byte[] serialize() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        String string = "Relaynet";
        ByteArrayOutputStream byteArrayOutputStream = output;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byteArrayOutputStream.write(byArray2);
        output.write(this.concreteMessageType);
        output.write(this.concreteMessageVersion);
        output.write(this.serializeFields());
        byte[] byArray3 = output.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"output.toByteArray()");
        return byArray3;
    }

    private final byte[] serializeFields() throws IOException {
        BigInteger bigInteger;
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(1000, true);
        int codeLength = 0;
        codeLength += new BerOctetString(this.payload).encode((OutputStream)reverseOS, false);
        reverseOS.write(132);
        int n = this.ttl;
        int n2 = ++codeLength;
        boolean bl = false;
        BigInteger bigInteger2 = BigInteger.valueOf(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger2, (String)"BigInteger.valueOf(this.toLong())");
        BigInteger bigInteger3 = bigInteger = bigInteger2;
        codeLength = n2 + new BerInteger(bigInteger3).encode((OutputStream)reverseOS, false);
        reverseOS.write(131);
        ++codeLength;
        ZonedDateTime creationTimeUtc = this.creationTime.withZoneSameInstant(ZoneId.of("UTC"));
        codeLength += new BerDateTime(creationTimeUtc.format(RAMFMessageKt.getBerDateTimeFormatter())).encode((OutputStream)reverseOS, false);
        reverseOS.write(130);
        ++codeLength;
        codeLength += new BerVisibleString(this.messageId).encode((OutputStream)reverseOS, false);
        reverseOS.write(129);
        ++codeLength;
        codeLength += new BerVisibleString(this.recipientAddress).encode((OutputStream)reverseOS, false);
        reverseOS.write(128);
        BerLength.encodeLength((OutputStream)((OutputStream)reverseOS), (int)(++codeLength));
        tag.encode((OutputStream)reverseOS);
        reverseOS.flush();
        byte[] byArray = reverseOS.getArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"reverseOS.array");
        return byArray;
    }

    public final byte getConcreteMessageType() {
        return this.concreteMessageType;
    }

    public final byte getConcreteMessageVersion() {
        return this.concreteMessageVersion;
    }

    @NotNull
    public final String getRecipientAddress() {
        return this.recipientAddress;
    }

    @NotNull
    public final String getMessageId() {
        return this.messageId;
    }

    @NotNull
    public final ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    public final int getTtl() {
        return this.ttl;
    }

    @NotNull
    public final byte[] getPayload() {
        return this.payload;
    }

    public RAMFMessage(byte concreteMessageType, byte concreteMessageVersion, @NotNull String recipientAddress, @NotNull String messageId, @NotNull ZonedDateTime creationTime, int ttl, @NotNull byte[] payload) {
        Intrinsics.checkParameterIsNotNull((Object)recipientAddress, (String)"recipientAddress");
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        Intrinsics.checkParameterIsNotNull((Object)creationTime, (String)"creationTime");
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        this.concreteMessageType = concreteMessageType;
        this.concreteMessageVersion = concreteMessageVersion;
        this.recipientAddress = recipientAddress;
        this.messageId = messageId;
        this.creationTime = creationTime;
        this.ttl = ttl;
        this.payload = payload;
        if (1023 < this.recipientAddress.length()) {
            throw (Throwable)new RAMFException("Recipient address cannot span more than 1023 octets (got " + this.recipientAddress.length() + ')');
        }
        if (255 < this.messageId.length()) {
            throw (Throwable)new RAMFException("Message id cannot span more than 255 octets (got " + this.messageId.length() + ')');
        }
        if (this.ttl < 0) {
            throw (Throwable)new RAMFException("TTL cannot be negative (got " + this.ttl + ')');
        }
        if (15552000 < this.ttl) {
            throw (Throwable)new RAMFException("TTL cannot be greater than 15552000 (got " + this.ttl + ')');
        }
        if (0x800000 < this.payload.length) {
            throw (Throwable)new RAMFException("Payload cannot span more than 8388608 octets (got " + this.payload.length + ')');
        }
    }

    static {
        Companion = new Companion(null);
        tag = new BerTag(0, 32, 16);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltech/relaycorp/relaynet/ramf/RAMFMessage$Companion;", "", "()V", "tag", "Lcom/beanit/jasn1/ber/BerTag;", "relaynet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

