/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.ECDHCurve;
import tech.relaycorp.relaynet.wrappers.KeyException;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0001\u001a\n\u0010\f\u001a\u00020\n*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\n*\u00020\r\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\r\u001a\n\u0010\u0014\u001a\u00020\u0013*\u00020\r\u001a\u0014\u0010\u0015\u001a\u00020\u0013*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\n2\b\b\u0002\u0010\u0017\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\" \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\u0018\u001a\u00020\u0006*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0015\u0010\u0018\u001a\u00020\u0006*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001b\u00a8\u0006\u001c"}, d2={"DEFAULT_RSA_KEY_MODULUS", "", "MIN_RSA_KEY_MODULUS", "ECDH_CURVE_MAP", "", "Ltech/relaycorp/relaynet/ECDHCurve;", "", "getECDH_CURVE_MAP", "()Ljava/util/Map;", "generateRSAKeyPair", "Ljava/security/KeyPair;", "modulus", "deserializeRSAKeyPair", "", "deserializeECKeyPair", "deserializePrivateKey", "Ljava/security/PrivateKey;", "algorithm", "deserializeRSAPublicKey", "Ljava/security/PublicKey;", "deserializeECPublicKey", "deserializePublicKey", "generateECDHKeyPair", "curve", "nodeId", "getNodeId", "(Ljava/security/PublicKey;)Ljava/lang/String;", "(Ljava/security/PrivateKey;)Ljava/lang/String;", "awala"})
@JvmName(name="Keys")
public final class Keys {
    private static final int DEFAULT_RSA_KEY_MODULUS = 2048;
    private static final int MIN_RSA_KEY_MODULUS = 2048;
    @NotNull
    private static final Map<ECDHCurve, String> ECDH_CURVE_MAP;

    @NotNull
    public static final Map<ECDHCurve, String> getECDH_CURVE_MAP() {
        return ECDH_CURVE_MAP;
    }

    @NotNull
    public static final KeyPair generateRSAKeyPair(int modulus) throws KeyException {
        if (modulus < 2048) {
            throw new KeyException("Modulus should be at least 2048 (got " + modulus + ")", null, 2, null);
        }
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", (Provider)CryptoUtils.getBC_PROVIDER());
        keyGen.initialize(modulus);
        KeyPair keyPair = keyGen.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(...)");
        return keyPair;
    }

    public static /* synthetic */ KeyPair generateRSAKeyPair$default(int n, int n2, Object object) throws KeyException {
        if ((n2 & 1) != 0) {
            n = 2048;
        }
        return Keys.generateRSAKeyPair(n);
    }

    @NotNull
    public static final KeyPair deserializeRSAKeyPair(@NotNull byte[] $this$deserializeRSAKeyPair) throws KeyException {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeRSAKeyPair, (String)"<this>");
        PrivateKey privateKey = Keys.deserializePrivateKey($this$deserializeRSAKeyPair, "RSA");
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPrivateCrtKey");
        RSAPrivateCrtKey privateKey2 = (RSAPrivateCrtKey)privateKey;
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", (Provider)CryptoUtils.getBC_PROVIDER());
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privateKey2.getModulus(), privateKey2.getPublicExponent());
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        return new KeyPair(publicKey, privateKey2);
    }

    @NotNull
    public static final KeyPair deserializeECKeyPair(@NotNull byte[] $this$deserializeECKeyPair) throws KeyException {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeECKeyPair, (String)"<this>");
        PrivateKey privateKey = Keys.deserializePrivateKey($this$deserializeECKeyPair, "EC");
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey");
        BCECPrivateKey privateKey2 = (BCECPrivateKey)privateKey;
        KeyFactory keyFactory = KeyFactory.getInstance("EC", (Provider)CryptoUtils.getBC_PROVIDER());
        ECPoint curvePublicPoint = privateKey2.getParameters().getG().multiply(privateKey2.getD());
        ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(curvePublicPoint, privateKey2.getParameters());
        PublicKey publicKey = keyFactory.generatePublic((KeySpec)publicKeySpec);
        return new KeyPair(publicKey, (PrivateKey)privateKey2);
    }

    private static final PrivateKey deserializePrivateKey(byte[] $this$deserializePrivateKey, String algorithm) {
        PrivateKey privateKey;
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec($this$deserializePrivateKey);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm, (Provider)CryptoUtils.getBC_PROVIDER());
        try {
            privateKey = keyFactory.generatePrivate(privateKeySpec);
            Intrinsics.checkNotNull((Object)privateKey);
        }
        catch (InvalidKeySpecException exc) {
            throw new KeyException("Value is not a valid " + algorithm + " private key", exc);
        }
        return privateKey;
    }

    @NotNull
    public static final PublicKey deserializeRSAPublicKey(@NotNull byte[] $this$deserializeRSAPublicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeRSAPublicKey, (String)"<this>");
        return Keys.deserializePublicKey($this$deserializeRSAPublicKey, "RSA");
    }

    @NotNull
    public static final PublicKey deserializeECPublicKey(@NotNull byte[] $this$deserializeECPublicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$deserializeECPublicKey, (String)"<this>");
        return Keys.deserializePublicKey($this$deserializeECPublicKey, "EC");
    }

    private static final PublicKey deserializePublicKey(byte[] $this$deserializePublicKey, String algorithm) {
        PublicKey publicKey;
        X509EncodedKeySpec spec = new X509EncodedKeySpec($this$deserializePublicKey);
        KeyFactory factory = KeyFactory.getInstance(algorithm, (Provider)CryptoUtils.getBC_PROVIDER());
        try {
            publicKey = factory.generatePublic(spec);
            Intrinsics.checkNotNull((Object)publicKey);
        }
        catch (InvalidKeySpecException exc) {
            throw new KeyException("Value is not a valid " + algorithm + " public key", exc);
        }
        return publicKey;
    }

    @NotNull
    public static final KeyPair generateECDHKeyPair(@NotNull ECDHCurve curve) {
        Intrinsics.checkNotNullParameter((Object)((Object)curve), (String)"curve");
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC", (Provider)CryptoUtils.getBC_PROVIDER());
        ECGenParameterSpec ecSpec = new ECGenParameterSpec(ECDH_CURVE_MAP.get((Object)curve));
        keyGen.initialize(ecSpec);
        KeyPair keyPair = keyGen.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(...)");
        return keyPair;
    }

    public static /* synthetic */ KeyPair generateECDHKeyPair$default(ECDHCurve eCDHCurve, int n, Object object) {
        if ((n & 1) != 0) {
            eCDHCurve = ECDHCurve.P256;
        }
        return Keys.generateECDHKeyPair(eCDHCurve);
    }

    @NotNull
    public static final String getNodeId(@NotNull PublicKey $this$nodeId) {
        Intrinsics.checkNotNullParameter((Object)$this$nodeId, (String)"<this>");
        byte[] byArray = $this$nodeId.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return "0" + CryptoUtils.getSHA256DigestHex(byArray);
    }

    @NotNull
    public static final String getNodeId(@NotNull PrivateKey $this$nodeId) {
        Intrinsics.checkNotNullParameter((Object)$this$nodeId, (String)"<this>");
        RSAPrivateCrtKey rsaPrivateKey = (RSAPrivateCrtKey)$this$nodeId;
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", (Provider)CryptoUtils.getBC_PROVIDER());
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent());
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        Intrinsics.checkNotNull((Object)publicKey);
        return Keys.getNodeId(publicKey);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)ECDHCurve.P256), (Object)"P-256"), TuplesKt.to((Object)((Object)ECDHCurve.P384), (Object)"P-384"), TuplesKt.to((Object)((Object)ECDHCurve.P521), (Object)"P-521")};
        ECDH_CURVE_MAP = MapsKt.mapOf((Pair[])pairArray);
    }
}

