/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.pki;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.pki.CertificationPathException;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Utils;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Ltech/relaycorp/relaynet/pki/CertificationPath;", "", "leafCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "certificateAuthorities", "", "<init>", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;Ljava/util/List;)V", "getLeafCertificate", "()Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "getCertificateAuthorities", "()Ljava/util/List;", "validate", "", "encode", "Lorg/bouncycastle/asn1/DERSequence;", "encode$awala", "serialize", "", "Companion", "awala"})
@SourceDebugExtension(value={"SMAP\nCertificationPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1563#2:107\n1634#2,3:108\n*S KotlinDebug\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath\n*L\n36#1:107\n36#1:108,3\n*E\n"})
public final class CertificationPath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final tech.relaycorp.relaynet.wrappers.x509.Certificate leafCertificate;
    @NotNull
    private final List<tech.relaycorp.relaynet.wrappers.x509.Certificate> certificateAuthorities;

    public CertificationPath(@NotNull tech.relaycorp.relaynet.wrappers.x509.Certificate leafCertificate, @NotNull List<tech.relaycorp.relaynet.wrappers.x509.Certificate> certificateAuthorities) {
        Intrinsics.checkNotNullParameter((Object)leafCertificate, (String)"leafCertificate");
        Intrinsics.checkNotNullParameter(certificateAuthorities, (String)"certificateAuthorities");
        this.leafCertificate = leafCertificate;
        this.certificateAuthorities = certificateAuthorities;
    }

    @NotNull
    public final tech.relaycorp.relaynet.wrappers.x509.Certificate getLeafCertificate() {
        return this.leafCertificate;
    }

    @NotNull
    public final List<tech.relaycorp.relaynet.wrappers.x509.Certificate> getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public final void validate() throws CertificationPathException {
        if (this.certificateAuthorities.isEmpty()) {
            throw new CertificationPathException("There are no CAs", null, 2, null);
        }
        tech.relaycorp.relaynet.wrappers.x509.Certificate rootCA = (tech.relaycorp.relaynet.wrappers.x509.Certificate)CollectionsKt.last(this.certificateAuthorities);
        List<tech.relaycorp.relaynet.wrappers.x509.Certificate> intermediateCAs = this.certificateAuthorities.subList(0, this.certificateAuthorities.size());
        try {
            this.leafCertificate.getCertificationPath((Collection<tech.relaycorp.relaynet.wrappers.x509.Certificate>)intermediateCAs, CollectionsKt.listOf((Object)rootCA));
        }
        catch (CertificateException exc) {
            throw new CertificationPathException("Certification path is invalid", exc);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DERSequence encode$awala() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Certificate leafCertificateASN1 = this.leafCertificate.encode$awala();
        Object[] objectArray = (Object[])this.certificateAuthorities;
        ASN1Utils aSN1Utils = ASN1Utils.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            tech.relaycorp.relaynet.wrappers.x509.Certificate certificate = (tech.relaycorp.relaynet.wrappers.x509.Certificate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.encode$awala());
        }
        DERSequence casASN1 = aSN1Utils.makeSequence((List)destination$iv$iv, true);
        objectArray = new ASN1Object[]{leafCertificateASN1, casASN1};
        return ASN1Utils.INSTANCE.makeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    @NotNull
    public final byte[] serialize() {
        DERSequence sequence = this.encode$awala();
        byte[] byArray = sequence.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0015\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/pki/CertificationPath$Companion;", "", "<init>", "()V", "deserialize", "Ltech/relaycorp/relaynet/pki/CertificationPath;", "serialization", "", "decode", "encoding", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "decode$awala", "sequence", "Lorg/bouncycastle/asn1/ASN1Sequence;", "awala"})
    @SourceDebugExtension(value={"SMAP\nCertificationPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1563#2:107\n1634#2,3:108\n1563#2:111\n1634#2,3:112\n*S KotlinDebug\n*F\n+ 1 CertificationPath.kt\ntech/relaycorp/relaynet/pki/CertificationPath$Companion\n*L\n96#1:107\n96#1:108,3\n97#1:111\n97#1:112,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CertificationPath deserialize(@NotNull byte[] serialization) throws CertificationPathException {
            ASN1Sequence aSN1Sequence;
            Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
            try {
                aSN1Sequence = ASN1Utils.INSTANCE.deserializeSequence(serialization);
            }
            catch (ASN1Exception exc) {
                throw new CertificationPathException("Path is not a valid DER sequence", exc);
            }
            ASN1Sequence sequence = aSN1Sequence;
            return this.decode(sequence);
        }

        @NotNull
        public final CertificationPath decode$awala(@NotNull ASN1TaggedObject encoding) throws CertificationPathException {
            ASN1Sequence aSN1Sequence;
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            try {
                aSN1Sequence = DERSequence.getInstance((ASN1TaggedObject)encoding, (boolean)false);
            }
            catch (IllegalStateException exc) {
                throw new CertificationPathException("Serialisation is not an implicitly-tagged sequence", exc);
            }
            ASN1Sequence sequence = aSN1Sequence;
            Intrinsics.checkNotNull((Object)sequence);
            return this.decode(sequence);
        }

        private final CertificationPath decode(ASN1Sequence sequence) throws CertificationPathException {
            List list;
            ASN1Sequence aSN1Sequence;
            Certificate certificate;
            if (sequence.size() < 2) {
                throw new CertificationPathException("Path sequence should have at least 2 items", null, 2, null);
            }
            try {
                ASN1Encodable aSN1Encodable = sequence.getObjectAt(0);
                Intrinsics.checkNotNull((Object)aSN1Encodable, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
                certificate = Certificate.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable), (boolean)false);
            }
            catch (IllegalStateException exc) {
                throw new CertificationPathException("Leaf certificate is malformed", exc);
            }
            Certificate leafCertificateASN1 = certificate;
            tech.relaycorp.relaynet.wrappers.x509.Certificate leafCertificate = new tech.relaycorp.relaynet.wrappers.x509.Certificate(new X509CertificateHolder(leafCertificateASN1));
            try {
                ASN1Encodable aSN1Encodable = sequence.getObjectAt(1);
                Intrinsics.checkNotNull((Object)aSN1Encodable, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
                aSN1Sequence = DERSequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable), (boolean)false);
            }
            catch (IllegalStateException exc) {
                throw new CertificationPathException("Chain is malformed", exc);
            }
            ASN1Sequence casSequence = aSN1Sequence;
            try {
                Certificate it;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Intrinsics.checkNotNull((Object)casSequence);
                Iterable exc = CollectionsKt.toList((Iterable)((Iterable)casSequence));
                boolean $i$f$map = false;
                void var8_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Certificate.getInstance((Object)it));
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Certificate)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new tech.relaycorp.relaynet.wrappers.x509.Certificate(new X509CertificateHolder(it)));
                }
                list = (List)destination$iv$iv;
            }
            catch (IllegalArgumentException exc) {
                throw new CertificationPathException("Chain contains malformed certificate", exc);
            }
            List certificateAuthorities = list;
            return new CertificationPath(leafCertificate, certificateAuthorities);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

