/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.crypto;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Ltech/relaycorp/relaynet/crypto/RSASigning;", "", "<init>", "()V", "sign", "", "plaintext", "privateKey", "Ljava/security/PrivateKey;", "verify", "", "ciphertext", "publicKey", "Ljava/security/PublicKey;", "expectedPlaintext", "makeSignature", "Ljava/security/Signature;", "kotlin.jvm.PlatformType", "awala"})
public final class RSASigning {
    @NotNull
    public static final RSASigning INSTANCE = new RSASigning();

    private RSASigning() {
    }

    @NotNull
    public final byte[] sign(@NotNull byte[] plaintext, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Signature signature = this.makeSignature();
        signature.initSign(privateKey);
        signature.update(plaintext);
        byte[] byArray = signature.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sign(...)");
        return byArray;
    }

    public final boolean verify(@NotNull byte[] ciphertext, @NotNull PublicKey publicKey, @NotNull byte[] expectedPlaintext) {
        Intrinsics.checkNotNullParameter((Object)ciphertext, (String)"ciphertext");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)expectedPlaintext, (String)"expectedPlaintext");
        Signature signature = this.makeSignature();
        signature.initVerify(publicKey);
        signature.update(expectedPlaintext);
        return signature.verify(ciphertext);
    }

    private final Signature makeSignature() {
        return Signature.getInstance("SHA256withRSAandMGF1", (Provider)CryptoUtils.getBC_PROVIDER());
    }
}

