/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.asn1;

import java.io.IOException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1VisibleString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.wrappers.asn1.ASN1Exception;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J(\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\n\b\u0000\u0010\u0016\u0018\u0001*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0010H\u0086\b\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00152\u0006\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0019J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006("}, d2={"Ltech/relaycorp/relaynet/wrappers/asn1/ASN1Utils;", "", "<init>", "()V", "BER_DATETIME_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getBER_DATETIME_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "makeSequence", "Lorg/bouncycastle/asn1/DERSequence;", "items", "", "Lorg/bouncycastle/asn1/ASN1Encodable;", "explicitTagging", "", "serializeSequence", "", "deserializeSequence", "Lorg/bouncycastle/asn1/ASN1Sequence;", "serialization", "deserializeHomogeneousSequence", "", "T", "([B)[Lorg/bouncycastle/asn1/ASN1Encodable;", "deserializeHeterogeneousSequence", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "([B)[Lorg/bouncycastle/asn1/ASN1TaggedObject;", "derEncodeUTCDate", "Lorg/bouncycastle/asn1/DERGeneralizedTime;", "date", "Ljava/time/ZonedDateTime;", "getOID", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "oidSerialized", "getVisibleString", "Lorg/bouncycastle/asn1/ASN1VisibleString;", "visibleString", "getOctetString", "Lorg/bouncycastle/asn1/ASN1OctetString;", "octetString", "awala"})
@SourceDebugExtension(value={"SMAP\nASN1Utils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ASN1Utils.kt\ntech/relaycorp/relaynet/wrappers/asn1/ASN1Utils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,108:1\n71#1,2:124\n73#1,8:129\n81#1:138\n1573#2:109\n1604#2,4:110\n1869#2,2:114\n1563#2:116\n1634#2,3:117\n1563#2:126\n1634#2,2:127\n1636#2:137\n37#3:120\n36#3,3:121\n37#3:139\n36#3,3:140\n*S KotlinDebug\n*F\n+ 1 ASN1Utils.kt\ntech/relaycorp/relaynet/wrappers/asn1/ASN1Utils\n*L\n86#1:124,2\n86#1:129,8\n86#1:138\n33#1:109\n33#1:110,4\n37#1:114,2\n72#1:116\n72#1:117,3\n86#1:126\n86#1:127,2\n86#1:137\n81#1:120\n81#1:121,3\n86#1:139\n86#1:140,3\n*E\n"})
public final class ASN1Utils {
    @NotNull
    public static final ASN1Utils INSTANCE = new ASN1Utils();
    @NotNull
    private static final DateTimeFormatter BER_DATETIME_FORMATTER;

    private ASN1Utils() {
    }

    @NotNull
    public final DateTimeFormatter getBER_DATETIME_FORMATTER() {
        return BER_DATETIME_FORMATTER;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DERSequence makeSequence(@NotNull List<? extends ASN1Encodable> items, boolean explicitTagging) {
        List list;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ASN1EncodableVector messagesVector = new ASN1EncodableVector(items.size());
        if (explicitTagging) {
            list = items;
        } else {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = items;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void item;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new DERTaggedObject(false, (int)index, (ASN1Encodable)item));
            }
            list = (List)destination$iv$iv;
        }
        List finalItems = list;
        Iterable $this$forEach$iv = finalItems;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASN1Encodable it = (ASN1Encodable)element$iv;
            boolean bl = false;
            messagesVector.add(it);
        }
        return new DERSequence(messagesVector);
    }

    public static /* synthetic */ DERSequence makeSequence$default(ASN1Utils aSN1Utils, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return aSN1Utils.makeSequence(list, bl);
    }

    @NotNull
    public final byte[] serializeSequence(@NotNull List<? extends ASN1Encodable> items, boolean explicitTagging) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        byte[] byArray = this.makeSequence(items, explicitTagging).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    public static /* synthetic */ byte[] serializeSequence$default(ASN1Utils aSN1Utils, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return aSN1Utils.serializeSequence(list, bl);
    }

    @NotNull
    public final ASN1Sequence deserializeSequence(@NotNull byte[] serialization) throws ASN1Exception {
        ASN1Primitive aSN1Primitive;
        Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
        if (serialization.length == 0) {
            throw new ASN1Exception("Value is empty", null, 2, null);
        }
        ASN1InputStream asn1InputStream = new ASN1InputStream(serialization);
        try {
            aSN1Primitive = asn1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new ASN1Exception("Value is not DER-encoded", null, 2, null);
        }
        ASN1Primitive asn1Value = aSN1Primitive;
        try {
            aSN1Primitive = ASN1Sequence.getInstance((Object)asn1Value);
            Intrinsics.checkNotNull((Object)aSN1Primitive);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("Value is not an ASN.1 sequence", null, 2, null);
        }
        return aSN1Primitive;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T extends ASN1Encodable> T[] deserializeHomogeneousSequence(byte[] serialization) throws ASN1Exception {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
        boolean $i$f$deserializeHomogeneousSequence = false;
        ASN1Sequence sequence = this.deserializeSequence(serialization);
        Iterable $this$map$iv = (Iterable)sequence;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(it instanceof ASN1Encodable)) {
                throw new ASN1Exception("Sequence contains an item of an unexpected type (" + it.getClass().getSimpleName() + ")", null, 2, null);
            }
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            collection.add((ASN1Encodable)it);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = (Collection)$this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        return (ASN1Encodable[])thisCollection$iv.toArray(new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ASN1TaggedObject[] deserializeHeterogeneousSequence(@NotNull byte[] serialization) throws ASN1Exception {
        void $this$toTypedArray$iv$iv;
        void $this$mapTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)serialization, (String)"serialization");
        ASN1Utils this_$iv = this;
        boolean $i$f$deserializeHomogeneousSequence = false;
        ASN1Sequence sequence$iv = this_$iv.deserializeSequence(serialization);
        Iterable $this$map$iv$iv = (Iterable)sequence$iv;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl = false;
            if (!(it$iv instanceof ASN1TaggedObject)) {
                throw new ASN1Exception("Sequence contains an item of an unexpected type (" + it$iv.getClass().getSimpleName() + ")", null, 2, null);
            }
            collection.add((ASN1Encodable)((ASN1TaggedObject)it$iv));
        }
        $this$map$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
        return (ASN1TaggedObject[])((ASN1Encodable[])thisCollection$iv$iv.toArray(new ASN1TaggedObject[0]));
    }

    @NotNull
    public final DERGeneralizedTime derEncodeUTCDate(@NotNull ZonedDateTime date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        ZonedDateTime dateUTC = date.withZoneSameInstant(ZoneOffset.UTC);
        return new DERGeneralizedTime(dateUTC.format(BER_DATETIME_FORMATTER));
    }

    @NotNull
    public final ASN1ObjectIdentifier getOID(@NotNull ASN1TaggedObject oidSerialized) throws ASN1Exception {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        Intrinsics.checkNotNullParameter((Object)oidSerialized, (String)"oidSerialized");
        try {
            aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((ASN1TaggedObject)oidSerialized, (boolean)false);
            Intrinsics.checkNotNull((Object)aSN1ObjectIdentifier);
        }
        catch (IllegalArgumentException exc) {
            throw new ASN1Exception("Value is not an OID", exc);
        }
        return aSN1ObjectIdentifier;
    }

    @NotNull
    public final ASN1VisibleString getVisibleString(@NotNull ASN1TaggedObject visibleString) {
        Intrinsics.checkNotNullParameter((Object)visibleString, (String)"visibleString");
        ASN1VisibleString aSN1VisibleString = ASN1VisibleString.getInstance((ASN1TaggedObject)visibleString, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)aSN1VisibleString, (String)"getInstance(...)");
        return aSN1VisibleString;
    }

    @NotNull
    public final ASN1OctetString getOctetString(@NotNull ASN1TaggedObject octetString) {
        Intrinsics.checkNotNullParameter((Object)octetString, (String)"octetString");
        ASN1OctetString aSN1OctetString = DEROctetString.getInstance((ASN1TaggedObject)octetString, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)aSN1OctetString, (String)"getInstance(...)");
        return aSN1OctetString;
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        BER_DATETIME_FORMATTER = dateTimeFormatter;
    }
}

