/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet;

import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\"\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"getSHA256Digest", "", "input", "getSHA256DigestHex", "", "BC_PROVIDER", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "getBC_PROVIDER", "()Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "awala"})
@JvmName(name="CryptoUtils")
public final class CryptoUtils {
    @NotNull
    private static final BouncyCastleProvider BC_PROVIDER = new BouncyCastleProvider();

    @NotNull
    public static final byte[] getSHA256Digest(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] byArray = digest.digest(input);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public static final String getSHA256DigestHex(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return ArraysKt.joinToString$default((byte[])CryptoUtils.getSHA256Digest(input), (CharSequence)"", null, null, (int)0, null, CryptoUtils::getSHA256DigestHex$lambda$0, (int)30, null);
    }

    @NotNull
    public static final BouncyCastleProvider getBC_PROVIDER() {
        return BC_PROVIDER;
    }

    private static final CharSequence getSHA256DigestHex$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

