/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.x509;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.IntRange;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.wrappers.PRNGKt;
import tech.relaycorp.relaynet.wrappers.x509.BasicConstraintsExtension;
import tech.relaycorp.relaynet.wrappers.x509.CertificateException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 E2\u00020\u0001:\u0001EB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010%\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010'\u001a\u00020(H\u0016J\u0006\u0010)\u001a\u00020*J\r\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\u000e\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u000201J\b\u00102\u001a\u000201H\u0002J\b\u00103\u001a\u000201H\u0002J-\u00104\u001a\b\u0012\u0004\u0012\u00020\u0000052\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0000072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000007\u00a2\u0006\u0002\u00109J$\u0010:\u001a\u00020;2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0000072\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000007H\u0002J\u001d\u0010<\u001a\n >*\u0004\u0018\u00010=0=2\u0006\u0010?\u001a\u00020\u0000H\u0002\u00a2\u0006\u0002\u0010@J\u001d\u0010A\u001a\n >*\u0004\u0018\u00010\u00150\u00152\u0006\u0010B\u001a\u00020CH\u0002\u00a2\u0006\u0002\u0010DR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010 \u001a\u00020!8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u001f\u001a\u0004\b\"\u0010#\u00a8\u0006F"}, d2={"Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "", "certificateHolder", "Lorg/bouncycastle/cert/X509CertificateHolder;", "<init>", "(Lorg/bouncycastle/cert/X509CertificateHolder;)V", "getCertificateHolder$awala", "()Lorg/bouncycastle/cert/X509CertificateHolder;", "commonName", "", "getCommonName", "()Ljava/lang/String;", "subjectPublicKey", "Ljava/security/PublicKey;", "getSubjectPublicKey", "()Ljava/security/PublicKey;", "subjectId", "getSubjectId", "issuerCommonName", "getIssuerCommonName", "startDate", "Ljava/time/ZonedDateTime;", "getStartDate", "()Ljava/time/ZonedDateTime;", "expiryDate", "getExpiryDate", "basicConstraints", "Lorg/bouncycastle/asn1/x509/BasicConstraints;", "getBasicConstraints", "()Lorg/bouncycastle/asn1/x509/BasicConstraints;", "basicConstraints$delegate", "Lkotlin/Lazy;", "isCA", "", "isCA$awala", "()Z", "isCA$delegate", "equals", "other", "hashCode", "", "serialize", "", "encode", "Lorg/bouncycastle/asn1/x509/Certificate;", "encode$awala", "isLikelyIssuer", "potentialIssuer", "validate", "", "validateValidityPeriod", "validateCommonNamePresence", "getCertificationPath", "", "intermediateCAs", "", "trustedCAs", "(Ljava/util/Collection;Ljava/util/Collection;)[Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "buildPath", "Ljava/security/cert/PKIXCertPathBuilderResult;", "convertCertToJava", "Ljava/security/cert/X509Certificate;", "kotlin.jvm.PlatformType", "certificate", "(Ltech/relaycorp/relaynet/wrappers/x509/Certificate;)Ljava/security/cert/X509Certificate;", "dateToZonedDateTime", "date", "Ljava/util/Date;", "(Ljava/util/Date;)Ljava/time/ZonedDateTime;", "Companion", "awala"})
@SourceDebugExtension(value={"SMAP\nCertificate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Certificate.kt\ntech/relaycorp/relaynet/wrappers/x509/Certificate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,362:1\n1557#2:363\n1628#2,3:364\n1557#2:367\n1628#2,2:368\n626#2,12:370\n1630#2:382\n626#2,12:383\n1557#2:399\n1628#2,3:400\n1557#2:403\n1628#2,3:404\n1557#2:407\n1628#2,3:408\n37#3:395\n36#3,3:396\n*S KotlinDebug\n*F\n+ 1 Certificate.kt\ntech/relaycorp/relaynet/wrappers/x509/Certificate\n*L\n286#1:363\n286#1:364,3\n294#1:367\n294#1:368,2\n295#1:370,12\n294#1:382\n301#1:383,12\n317#1:399\n317#1:400,3\n318#1:403\n318#1:404,3\n320#1:407\n320#1:408,3\n305#1:395\n305#1:396,3\n*E\n"})
public final class Certificate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final X509CertificateHolder certificateHolder;
    @NotNull
    private final Lazy basicConstraints$delegate;
    @NotNull
    private final Lazy isCA$delegate;
    @NotNull
    private static final JcaX509CertificateConverter bcToJavaCertificateConverter;

    public Certificate(@NotNull X509CertificateHolder certificateHolder) {
        Intrinsics.checkNotNullParameter((Object)certificateHolder, (String)"certificateHolder");
        this.certificateHolder = certificateHolder;
        this.basicConstraints$delegate = LazyKt.lazy(() -> Certificate.basicConstraints_delegate$lambda$0(this));
        this.isCA$delegate = LazyKt.lazy(() -> Certificate.isCA_delegate$lambda$1(this));
    }

    @NotNull
    public final X509CertificateHolder getCertificateHolder$awala() {
        return this.certificateHolder;
    }

    @NotNull
    public final String getCommonName() {
        X500Name x500Name = this.certificateHolder.getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)x500Name, (String)"getSubject(...)");
        return Certificate.Companion.getCommonName(x500Name);
    }

    @NotNull
    public final PublicKey getSubjectPublicKey() {
        PublicKey publicKey = this.convertCertToJava(this).getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"getPublicKey(...)");
        return publicKey;
    }

    @NotNull
    public final String getSubjectId() {
        byte[] byArray = this.certificateHolder.getSubjectPublicKeyInfo().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return "0" + CryptoUtils.getSHA256DigestHex(byArray);
    }

    @NotNull
    public final String getIssuerCommonName() {
        X500Name x500Name = this.certificateHolder.getIssuer();
        Intrinsics.checkNotNullExpressionValue((Object)x500Name, (String)"getIssuer(...)");
        return Certificate.Companion.getCommonName(x500Name);
    }

    @NotNull
    public final ZonedDateTime getStartDate() {
        Date date = this.certificateHolder.getNotBefore();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getNotBefore(...)");
        ZonedDateTime zonedDateTime = this.dateToZonedDateTime(date);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"dateToZonedDateTime(...)");
        return zonedDateTime;
    }

    @NotNull
    public final ZonedDateTime getExpiryDate() {
        Date date = this.certificateHolder.getNotAfter();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getNotAfter(...)");
        ZonedDateTime zonedDateTime = this.dateToZonedDateTime(date);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"dateToZonedDateTime(...)");
        return zonedDateTime;
    }

    private final BasicConstraints getBasicConstraints() {
        Lazy lazy = this.basicConstraints$delegate;
        return (BasicConstraints)lazy.getValue();
    }

    public final boolean isCA$awala() {
        Lazy lazy = this.isCA$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Certificate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.certificateHolder, (Object)((Certificate)other).certificateHolder);
    }

    public int hashCode() {
        return this.certificateHolder.hashCode();
    }

    @NotNull
    public final byte[] serialize() {
        byte[] byArray = this.certificateHolder.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @NotNull
    public final org.bouncycastle.asn1.x509.Certificate encode$awala() {
        org.bouncycastle.asn1.x509.Certificate certificate = this.certificateHolder.toASN1Structure();
        Intrinsics.checkNotNullExpressionValue((Object)certificate, (String)"toASN1Structure(...)");
        return certificate;
    }

    public final boolean isLikelyIssuer(@NotNull Certificate potentialIssuer) {
        Intrinsics.checkNotNullParameter((Object)potentialIssuer, (String)"potentialIssuer");
        return Intrinsics.areEqual((Object)this.certificateHolder.getIssuer(), (Object)potentialIssuer.certificateHolder.getSubject());
    }

    public final void validate() throws CertificateException {
        this.validateValidityPeriod();
        this.validateCommonNamePresence();
    }

    private final void validateValidityPeriod() {
        ZonedDateTime now = ZonedDateTime.now();
        if (now.compareTo(this.getStartDate()) < 0) {
            throw new CertificateException("Certificate is not yet valid", null, 2, null);
        }
        if (this.getExpiryDate().compareTo(now) < 0) {
            throw new CertificateException("Certificate already expired", null, 2, null);
        }
    }

    private final void validateCommonNamePresence() {
        RDN[] rDNArray = this.certificateHolder.getSubject().getRDNs(BCStyle.CN);
        Intrinsics.checkNotNullExpressionValue((Object)rDNArray, (String)"getRDNs(...)");
        if (((Object[])rDNArray).length == 0) {
            throw new CertificateException("Subject should have a Common Name", null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Certificate[] getCertificationPath(@NotNull Collection<Certificate> intermediateCAs, @NotNull Collection<Certificate> trustedCAs) throws CertificateException {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        PKIXCertPathBuilderResult pKIXCertPathBuilderResult;
        Intrinsics.checkNotNullParameter(intermediateCAs, (String)"intermediateCAs");
        Intrinsics.checkNotNullParameter(trustedCAs, (String)"trustedCAs");
        try {
            pKIXCertPathBuilderResult = this.buildPath(intermediateCAs, trustedCAs);
        }
        catch (CertPathBuilderException exc) {
            throw new CertificateException("No certification path could be found", exc);
        }
        PKIXCertPathBuilderResult pathBuilderResult = pKIXCertPathBuilderResult;
        List<? extends java.security.cert.Certificate> list = pathBuilderResult.getCertPath().getCertificates();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCertificates(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            java.security.cert.Certificate certificate = (java.security.cert.Certificate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new X509CertificateHolder(it.getEncoded()));
        }
        List bcCertPath = (List)destination$iv$iv;
        Iterable $this$map$iv2 = CollectionsKt.slice((List)bcCertPath, (IntRange)new IntRange(1, CollectionsKt.getLastIndex((List)bcCertPath)));
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            X509CertificateHolder bl = (X509CertificateHolder)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Iterable $this$single$iv = intermediateCAs;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                void copy;
                Certificate original = (Certificate)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)copy, (Object)original.certificateHolder)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            collection.add(single$iv);
        }
        List cAs = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
        X509CertificateHolder bcRootCACert = new X509CertificateHolder(pathBuilderResult.getTrustAnchor().getTrustedCert().getEncoded());
        if (!Intrinsics.areEqual((Object)bcRootCACert, (Object)this.certificateHolder)) {
            Iterable $this$single$iv = trustedCAs;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                Certificate it = (Certificate)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.certificateHolder, (Object)bcRootCACert)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Certificate rootCACert = single$iv;
            cAs.add(rootCACert);
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.add((Object)this);
        Collection $this$toTypedArray$iv = cAs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new Certificate[0]));
        return (Certificate[])spreadBuilder.toArray((Object[])new Certificate[spreadBuilder.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private final PKIXCertPathBuilderResult buildPath(Collection<Certificate> intermediateCAs, Collection<Certificate> trustedCAs) throws CertPathBuilderException {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        X509Certificate javaEndEntityCert = this.convertCertToJava(this);
        Iterable $this$map$iv = intermediateCAs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            Certificate certificate = (Certificate)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.convertCertToJava((Certificate)p0));
        }
        List javaIntermediateCACerts = (List)destination$iv$iv;
        Iterable $this$map$iv2 = trustedCAs;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            Certificate bl = (Certificate)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(this.convertCertToJava((Certificate)p0));
        }
        List javaTrustedCACerts = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = javaTrustedCACerts;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Object destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            X509Certificate bl2 = (X509Certificate)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(new TrustAnchor((X509Certificate)it, null));
        }
        Set trustAnchors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        CertStore intermediateCertStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(javaIntermediateCACerts), (Provider)CryptoUtils.getBC_PROVIDER());
        X509CertSelector endEntitySelector = new X509CertSelector();
        endEntitySelector.setCertificate(javaEndEntityCert);
        try {
            destination$iv$iv3 = new PKIXBuilderParameters(trustAnchors, (CertSelector)endEntitySelector);
        }
        catch (InvalidAlgorithmParameterException exc) {
            throw new CertificateException("Failed to initialize path builder; set of trusted CAs might be empty", exc);
        }
        Object parameters = destination$iv$iv3;
        ((PKIXParameters)parameters).setRevocationEnabled(false);
        ((PKIXParameters)parameters).addCertStore(intermediateCertStore);
        CertPathBuilder certPathBuilder = CertPathBuilder.getInstance("PKIX", (Provider)CryptoUtils.getBC_PROVIDER());
        Intrinsics.checkNotNullExpressionValue((Object)certPathBuilder, (String)"getInstance(...)");
        CertPathBuilder pathBuilder = certPathBuilder;
        CertPathBuilderResult certPathBuilderResult = pathBuilder.build((CertPathParameters)parameters);
        Intrinsics.checkNotNull((Object)certPathBuilderResult, (String)"null cannot be cast to non-null type java.security.cert.PKIXCertPathBuilderResult");
        return (PKIXCertPathBuilderResult)certPathBuilderResult;
    }

    private final X509Certificate convertCertToJava(Certificate certificate) {
        return bcToJavaCertificateConverter.getCertificate(certificate.certificateHolder);
    }

    private final ZonedDateTime dateToZonedDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault());
    }

    private static final BasicConstraints basicConstraints_delegate$lambda$0(Certificate this$0) {
        return BasicConstraints.fromExtensions((Extensions)this$0.certificateHolder.getExtensions());
    }

    private static final boolean isCA_delegate$lambda$1(Certificate this$0) {
        BasicConstraints basicConstraints = this$0.getBasicConstraints();
        return basicConstraints != null ? basicConstraints.isCA() : false;
    }

    static {
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter().setProvider((Provider)CryptoUtils.getBC_PROVIDER());
        Intrinsics.checkNotNullExpressionValue((Object)jcaX509CertificateConverter, (String)"setProvider(...)");
        bcToJavaCertificateConverter = jcaX509CertificateConverter;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JW\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u000e\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Ltech/relaycorp/relaynet/wrappers/x509/Certificate$Companion;", "", "<init>", "()V", "bcToJavaCertificateConverter", "Lorg/bouncycastle/cert/jcajce/JcaX509CertificateConverter;", "issue", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "subjectCommonName", "", "subjectPublicKey", "Ljava/security/PublicKey;", "issuerPrivateKey", "Ljava/security/PrivateKey;", "validityEndDate", "Ljava/time/ZonedDateTime;", "issuerCertificate", "isCA", "", "pathLenConstraint", "", "validityStartDate", "issue$awala", "buildDistinguishedName", "Lorg/bouncycastle/asn1/x500/X500Name;", "commonName", "deserialize", "certificateSerialized", "", "getCommonName", "x500Name", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Certificate issue$awala(@NotNull String subjectCommonName, @NotNull PublicKey subjectPublicKey, @NotNull PrivateKey issuerPrivateKey, @NotNull ZonedDateTime validityEndDate, @Nullable Certificate issuerCertificate, boolean isCA, int pathLenConstraint, @NotNull ZonedDateTime validityStartDate) throws CertificateException {
            ZonedDateTime expiryDate;
            Intrinsics.checkNotNullParameter((Object)subjectCommonName, (String)"subjectCommonName");
            Intrinsics.checkNotNullParameter((Object)subjectPublicKey, (String)"subjectPublicKey");
            Intrinsics.checkNotNullParameter((Object)issuerPrivateKey, (String)"issuerPrivateKey");
            Intrinsics.checkNotNullParameter((Object)validityEndDate, (String)"validityEndDate");
            Intrinsics.checkNotNullParameter((Object)validityStartDate, (String)"validityStartDate");
            ZonedDateTime zonedDateTime = expiryDate = issuerCertificate != null ? (ZonedDateTime)ComparisonsKt.minOf((Comparable)issuerCertificate.getExpiryDate(), (Comparable)validityEndDate) : validityEndDate;
            if (validityStartDate.compareTo(expiryDate) >= 0) {
                throw new CertificateException("The end date must be later than the start date", null, 2, null);
            }
            if (issuerCertificate != null && !issuerCertificate.isCA$awala()) {
                throw new CertificateException("Issuer certificate should be marked as CA", null, 2, null);
            }
            X500Name subjectDistinguishedName = this.buildDistinguishedName(subjectCommonName);
            X500Name issuerDistinguishedName = issuerCertificate != null ? issuerCertificate.getCertificateHolder$awala().getSubject() : subjectDistinguishedName;
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)subjectPublicKey.getEncoded());
            X509v3CertificateBuilder builder = new X509v3CertificateBuilder(issuerDistinguishedName, PRNGKt.generateRandomBigInteger(), Date.from(validityStartDate.toInstant()), Date.from(expiryDate.toInstant()), subjectDistinguishedName, subjectPublicKeyInfo);
            BasicConstraintsExtension basicConstraints = new BasicConstraintsExtension(isCA, pathLenConstraint);
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)basicConstraints);
            byte[] byArray = subjectPublicKeyInfo.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            byte[] subjectPublicKeyDigest = CryptoUtils.getSHA256Digest(byArray);
            SubjectKeyIdentifier subjectSKI = new SubjectKeyIdentifier(subjectPublicKeyDigest);
            builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)subjectSKI);
            SubjectKeyIdentifier issuerSKI = subjectSKI;
            if (issuerCertificate != null) {
                SubjectKeyIdentifier subjectKeyIdentifier = SubjectKeyIdentifier.fromExtensions((Extensions)issuerCertificate.getCertificateHolder$awala().getExtensions());
                if (subjectKeyIdentifier == null) {
                    throw new CertificateException("Issuer must have the SubjectKeyIdentifier extension", null, 2, null);
                }
                issuerSKI = subjectKeyIdentifier;
            }
            AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(issuerSKI.getKeyIdentifier());
            builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)aki);
            ContentSigner signer = new JcaContentSignerBuilder("SHA256WITHRSAANDMGF1").setProvider((Provider)CryptoUtils.getBC_PROVIDER()).build(issuerPrivateKey);
            X509CertificateHolder certificateHolder = builder.build(signer);
            Intrinsics.checkNotNull((Object)certificateHolder);
            return new Certificate(certificateHolder);
        }

        public static /* synthetic */ Certificate issue$awala$default(Companion companion, String string, PublicKey publicKey, PrivateKey privateKey, ZonedDateTime zonedDateTime, Certificate certificate, boolean bl, int n, ZonedDateTime zonedDateTime2, int n2, Object object) throws CertificateException {
            if ((n2 & 0x10) != 0) {
                certificate = null;
            }
            if ((n2 & 0x20) != 0) {
                bl = false;
            }
            if ((n2 & 0x40) != 0) {
                n = 0;
            }
            if ((n2 & 0x80) != 0) {
                zonedDateTime2 = ZonedDateTime.now();
            }
            return companion.issue$awala(string, publicKey, privateKey, zonedDateTime, certificate, bl, n, zonedDateTime2);
        }

        private final X500Name buildDistinguishedName(String commonName) throws CertificateException {
            X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
            builder.addRDN(BCStyle.CN, (ASN1Encodable)new DERBMPString(commonName));
            X500Name x500Name = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)x500Name, (String)"build(...)");
            return x500Name;
        }

        @NotNull
        public final Certificate deserialize(@NotNull byte[] certificateSerialized) throws CertificateException {
            X509CertificateHolder x509CertificateHolder;
            Intrinsics.checkNotNullParameter((Object)certificateSerialized, (String)"certificateSerialized");
            try {
                x509CertificateHolder = new X509CertificateHolder(certificateSerialized);
            }
            catch (IOException exc) {
                throw new CertificateException("Value should be a DER-encoded, X.509 v3 certificate", exc);
            }
            X509CertificateHolder certificateHolder = x509CertificateHolder;
            return new Certificate(certificateHolder);
        }

        private final String getCommonName(X500Name x500Name) {
            Object[] commonNames = x500Name.getRDNs(BCStyle.CN);
            Intrinsics.checkNotNull((Object)commonNames);
            return ((RDN)ArraysKt.first((Object[])commonNames)).getFirst().getValue().toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

