/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.cms;

import java.math.BigInteger;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.jcajce.JcaAlgorithmParametersConverter;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.SymmetricCipher;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedData;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataException;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataKt;
import tech.relaycorp.relaynet.wrappers.cms.RecipientIdentifier;
import tech.relaycorp.relaynet.wrappers.cms.RecipientSerialNumber;
import tech.relaycorp.relaynet.wrappers.x509.Certificate;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionlessEnvelopedData;", "Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "bcEnvelopedData", "Lorg/bouncycastle/cms/CMSEnvelopedData;", "<init>", "(Lorg/bouncycastle/cms/CMSEnvelopedData;)V", "getRecipientKeyId", "Ltech/relaycorp/relaynet/wrappers/cms/RecipientIdentifier;", "validate", "", "Companion", "awala"})
public final class SessionlessEnvelopedData
extends EnvelopedData {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SessionlessEnvelopedData(@NotNull CMSEnvelopedData bcEnvelopedData) {
        Intrinsics.checkNotNullParameter((Object)bcEnvelopedData, (String)"bcEnvelopedData");
        super(bcEnvelopedData);
    }

    @Override
    @NotNull
    public RecipientIdentifier getRecipientKeyId() {
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkNotNullExpressionValue((Object)recipientInformationStore, (String)"getRecipientInfos(...)");
        RecipientId recipientId = ((RecipientInformation)CollectionsKt.first((Iterable)((Iterable)recipientInformationStore))).getRID();
        Intrinsics.checkNotNull((Object)recipientId, (String)"null cannot be cast to non-null type org.bouncycastle.cms.KeyTransRecipientId");
        KeyTransRecipientId rid = (KeyTransRecipientId)recipientId;
        BigInteger bigInteger = rid.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"getSerialNumber(...)");
        return new RecipientSerialNumber(bigInteger);
    }

    @Override
    protected void validate() throws EnvelopedDataException {
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkNotNullExpressionValue((Object)recipientInformationStore, (String)"getRecipientInfos(...)");
        RecipientId recipientId = ((RecipientInformation)CollectionsKt.first((Iterable)((Iterable)recipientInformationStore))).getRID();
        Intrinsics.checkNotNull((Object)recipientId, (String)"null cannot be cast to non-null type org.bouncycastle.cms.KeyTransRecipientId");
        KeyTransRecipientId rid = (KeyTransRecipientId)recipientId;
        if (rid.getSerialNumber() == null) {
            throw new EnvelopedDataException("Required recipient key id to be IssuerAndSerialNumber (got SubjectKeyIdentifier)", null, 2, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionlessEnvelopedData$Companion;", "", "<init>", "()V", "encrypt", "Ltech/relaycorp/relaynet/wrappers/cms/SessionlessEnvelopedData;", "plaintext", "", "recipientCertificate", "Ltech/relaycorp/relaynet/wrappers/x509/Certificate;", "symmetricCipher", "Ltech/relaycorp/relaynet/SymmetricCipher;", "makeRecipientInfoGenerator", "Lorg/bouncycastle/cms/jcajce/JceKeyTransRecipientInfoGenerator;", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionlessEnvelopedData encrypt(@NotNull byte[] plaintext, @NotNull Certificate recipientCertificate, @NotNull SymmetricCipher symmetricCipher) {
            Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
            Intrinsics.checkNotNullParameter((Object)recipientCertificate, (String)"recipientCertificate");
            Intrinsics.checkNotNullParameter((Object)((Object)symmetricCipher), (String)"symmetricCipher");
            JceKeyTransRecipientInfoGenerator recipientInfoGenerator = this.makeRecipientInfoGenerator(recipientCertificate);
            CMSEnvelopedData bcEnvelopedData = EnvelopedDataKt.bcEncrypt$default(plaintext, symmetricCipher, (RecipientInfoGenerator)recipientInfoGenerator, null, 8, null);
            return new SessionlessEnvelopedData(bcEnvelopedData);
        }

        public static /* synthetic */ SessionlessEnvelopedData encrypt$default(Companion companion, byte[] byArray, Certificate certificate, SymmetricCipher symmetricCipher, int n, Object object) {
            if ((n & 4) != 0) {
                symmetricCipher = SymmetricCipher.AES_128;
            }
            return companion.encrypt(byArray, certificate, symmetricCipher);
        }

        private final JceKeyTransRecipientInfoGenerator makeRecipientInfoGenerator(Certificate recipientCertificate) {
            X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(recipientCertificate.getCertificateHolder$awala());
            AlgorithmIdentifier algorithmIdentifier = new JcaAlgorithmParametersConverter().getAlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (AlgorithmParameterSpec)new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT));
            JceKeyTransRecipientInfoGenerator jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(x509Certificate, algorithmIdentifier).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
            Intrinsics.checkNotNullExpressionValue((Object)jceKeyTransRecipientInfoGenerator, (String)"setProvider(...)");
            return jceKeyTransRecipientInfoGenerator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

