/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.cms;

import java.security.Provider;
import java.util.Hashtable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.KeyAgreeRecipientId;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyAgreeRecipientInfoGenerator;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.HashingAlgorithm;
import tech.relaycorp.relaynet.OIDs;
import tech.relaycorp.relaynet.SessionKey;
import tech.relaycorp.relaynet.SessionKeyPair;
import tech.relaycorp.relaynet.SymmetricCipher;
import tech.relaycorp.relaynet.wrappers.Keys;
import tech.relaycorp.relaynet.wrappers.PRNGKt;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedData;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataException;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataKt;
import tech.relaycorp.relaynet.wrappers.cms.RecipientKeyIdentifier;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionEnvelopedData;", "Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "bcEnvelopedData", "Lorg/bouncycastle/cms/CMSEnvelopedData;", "<init>", "(Lorg/bouncycastle/cms/CMSEnvelopedData;)V", "getRecipientKeyId", "Ltech/relaycorp/relaynet/wrappers/cms/RecipientKeyIdentifier;", "getOriginatorKey", "Ltech/relaycorp/relaynet/SessionKey;", "validate", "", "Companion", "awala"})
public final class SessionEnvelopedData
extends EnvelopedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<HashingAlgorithm, ASN1ObjectIdentifier> ecdhAlgorithmByHashingAlgorithm;

    public SessionEnvelopedData(@NotNull CMSEnvelopedData bcEnvelopedData) {
        Intrinsics.checkNotNullParameter((Object)bcEnvelopedData, (String)"bcEnvelopedData");
        super(bcEnvelopedData);
    }

    @Override
    @NotNull
    public RecipientKeyIdentifier getRecipientKeyId() {
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkNotNullExpressionValue((Object)recipientInformationStore, (String)"getRecipientInfos(...)");
        RecipientId recipientId = ((RecipientInformation)CollectionsKt.first((Iterable)((Iterable)recipientInformationStore))).getRID();
        Intrinsics.checkNotNull((Object)recipientId, (String)"null cannot be cast to non-null type org.bouncycastle.cms.KeyAgreeRecipientId");
        KeyAgreeRecipientId rid = (KeyAgreeRecipientId)recipientId;
        byte[] byArray = rid.getSubjectKeyIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getSubjectKeyIdentifier(...)");
        return new RecipientKeyIdentifier(byArray);
    }

    @NotNull
    public final SessionKey getOriginatorKey() {
        Attribute originatorKeyIdAttribute = this.getBcEnvelopedData().getUnprotectedAttributes().get(OIDs.INSTANCE.getORIGINATOR_EPHEMERAL_CERT_SERIAL_NUMBER());
        ASN1Encodable aSN1Encodable = originatorKeyIdAttribute.getAttrValues().getObjectAt(0);
        Intrinsics.checkNotNull((Object)aSN1Encodable, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.DEROctetString");
        DEROctetString keyIdASN1 = (DEROctetString)aSN1Encodable;
        RecipientInformationStore recipientInformationStore = this.getBcEnvelopedData().getRecipientInfos();
        Intrinsics.checkNotNullExpressionValue((Object)recipientInformationStore, (String)"getRecipientInfos(...)");
        Object object = CollectionsKt.first((Iterable)((Iterable)recipientInformationStore));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bouncycastle.cms.KeyAgreeRecipientInformation");
        KeyAgreeRecipientInformation recipientInfo = (KeyAgreeRecipientInformation)object;
        OriginatorIdentifierOrKey originator = recipientInfo.getOriginator();
        byte[] byArray = keyIdASN1.getOctets();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getOctets(...)");
        byte[] byArray2 = originator.getOriginatorKey().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
        return new SessionKey(byArray, Keys.deserializeECPublicKey(byArray2));
    }

    @Override
    protected void validate() {
        AttributeTable attributeTable = this.getBcEnvelopedData().getUnprotectedAttributes();
        if (attributeTable == null) {
            throw new EnvelopedDataException("unprotectedAttrs is missing", null, 2, null);
        }
        AttributeTable unprotectedAttrs = attributeTable;
        if (unprotectedAttrs.size() == 0) {
            throw new EnvelopedDataException("unprotectedAttrs is empty", null, 2, null);
        }
        Attribute attribute = unprotectedAttrs.get(OIDs.INSTANCE.getORIGINATOR_EPHEMERAL_CERT_SERIAL_NUMBER());
        if (attribute == null) {
            throw new EnvelopedDataException("Originator key id is missing from unprotectedAttrs", null, 2, null);
        }
        Attribute originatorKeyIdAttributeContainer = attribute;
        if (originatorKeyIdAttributeContainer.getAttrValues().size() == 0) {
            throw new EnvelopedDataException("Originator key id is empty", null, 2, null);
        }
        if (1 < originatorKeyIdAttributeContainer.getAttrValues().size()) {
            throw new EnvelopedDataException("Originator key id has multiple values", null, 2, null);
        }
        ASN1Encodable originatorKeyIdAttribute = originatorKeyIdAttributeContainer.getAttrValues().getObjectAt(0);
        if (!(originatorKeyIdAttribute instanceof DEROctetString)) {
            throw new EnvelopedDataException("Originator key id is not an OCTET STRING", null, 2, null);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)HashingAlgorithm.SHA256), (Object)CMSAlgorithm.ECDH_SHA256KDF), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA384), (Object)CMSAlgorithm.ECDH_SHA384KDF), TuplesKt.to((Object)((Object)HashingAlgorithm.SHA512), (Object)CMSAlgorithm.ECDH_SHA512KDF)};
        ecdhAlgorithmByHashingAlgorithm = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0006J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R%\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/SessionEnvelopedData$Companion;", "", "<init>", "()V", "ecdhAlgorithmByHashingAlgorithm", "", "Ltech/relaycorp/relaynet/HashingAlgorithm;", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "kotlin.jvm.PlatformType", "getEcdhAlgorithmByHashingAlgorithm", "()Ljava/util/Map;", "encrypt", "Ltech/relaycorp/relaynet/wrappers/cms/SessionEnvelopedData;", "plaintext", "", "recipientKey", "Ltech/relaycorp/relaynet/SessionKey;", "senderKeyPair", "Ltech/relaycorp/relaynet/SessionKeyPair;", "symmetricCipher", "Ltech/relaycorp/relaynet/SymmetricCipher;", "hashingAlgorithm", "makeRecipientInfoGenerator", "Lorg/bouncycastle/cms/jcajce/JceKeyAgreeRecipientInfoGenerator;", "originatorKeyPair", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<HashingAlgorithm, ASN1ObjectIdentifier> getEcdhAlgorithmByHashingAlgorithm() {
            return ecdhAlgorithmByHashingAlgorithm;
        }

        @NotNull
        public final SessionEnvelopedData encrypt(@NotNull byte[] plaintext, @NotNull SessionKey recipientKey, @NotNull SessionKeyPair senderKeyPair, @NotNull SymmetricCipher symmetricCipher, @NotNull HashingAlgorithm hashingAlgorithm) {
            Intrinsics.checkNotNullParameter((Object)plaintext, (String)"plaintext");
            Intrinsics.checkNotNullParameter((Object)recipientKey, (String)"recipientKey");
            Intrinsics.checkNotNullParameter((Object)senderKeyPair, (String)"senderKeyPair");
            Intrinsics.checkNotNullParameter((Object)((Object)symmetricCipher), (String)"symmetricCipher");
            Intrinsics.checkNotNullParameter((Object)((Object)hashingAlgorithm), (String)"hashingAlgorithm");
            JceKeyAgreeRecipientInfoGenerator recipientInfoGenerator = this.makeRecipientInfoGenerator(senderKeyPair, symmetricCipher, hashingAlgorithm);
            recipientInfoGenerator.addRecipient(recipientKey.getKeyId(), recipientKey.getPublicKey());
            Hashtable unprotectedAttrs = new Hashtable();
            ((Map)unprotectedAttrs).put(OIDs.INSTANCE.getORIGINATOR_EPHEMERAL_CERT_SERIAL_NUMBER(), new Attribute(OIDs.INSTANCE.getORIGINATOR_EPHEMERAL_CERT_SERIAL_NUMBER(), (ASN1Set)new DERSet((ASN1Encodable)new DEROctetString(senderKeyPair.getSessionKey().getKeyId()))));
            CMSEnvelopedData bcEnvelopedData = EnvelopedDataKt.access$bcEncrypt(plaintext, symmetricCipher, (RecipientInfoGenerator)recipientInfoGenerator, new AttributeTable(unprotectedAttrs));
            return new SessionEnvelopedData(bcEnvelopedData);
        }

        public static /* synthetic */ SessionEnvelopedData encrypt$default(Companion companion, byte[] byArray, SessionKey sessionKey, SessionKeyPair sessionKeyPair, SymmetricCipher symmetricCipher, HashingAlgorithm hashingAlgorithm, int n, Object object) {
            if ((n & 8) != 0) {
                symmetricCipher = SymmetricCipher.AES_128;
            }
            if ((n & 0x10) != 0) {
                hashingAlgorithm = HashingAlgorithm.SHA256;
            }
            return companion.encrypt(byArray, sessionKey, sessionKeyPair, symmetricCipher, hashingAlgorithm);
        }

        private final JceKeyAgreeRecipientInfoGenerator makeRecipientInfoGenerator(SessionKeyPair originatorKeyPair, SymmetricCipher symmetricCipher, HashingAlgorithm hashingAlgorithm) {
            ASN1ObjectIdentifier ecdhAlgorithm = this.getEcdhAlgorithmByHashingAlgorithm().get((Object)hashingAlgorithm);
            ASN1ObjectIdentifier keyWrapCipher = EnvelopedDataKt.getCMS_KW_ALGORITHMS().get((Object)symmetricCipher);
            JceKeyAgreeRecipientInfoGenerator jceKeyAgreeRecipientInfoGenerator = new JceKeyAgreeRecipientInfoGenerator(ecdhAlgorithm, originatorKeyPair.getPrivateKey(), originatorKeyPair.getSessionKey().getPublicKey(), keyWrapCipher).setUserKeyingMaterial(PRNGKt.generateRandomOctets(64)).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
            Intrinsics.checkNotNullExpressionValue((Object)jceKeyAgreeRecipientInfoGenerator, (String)"setProvider(...)");
            return jceKeyAgreeRecipientInfoGenerator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

