/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.relaynet.wrappers.cms;

import java.security.PrivateKey;
import java.security.Provider;
import java.security.interfaces.ECKey;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.jcajce.JceKeyAgreeEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.relaynet.CryptoUtils;
import tech.relaycorp.relaynet.wrappers.cms.EnvelopedDataException;
import tech.relaycorp.relaynet.wrappers.cms.RecipientIdentifier;
import tech.relaycorp.relaynet.wrappers.cms.SessionEnvelopedData;
import tech.relaycorp.relaynet.wrappers.cms.SessionlessEnvelopedData;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u0010H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "", "bcEnvelopedData", "Lorg/bouncycastle/cms/CMSEnvelopedData;", "<init>", "(Lorg/bouncycastle/cms/CMSEnvelopedData;)V", "getBcEnvelopedData", "()Lorg/bouncycastle/cms/CMSEnvelopedData;", "serialize", "", "decrypt", "privateKey", "Ljava/security/PrivateKey;", "getRecipientKeyId", "Ltech/relaycorp/relaynet/wrappers/cms/RecipientIdentifier;", "validate", "", "Companion", "awala"})
public abstract class EnvelopedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CMSEnvelopedData bcEnvelopedData;

    public EnvelopedData(@NotNull CMSEnvelopedData bcEnvelopedData) {
        Intrinsics.checkNotNullParameter((Object)bcEnvelopedData, (String)"bcEnvelopedData");
        this.bcEnvelopedData = bcEnvelopedData;
    }

    @NotNull
    public final CMSEnvelopedData getBcEnvelopedData() {
        return this.bcEnvelopedData;
    }

    @NotNull
    public final byte[] serialize() {
        byte[] byArray = this.bcEnvelopedData.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @NotNull
    public final byte[] decrypt(@NotNull PrivateKey privateKey) throws EnvelopedDataException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Collection recipients = this.bcEnvelopedData.getRecipientInfos().getRecipients();
        Intrinsics.checkNotNull((Object)recipients);
        RecipientInformation recipientInfo = (RecipientInformation)CollectionsKt.first((Iterable)recipients);
        Recipient recipient = privateKey instanceof ECKey ? (Recipient)new JceKeyAgreeEnvelopedRecipient(privateKey).setProvider((Provider)CryptoUtils.getBC_PROVIDER()) : (Recipient)new JceKeyTransEnvelopedRecipient(privateKey).setProvider((Provider)CryptoUtils.getBC_PROVIDER());
        try {
            byArray = recipientInfo.getContent(recipient);
            Intrinsics.checkNotNull((Object)byArray);
        }
        catch (Exception exception) {
            throw new EnvelopedDataException("Could not decrypt value", exception);
        }
        return byArray;
    }

    @NotNull
    public abstract RecipientIdentifier getRecipientKeyId();

    protected abstract void validate() throws EnvelopedDataException;

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData$Companion;", "", "<init>", "()V", "deserialize", "Ltech/relaycorp/relaynet/wrappers/cms/EnvelopedData;", "envelopedDataSerialized", "", "awala"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnvelopedData deserialize(@NotNull byte[] envelopedDataSerialized) throws EnvelopedDataException {
            EnvelopedData envelopedData;
            CMSEnvelopedData cMSEnvelopedData;
            Intrinsics.checkNotNullParameter((Object)envelopedDataSerialized, (String)"envelopedDataSerialized");
            try {
                cMSEnvelopedData = new CMSEnvelopedData(envelopedDataSerialized);
            }
            catch (CMSException exception) {
                throw new EnvelopedDataException("Value should be a DER-encoded CMS EnvelopedData", exception);
            }
            CMSEnvelopedData bcEnvelopedData = cMSEnvelopedData;
            int recipientsSize = bcEnvelopedData.getRecipientInfos().size();
            if (recipientsSize != 1) {
                throw new EnvelopedDataException("Exactly one RecipientInfo is required (got " + recipientsSize + ")", null, 2, null);
            }
            RecipientInformationStore recipientInformationStore = bcEnvelopedData.getRecipientInfos();
            Intrinsics.checkNotNullExpressionValue((Object)recipientInformationStore, (String)"getRecipientInfos(...)");
            RecipientInformation recipient = (RecipientInformation)CollectionsKt.first((Iterable)((Iterable)recipientInformationStore));
            if (recipient instanceof KeyTransRecipientInformation) {
                envelopedData = new SessionlessEnvelopedData(bcEnvelopedData);
            } else if (recipient instanceof KeyAgreeRecipientInformation) {
                envelopedData = new SessionEnvelopedData(bcEnvelopedData);
            } else {
                throw new EnvelopedDataException("Unsupported RecipientInfo (got " + recipient.getClass().getSimpleName() + ")", null, 2, null);
            }
            EnvelopedData envelopedData2 = envelopedData;
            envelopedData2.validate();
            return envelopedData2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

